/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.browser.j2ee;

import java.io.IOException;
import javax.management.IntrospectionException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import oracle.jdeveloper.cm.dt.browser.CBBaseNode;
import oracle.jdeveloper.cm.dt.browser.j2ee.InvokeException;
import oracle.jdeveloper.cm.dt.browser.j2ee.Jsr77Exception;
import oracle.jdeveloper.cm.dt.browser.j2ee.ManagementAccess;
import oracle.jdeveloper.cm.dt.browser.j2ee.StateManageableObject;

public abstract class ManagedObjectNode
extends CBBaseNode {
    private ObjectName _name;
    private ManagementAccess _mgmt;
    private MBeanInfo _info;
    private Boolean _stateManageable;
    private Boolean _eventProvider;
    private Boolean _statsProvider;
    private StateManageableObject _smo;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected ManagedObjectNode() {
    }

    static {
        $assertionsDisabled = ManagedObjectNode.class.desiredAssertionStatus() ^ true;
    }

    public void init(ObjectName objectName, ManagementAccess managementAccess) throws Jsr77Exception {
        if (!$assertionsDisabled && objectName == null) {
            throw new AssertionError();
        }
        this._name = objectName;
        this._mgmt = managementAccess;
        String string = objectName.getKeyProperty("name");
        if (string != null) {
            this.setName(string);
        } else {
            this.setName(objectName.toString());
        }
        this._info = null;
        this.getMBeanInfo();
    }

    public void setName(String string) {
        int n;
        int n2;
        if (string != null && (n2 = string.indexOf(34)) == 0 && (n = string.indexOf(34, n2 + 1)) == string.length() - 1) {
            string = string.substring(1, string.length() - 1);
        }
        super.setName(string);
    }

    public ObjectName getObjectName() {
        return this._name;
    }

    protected ManagementAccess getServer() {
        return this._mgmt;
    }

    public boolean isStateManageable() {
        if (this._stateManageable == null) {
            try {
                this._stateManageable = (Boolean)this._mgmt.getAttribute(this._name, "stateManageable");
            }
            catch (Exception exception) {
                this._stateManageable = Boolean.FALSE;
            }
        }
        return this._stateManageable;
    }

    public StateManageableObject getManageableObject() {
        if (this.isStateManageable() && this._smo == null) {
            this._smo = this.createStateManageableObject();
        }
        return this._smo;
    }

    public boolean isEventProvider() {
        if (this._eventProvider == null) {
            try {
                this._eventProvider = (Boolean)this._mgmt.getAttribute(this._name, "eventProvider");
            }
            catch (Exception exception) {
                this._eventProvider = Boolean.FALSE;
            }
        }
        return this._eventProvider;
    }

    public boolean isStatisticsProvider() {
        if (this._statsProvider == null) {
            try {
                this._statsProvider = (Boolean)this._mgmt.getAttribute(this._name, "statisticsProvider");
            }
            catch (Exception exception) {
                this._statsProvider = Boolean.FALSE;
            }
        }
        return this._statsProvider;
    }

    public MBeanOperationInfo[] getOperations() throws Jsr77Exception {
        MBeanInfo mBeanInfo = this.getMBeanInfo();
        if (mBeanInfo == null) {
            throw new Jsr77Exception(new IntrospectionException("Cannot get MBeanInfo"));
        }
        return mBeanInfo.getOperations();
    }

    public MBeanNotificationInfo[] getNotifications() throws Jsr77Exception {
        MBeanInfo mBeanInfo = this.getMBeanInfo();
        if (mBeanInfo == null) {
            throw new Jsr77Exception(new IntrospectionException("Cannot get MBeanInfo"));
        }
        return mBeanInfo.getNotifications();
    }

    public Object getAttributeValue(String string) throws Jsr77Exception {
        try {
            Object object = this._mgmt.getAttribute(this._name, string);
            return object;
        }
        catch (JMException jMException) {
            throw new Jsr77Exception(jMException);
        }
        catch (IOException iOException) {
            throw new Jsr77Exception(iOException);
        }
    }

    public Object invokeOperation(MBeanOperationInfo mBeanOperationInfo, Object[] objectArray) throws InvokeException {
        String[] stringArray;
        Object object = null;
        String string = mBeanOperationInfo.getName();
        MBeanParameterInfo[] mBeanParameterInfoArray = mBeanOperationInfo.getSignature();
        String[] stringArray2 = stringArray = mBeanParameterInfoArray != null ? new String[mBeanParameterInfoArray.length] : null;
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = mBeanParameterInfoArray[n].getType();
                ++n;
            }
        }
        try {
            object = this._mgmt.invoke(this._name, string, objectArray, stringArray);
        }
        catch (JMException jMException) {
            throw new InvokeException(jMException);
        }
        catch (IOException iOException) {
            throw new InvokeException(iOException);
        }
        return object;
    }

    public MBeanAttributeInfo[] getBeanAttributes() throws Jsr77Exception {
        MBeanInfo mBeanInfo = this.getMBeanInfo();
        if (mBeanInfo == null) {
            throw new Jsr77Exception(new IntrospectionException("Cannot get MBeanInfo"));
        }
        return mBeanInfo.getAttributes();
    }

    private MBeanInfo getMBeanInfo() throws Jsr77Exception {
        if (this._info == null) {
            try {
                this._info = this._mgmt.getMBeanInfo(this._name);
            }
            catch (JMException jMException) {
                throw new Jsr77Exception(jMException);
            }
            catch (IOException iOException) {
                throw new Jsr77Exception(iOException);
            }
        }
        return this._info;
    }

    protected StateManageableObject createStateManageableObject() {
        return new StateManageableDelegate();
    }

    protected ObjectName getObjectNameValue(String string) throws Jsr77Exception {
        return this.convertToObjectName(this.getAttributeValue(string));
    }

    protected ObjectName convertToObjectName(Object object) {
        ObjectName objectName = null;
        if (object instanceof ObjectName) {
            objectName = (ObjectName)object;
        } else {
            try {
                if (object != null) {
                    objectName = new ObjectName(object.toString());
                }
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                // empty catch block
            }
        }
        return objectName;
    }

    static ManagementAccess ra$_mgmt(ManagedObjectNode managedObjectNode) {
        return managedObjectNode._mgmt;
    }

    static ObjectName ra$_name(ManagedObjectNode managedObjectNode) {
        return managedObjectNode._name;
    }

    protected class StateManageableDelegate
    implements StateManageableObject {
        private int _state;
        private long _start;

        void $init$() {
            this._state = -1;
            this._start = 1L;
        }

        public int getState() {
            if (this._state == -1) {
                try {
                    this._state = (Integer)ManagedObjectNode.this.getAttributeValue("state");
                }
                catch (Jsr77Exception jsr77Exception) {
                    // empty catch block
                }
            }
            return this._state;
        }

        public long getStartTime() {
            if (this._start > 0L) {
                try {
                    this._start = (Long)ManagedObjectNode.this.getAttributeValue("state");
                }
                catch (Jsr77Exception jsr77Exception) {
                    // empty catch block
                }
            }
            return this._start;
        }

        public void start() throws InvokeException {
            try {
                ManagedObjectNode.ra$_mgmt(ManagedObjectNode.this).invoke(ManagedObjectNode.ra$_name(ManagedObjectNode.this), "start", null, null);
            }
            catch (JMException jMException) {
                throw new InvokeException(jMException);
            }
            catch (IOException iOException) {
                throw new InvokeException(iOException);
            }
        }

        public void startRecursive() throws InvokeException {
            try {
                ManagedObjectNode.ra$_mgmt(ManagedObjectNode.this).invoke(ManagedObjectNode.ra$_name(ManagedObjectNode.this), "startRecursive", null, null);
            }
            catch (JMException jMException) {
                throw new InvokeException(jMException);
            }
            catch (IOException iOException) {
                throw new InvokeException(iOException);
            }
        }

        public void stop() throws InvokeException {
            try {
                ManagedObjectNode.ra$_mgmt(ManagedObjectNode.this).invoke(ManagedObjectNode.ra$_name(ManagedObjectNode.this), "stop", null, null);
            }
            catch (JMException jMException) {
                throw new InvokeException(jMException);
            }
            catch (IOException iOException) {
                throw new InvokeException(iOException);
            }
        }

        public boolean canUndeploy() {
            return false;
        }

        public void undeploy() throws Jsr77Exception {
            throw new Jsr77Exception("Undeploy not supported");
        }

        protected StateManageableDelegate() {
            this.$init$();
        }
    }
}

