/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.browser.jdbc;

import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.ModelUtil;
import oracle.javatools.db.Database;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.browser.jdbc.JavaObjectNode;
import oracle.jdeveloper.cm.dt.browser.jdbc.JdbcNodeFactory;
import oracle.jdeveloper.cm.dt.browser.jdbc.OCBBaseFolder;

public class JavaObjectFolder
extends OCBBaseFolder
implements Comparable {
    private static final String QUERY_LIST_DEPLOYED_JAVA = "SELECT DISTINCT SUBSTR(NVL(longname,object_name), 1,                        INSTR(NVL(longname, object_name),                              ''/'', 1, {0}) - 1) AS NAME,        0 AS IS_LEAF,       ''JAVA CLASS'' AS UNUSED_OBJECT_TYPE   FROM all_objects, javasnm WHERE owner = ?   AND (object_type = ''JAVA CLASS'' OR        object_type = ''JAVA SOURCE'' OR        object_type = ''JAVA RESOURCE'')   AND object_name = short(+)   AND NVL(longname,object_name) LIKE ? UNION SELECT DISTINCT NVL(longname,object_name), 1, OBJECT_TYPE  FROM all_objects, javasnm WHERE owner = ?   AND (object_type = ''JAVA CLASS'' OR        object_type = ''JAVA SOURCE'' OR        object_type = ''JAVA RESOURCE'')   AND object_name = short(+)   AND NVL(longname,object_name) LIKE ?    AND NVL(longname,object_name) NOT LIKE ?  ORDER BY 2, 1";

    public JavaObjectFolder(URL uRL, Database database) {
        super(uRL, database);
        String string;
        if (!CmUtil.isFolder(uRL) && ModelUtil.hasLength((String)(string = CmUtil.getName(uRL)))) {
            int n = string.lastIndexOf(47);
            this.setName(string.substring(n + 1));
        }
    }

    public boolean canBeFiltered() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getChildrenList() {
        Connection connection;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        URL uRL = this.getURL();
        Database database = this.getDatabase();
        String string = CmUtil.getConnName(uRL);
        String string2 = CmUtil.getUserName(uRL);
        String string3 = CmUtil.isFolder(uRL) ? null : CmUtil.getName(uRL);
        Connection connection2 = connection = database.getConnection();
        synchronized (connection2) {
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                int n = 1;
                if (string3 != null) {
                    if (string3.startsWith("/")) {
                        string3 = string3.substring(1);
                    }
                    if (!string3.endsWith("/")) {
                        string3 = string3 + "/";
                    }
                    String string4 = string3;
                    int n2 = string4.indexOf(47);
                    while (n2 >= 0) {
                        ++n;
                        string4 = string4.substring(n2 + 1);
                        n2 = string4.indexOf(47);
                    }
                } else {
                    string3 = "";
                }
                Object[] objectArray = new Object[]{new Integer(n)};
                String string5 = MessageFormat.format(QUERY_LIST_DEPLOYED_JAVA, objectArray);
                preparedStatement = connection.prepareStatement(string5);
                preparedStatement.setString(1, string2);
                preparedStatement.setString(2, string3 + "%/%");
                preparedStatement.setString(3, string2);
                preparedStatement.setString(4, string3 + "%");
                preparedStatement.setString(5, string3 + "%/%");
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    String string6;
                    String string7 = resultSet.getString(1);
                    if (resultSet.getInt(2) == 1) {
                        string6 = resultSet.getString(3);
                        if ("JAVA CLASS".equals(string6)) {
                            string7 = string7 + ".class";
                        } else if ("JAVA SOURCE".equals(string6)) {
                            string7 = string7 + ".java";
                        }
                    } else {
                        string6 = "JAVA";
                    }
                    URL uRL2 = CmUtil.getNodeURL(string, null, string2, string6, "/" + string7);
                    Node node = "JAVA".equals(string6) ? JdbcNodeFactory.getFolder(uRL2, database, null) : JdbcNodeFactory.getNode(database, uRL2);
                    arrayList.add(node);
                }
            }
            catch (SQLException sQLException) {
                arrayList.clear();
            }
        }
        return arrayList;
    }

    public Icon getIcon() {
        return CmUtil.isFolder(this.getURL()) ? super.getIcon() : null;
    }

    public int compareTo(Object object) {
        if (object instanceof JavaObjectNode) {
            return -1;
        }
        return super.compareTo(object);
    }

    public boolean remove(Element element) {
        int n;
        String string;
        int n2;
        String string2;
        if (this.containsChild(element)) {
            return super.remove(element);
        }
        boolean bl = false;
        URL uRL = ((Locatable)element).getURL();
        String string3 = CmUtil.getName(uRL);
        URL uRL2 = this.getURL();
        String string4 = string2 = CmUtil.isFolder(uRL2) ? "" : CmUtil.getName(uRL2);
        if (string3.startsWith(string2) && (n2 = string.indexOf("/", n = (string = string3.substring(string2.length())).startsWith("/") ? 1 : 0)) != -1) {
            String string5;
            String string6 = string2 + (n == 1 ? "/" : "") + string.substring(n, n2);
            String string7 = CmUtil.getConnName(uRL2);
            URL uRL3 = CmUtil.getNodeURL(string7, null, string5 = CmUtil.getUserName(uRL2), "JAVA", string6);
            JavaObjectFolder javaObjectFolder = (JavaObjectFolder)this.findChild(uRL3);
            if (javaObjectFolder != null && javaObjectFolder.remove(element)) {
                UpdateMessage.fireChildRemoved((Subject)javaObjectFolder, (Element)element);
                if (javaObjectFolder.size() == 0 && this.remove((Element)javaObjectFolder)) {
                    UpdateMessage.fireChildRemoved((Subject)this, (Element)javaObjectFolder);
                }
                bl = true;
            }
        }
        return bl;
    }
}

