/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.browser.jdbc;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import javax.swing.Icon;
import oracle.ide.Ide;
import oracle.ide.explorer.IconOverlayTracker;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.ModelUtil;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectChange;
import oracle.javatools.db.Database;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SchemaObjectListener;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.cm.ds.db.DBUtil;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.browser.CBBaseNode;
import oracle.jdeveloper.cm.dt.browser.JdbcNodeOverlayClient;
import oracle.jdeveloper.cm.dt.browser.Refreshable;
import oracle.jdeveloper.cm.dt.browser.jdbc.DatabaseNode;
import oracle.jdeveloper.cm.dt.dialog.SQLErrorDialog;

public class OCBBaseNode
extends CBBaseNode
implements SchemaObjectListener,
Refreshable,
DatabaseNode {
    private Attributes _attrs;
    private Database _db;
    protected String _dbObjectType;
    private SchemaObject _dbObj;
    protected Boolean _valid;

    void $init$() {
        this._attrs = new ElementAttributes(ElementAttributes.CLOSEABLE);
    }

    public OCBBaseNode() {
        this.$init$();
    }

    public OCBBaseNode(URL uRL) {
        this();
        this.setURL(uRL);
    }

    public Attributes getAttributes() {
        return this._attrs;
    }

    public void init(Database database) {
        this._db = database;
    }

    public Database getDatabase() {
        return this._db;
    }

    public String getObjectType() {
        return this._dbObjectType;
    }

    public final boolean isValid() {
        if (this.canBeInvalid()) {
            if (this._valid == null) {
                this._valid = OCBBaseNode.getValidState(this, this._db, null);
            }
            return this._valid;
        }
        return true;
    }

    public final void markDirty(boolean bl) {
        if (this.canBeInvalid()) {
            this._valid = OCBBaseNode.getValidState(this, this._db, this._valid);
        }
        super.markDirty(bl);
    }

    public final Node getNode() {
        return this;
    }

    public final SchemaObject getSchemaObject() {
        this.ensureOpen();
        return this._dbObj;
    }

    public void setURL(URL uRL) {
        super.setURL(uRL);
        this._dbObjectType = CmUtil.getDbObjectType(uRL);
        this.setName(CmUtil.getName(uRL));
    }

    public Icon getIcon() {
        return DBUtil.getNodeIcon(this._dbObjectType);
    }

    public final String getSchema() {
        return CmUtil.getSchema(this.getURL());
    }

    protected final String getObjectName() {
        return this.getName();
    }

    protected void openImpl() throws IOException {
        if (this._dbObj == null) {
            this._dbObj = this._fetchDataObject();
            if (this._dbObj != null) {
                this._dbObj.addObjectListener((SchemaObjectListener)this);
            }
        }
    }

    protected void closeImpl() throws IOException {
        if (this._dbObj != null) {
            this._dbObj.removeObjectListener((SchemaObjectListener)this);
        }
        this._dbObj = null;
    }

    public void refresh() {
        SchemaObject schemaObject = this._fetchDataObject();
        if (ModelUtil.areDifferent((Object)schemaObject, (Object)this._dbObj)) {
            if (this._dbObj != null) {
                this._dbObj.removeObjectListener((SchemaObjectListener)this);
            }
            this._dbObj = schemaObject;
            if (schemaObject != null) {
                schemaObject.addObjectListener((SchemaObjectListener)this);
            }
            UpdateMessage.fireStructureChanged((Subject)this);
        }
    }

    private SchemaObject _fetchDataObject() {
        SchemaObject schemaObject = null;
        try {
            Database database = this.getDatabase();
            schemaObject = database.getObject(this.getObjectType(), database.getSchema(this.getSchema()), this.getObjectName());
        }
        catch (DBException dBException) {
            Throwable throwable = dBException.getCause();
            if (throwable instanceof SQLException) {
                SQLErrorDialog.showErrorDialog((Component)Ide.getMainWindow(), ConnectionArb.getString(330), (SQLException)throwable);
            }
            if (throwable == null) {
                throwable = dBException;
            }
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)throwable, (String)ConnectionArb.getString(330), (String)ConnectionArb.getString(329), null);
        }
        return schemaObject;
    }

    public void schemaObjectUpdated(DBObjectChange dBObjectChange) {
        if (dBObjectChange.getDBObject() == this._dbObj) {
            if (!this.getName().equals(this._dbObj.getName())) {
                this.setName(this._dbObj.getName());
                UpdateMessage.fireObjectRenamed((Subject)this);
            }
            UpdateMessage.fireStructureChanged((Subject)this);
        }
    }

    protected boolean canBeInvalid() {
        return false;
    }

    protected static Boolean getValidState(Node node, Database database, Boolean bl) {
        Boolean bl2 = Boolean.TRUE;
        URL uRL = node.getURL();
        if (uRL != null) {
            IconOverlayTracker iconOverlayTracker;
            boolean bl3 = bl != null;
            String string = CmUtil.getDbObjectType(uRL);
            String string2 = CmUtil.getSubType(uRL);
            if ("Body".equals(string2)) {
                string = string + " BODY";
            }
            Boolean bl4 = bl2 = database.isObjectValid(string, CmUtil.getSchema(uRL), CmUtil.getName(uRL)) ? Boolean.TRUE : Boolean.FALSE;
            if (ModelUtil.areDifferent((Object)bl2, (Object)bl) && bl3 && (iconOverlayTracker = JdbcNodeOverlayClient.getTracker()) != null) {
                iconOverlayTracker.validateOverlay((Element)node);
                iconOverlayTracker.repaintOverlays();
            }
        }
        return bl2;
    }
}

