/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.browser.jdbc;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Icon;
import oracle.ide.Ide;
import oracle.ide.compiler.Compiler;
import oracle.ide.log.LogPage;
import oracle.ide.model.Attributes;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFileSystem;
import oracle.ide.runner.Debugger;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.util.ModelUtil;
import oracle.ideri.util.Product;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.Database;
import oracle.jdeveloper.cm.ds.db.DBUtil;
import oracle.jdeveloper.cm.ds.db.insight.InsightableObject;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.browser.jdbc.DatabaseNode;
import oracle.jdeveloper.cm.dt.browser.jdbc.JdbcNodeFactory;
import oracle.jdeveloper.cm.dt.browser.jdbc.OCBBaseNode;
import oracle.jdeveloper.cm.dt.compiler.PlSqlTranslator;
import oracle.jdeveloper.compiler.IdeLog;
import oracle.jdeveloper.compiler.IdeStorage;
import oracle.jdeveloper.compiler.Translator;
import oracle.jdeveloper.model.PackagedSource;
import oracle.ojc.interfaces.Storage;

public class PlSqlBaseNode
extends TextNode
implements InsightableObject,
DatabaseNode,
PackagedSource {
    public static final String EXT = ".pls";
    public static final String BODY_EXT = ".pkb";
    public static final String SPEC_EXT = ".pks";
    private String _dbObjectType;
    private Database _db;
    private String _title;
    private String _name;
    private Boolean _valid;
    private boolean _isBody;

    public PlSqlBaseNode() {
        Attributes attributes = this.getAttributes();
        attributes.set(ElementAttributes.BUILDABLE);
        attributes.unset(ElementAttributes.RENAMEABLE);
        attributes.set(ElementAttributes.SAVEABLE_AS);
    }

    public boolean isBody() {
        return this._isBody;
    }

    protected final String getName() {
        return this._name;
    }

    public boolean mayHaveChildren() {
        return Product.isRaptor();
    }

    public void init(Database database) {
        this._db = database;
    }

    public Database getDatabaseForInsight() {
        return this.getDatabase();
    }

    public final String getObjectType() {
        return this._dbObjectType;
    }

    public final Node getNode() {
        return this;
    }

    public final Object getRunTarget() {
        if (this.isRunnableParent()) {
            return this;
        }
        if (this.isRunnableChild()) {
            URL uRL = this.getURL();
            String string = CmUtil.getSchema(uRL);
            String string2 = CmUtil.getName(uRL);
            URL uRL2 = CmUtil.getNodeURL(CmUtil.getConnName(uRL), CmUtil.getCatalog(uRL), string, this.getParentType(), string2);
            return JdbcNodeFactory.getNode(this._db, uRL2);
        }
        return null;
    }

    public final boolean isRunnable() {
        return this.isRunnableParent() || this.isRunnableChild();
    }

    private boolean isRunnableParent() {
        return "FUNCTION".equals(this._dbObjectType) || "PACKAGE".equals(this._dbObjectType) || "PROCEDURE".equals(this._dbObjectType);
    }

    private boolean isRunnableChild() {
        return "PACKAGE".equals(this._dbObjectType);
    }

    public boolean supportsJPDADebugging() {
        return this.isRunnable() && (PlSqlBaseNode._ignoreDatabaseVersion() || this._db.supportsDebugging());
    }

    protected void openImpl() throws IOException {
        super.openImpl();
    }

    protected final void saveImpl() throws IOException {
        URL uRL = this.getURL();
        if (CmUtil.isCMUrl(uRL)) {
            this._saveToDatabase();
        } else {
            super.saveImpl();
        }
    }

    public Icon getIcon() {
        if (this._dbObjectType == null) {
            return super.getIcon();
        }
        return DBUtil.getNodeIcon(this._dbObjectType);
    }

    public String getShortLabel() {
        return ModelUtil.hasLength((String)this._title) ? this._title : super.getShortLabel();
    }

    public final boolean isDirty() {
        return super.isDirty();
    }

    public final void setURL(URL uRL) {
        super.setURL(uRL);
        this._dbObjectType = CmUtil.getDbObjectType(uRL);
        this._name = CmUtil.getName(uRL);
        if ("BLOCK".equals(this._dbObjectType)) {
            this._title = "BLOCK";
        } else if ("Body".equals(CmUtil.getSubType(uRL))) {
            this._isBody = true;
            this._title = ConnectionArb.format(549, this._name);
        } else {
            this._title = this._name;
        }
    }

    public String getLongLabel() {
        return URLFileSystem.getPlatformPathName((URL)this.getURL());
    }

    private void _saveToDatabase() throws IOException {
        boolean bl = this.isDirty();
        if (bl) {
            Debugger debugger = Debugger.getDebugger();
            if (debugger.isDebugging()) {
                throw new IOException(ConnectionArb.getString(702));
            }
            TextBuffer textBuffer = this.getTextBufferDirectly();
            if (textBuffer != null) {
                textBuffer.clearModified();
            }
            Compiler compiler = Compiler.getCompiler();
            PlSqlTranslator plSqlTranslator = new PlSqlTranslator();
            IdeStorage ideStorage = new IdeStorage((Node)this);
            IdeLog ideLog = new IdeLog();
            LogPage logPage = compiler.getErrorLog();
            ideLog.registerAsynchronousLogPage(logPage);
            ideLog.setProject(Ide.getActiveProject() != null ? Ide.getActiveProject() : Ide.getDefaultProject());
            ideLog.setWorkspace(Ide.getActiveWorkspace() != null ? Ide.getActiveWorkspace() : Ide.getDefaultWorkspace());
            ideLog.clear((Storage)ideStorage);
            plSqlTranslator.setLog((Translator.Log)ideLog);
            ArrayList<IdeStorage> arrayList = new ArrayList<IdeStorage>();
            arrayList.add(ideStorage);
            plSqlTranslator.translate(null, false, arrayList, new ArrayList());
            plSqlTranslator.setLog(null);
            ideLog.completed();
            ideLog.unregisterAsynchronousLogPage(logPage);
        }
    }

    public long refreshTimestampOverride() {
        return this.refreshTimestamp();
    }

    public Database getDatabase() {
        return this._db;
    }

    public final boolean isValid() {
        if (this._valid == null) {
            this._valid = OCBBaseNode.getValidState((Node)this, this._db, null);
        }
        return this._valid;
    }

    public final String getSource() {
        TextBuffer textBuffer = this.getTextBufferDirectly();
        if (textBuffer == null) {
            textBuffer = this.acquireTextBuffer();
        }
        if (textBuffer == null) {
            return null;
        }
        int n = textBuffer.getLength();
        char[] cArray = textBuffer.getChars(0, n);
        String string = new String(cArray);
        return string;
    }

    public final boolean equals(Object object) {
        if (object instanceof PlSqlBaseNode) {
            PlSqlBaseNode plSqlBaseNode = (PlSqlBaseNode)object;
            URL uRL = this.getURL();
            URL uRL2 = plSqlBaseNode.getURL();
            if (uRL == null && uRL2 == null || uRL != null && uRL2 != null && uRL.equals(uRL2)) {
                return true;
            }
        }
        return false;
    }

    public final int hashCode() {
        URL uRL = this.getURL();
        return uRL != null ? uRL.toString().hashCode() : 0;
    }

    public final String getPackage(Project project) {
        URL uRL = this.getURL();
        String string = CmUtil.getDbObjectType(uRL);
        if (string == null) {
            return null;
        }
        String string2 = CmUtil.getSubType(uRL);
        string = DBUtil.getArgusNameForType(string, string2);
        String string3 = CmUtil.getSchema(uRL);
        FastStringBuffer fastStringBuffer = new FastStringBuffer();
        fastStringBuffer.append("$Oracle.");
        fastStringBuffer.append(string);
        fastStringBuffer.append(".");
        fastStringBuffer.append(string3);
        return fastStringBuffer.toString();
    }

    public final String getSourceFile() {
        return ModelUtil.hasLength((String)this._name) ? this._name + EXT : URLFileSystem.getFileName((URL)this.getURL());
    }

    private static boolean _ignoreDatabaseVersion() {
        String string = Ide.getProperty((String)"cm.DisableDatabaseDebuggingVersionCheck", (String)"false");
        return Boolean.valueOf(string);
    }

    public final void markDirty(boolean bl) {
        this._valid = OCBBaseNode.getValidState((Node)this, this._db, this._valid);
        super.markDirty(bl);
    }

    private String getParentType() {
        return this._dbObjectType;
    }
}

