/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.browser.jdbc;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.db.Database;
import oracle.jdeveloper.cm.ds.db.DBUtil;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.browser.jdbc.JdbcNodeFactory;
import oracle.jdeveloper.cm.dt.browser.jdbc.OCBBaseNode;
import oracle.jdeveloper.cm.dt.browser.jdbc.PlSqlBaseNode;

public final class PlSqlFolder
extends OCBBaseNode
implements Folder {
    private static final String FOLDER_SUFFIX = "_FOLDER";
    public static final String PACKAGE_FOLDER = "PACKAGE_FOLDER";
    public static final String OBJECT_TYPE_FOLDER = "TYPE_FOLDER";
    private String _type;
    private Icon _icon;
    private String _childType;
    private PlSqlBaseNode _spec;
    private PlSqlBaseNode _body;
    private List _childList;

    public PlSqlFolder() {
    }

    public PlSqlFolder(URL uRL, Database database) {
        this.setURL(uRL);
        this.init(database);
    }

    public void setURL(URL uRL) {
        String string = CmUtil.getDbObjectType(uRL);
        if (string.endsWith(FOLDER_SUFFIX)) {
            this._type = string.substring(0, string.length() - FOLDER_SUFFIX.length());
            if ("PACKAGE".equals(this._type)) {
                this._childType = "PACKAGE BODY";
            } else if ("TYPE".equals(this._type)) {
                this._childType = "TYPE BODY";
            }
        }
        super.setURL(uRL);
    }

    public void init(Database database) {
        super.init(database);
        URL uRL = this.getURL();
        this._spec = (PlSqlBaseNode)JdbcNodeFactory.getNode(this.getDatabase(), CmUtil.getNodeURL(CmUtil.getConnName(uRL), CmUtil.getCatalog(uRL), CmUtil.getSchema(uRL), this._type, this.getName(), "Spec"));
    }

    public String getObjectType() {
        return this._type;
    }

    public String getBodyType() {
        return this._childType;
    }

    public boolean canAdd(Element element) {
        this.ensureOpen();
        boolean bl = false;
        if (this._body == null && element instanceof PlSqlBaseNode) {
            PlSqlBaseNode plSqlBaseNode = (PlSqlBaseNode)element;
            bl = plSqlBaseNode.isBody() && CmUtil.isCMUrl(plSqlBaseNode.getURL());
        }
        return bl;
    }

    public boolean add(Element element) {
        boolean bl = false;
        if (this.canAdd(element)) {
            this._body = (PlSqlBaseNode)element;
            this.updateChildList();
            bl = true;
        }
        return bl;
    }

    public boolean canRemove(Element element) {
        this.ensureOpen();
        return element == this._body;
    }

    public boolean remove(Element element) {
        this.ensureOpen();
        boolean bl = false;
        if (element == this._body) {
            this._body = null;
            this.updateChildList();
            bl = true;
        }
        return bl;
    }

    public void removeAll() {
        this._body = null;
        this.updateChildList();
    }

    public Icon getIcon() {
        if (this._icon == null) {
            this._icon = DBUtil.getNodeIcon(this._type);
        }
        return this._icon;
    }

    public PlSqlBaseNode getBody() {
        this.ensureOpen();
        return this._body;
    }

    public void updateBody(boolean bl) {
        PlSqlBaseNode plSqlBaseNode = this._body;
        this._body = this.fetchBody();
        this.updateChildList();
        if (bl && plSqlBaseNode != this._body) {
            if (plSqlBaseNode != null) {
                UpdateMessage.fireChildRemoved((Subject)this, (Element)plSqlBaseNode);
            }
            if (this._body != null) {
                UpdateMessage.fireChildAdded((Subject)this, (Element)this._body);
            }
        }
    }

    public boolean containsChild(Element element) {
        this.ensureOpen();
        return element != null && (element == this._spec || element == this._body);
    }

    public int size() {
        this.ensureOpen();
        return this._childList.size();
    }

    public Iterator getChildren() {
        this.ensureOpen();
        return this._childList.iterator();
    }

    public boolean mayHaveChildren() {
        return true;
    }

    private PlSqlBaseNode fetchBody() {
        Database database = this.getDatabase();
        PlSqlBaseNode plSqlBaseNode = null;
        URL uRL = this.getURL();
        String string = CmUtil.getSchema(uRL);
        if (database.exists(this._childType, string, this.getName())) {
            URL uRL2 = CmUtil.getNodeURL(CmUtil.getConnName(uRL), CmUtil.getCatalog(uRL), string, this._type, this.getName(), "Body");
            plSqlBaseNode = (PlSqlBaseNode)JdbcNodeFactory.getNode(database, uRL2);
        }
        return plSqlBaseNode;
    }

    protected void openImpl() throws IOException {
        super.openImpl();
        if (this._childList == null) {
            this._body = this.fetchBody();
            this.updateChildList();
        }
    }

    protected void closeImpl() throws IOException {
        if (this._childList != null) {
            if (this._spec != null && this._spec.isOpen()) {
                this._spec.close();
            }
            if (this._body != null && this._body.isOpen()) {
                this._body.close();
            }
            this._body = null;
            this._childList = null;
        }
        super.closeImpl();
    }

    protected void deleteImpl() throws IOException {
        if (this._childList != null) {
            if (this._spec != null) {
                this._spec.delete();
            }
            if (this._body != null) {
                this._body.delete();
            }
            this._body = null;
            this._childList = null;
        }
        super.deleteImpl();
    }

    private void updateChildList() {
        this._childList = this._body == null ? Arrays.asList(this._spec) : Arrays.asList(this._spec, this._body);
    }
}

