/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.browser.jdbc;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.FastStringBuffer;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderAdapter;
import oracle.javatools.db.DBObjectProviderListener;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.browser.jdbc.JdbcNodeFactory;
import oracle.jdeveloper.cm.dt.browser.jdbc.OCBBaseFolder;
import oracle.jdeveloper.cm.dt.browser.jdbc.OCBBaseNode;
import oracle.jdeveloper.cm.dt.browser.jdbc.ObjectTypeFilter;

public final class SchemaFolder
extends OCBBaseFolder
implements Comparable {
    private Map _childMap;
    private List _childList;
    private String _userName;
    private Comparator _typeComparator;

    public SchemaFolder(URL uRL, Database database) {
        super(uRL, database);
        database.addProviderListener((DBObjectProviderListener)new Adapter(null));
    }

    public void setURL(URL uRL) {
        super.setURL(uRL);
        this._userName = CmUtil.getSchema(uRL);
        this.setName(this._userName);
    }

    public String[] getSupportedTypes() {
        this._loadChildrenMap();
        return this._childMap.keySet().toArray(new String[this._childMap.size()]);
    }

    protected List getChildrenList() {
        block6: {
            ObjectTypeFilter objectTypeFilter;
            String[] stringArray;
            if (this._childList != null) break block6;
            this._loadChildrenMap();
            this._childList = new ArrayList();
            if (this._typeComparator == null) {
                this._typeComparator = new 2();
            }
            String[] stringArray2 = stringArray = (objectTypeFilter = (ObjectTypeFilter)this.getFilter()) != null ? objectTypeFilter.getDisplayedTypes() : null;
            if (stringArray != null) {
                Arrays.sort(stringArray, this._typeComparator);
                int n = 0;
                while (n < stringArray.length) {
                    OCBBaseFolder oCBBaseFolder = this.getNodeByType(stringArray[n]);
                    if (oCBBaseFolder != null) {
                        this._childList.add(oCBBaseFolder);
                    }
                    ++n;
                }
            } else {
                Object[] objectArray = this._childMap.keySet().toArray(new Object[this._childMap.size()]);
                Arrays.sort(objectArray, this._typeComparator);
                int n = 0;
                while (n < objectArray.length) {
                    this._childList.add(this._childMap.get(objectArray[n]));
                    ++n;
                }
            }
        }
        return this._childList;
    }

    protected void closeImpl() throws IOException {
        super.closeImpl();
        if (this._childList != null) {
            this._childList.clear();
            this._childList = null;
        }
        if (this._childMap != null) {
            this._childMap.clear();
            this._childMap = null;
        }
    }

    private void _loadChildrenMap() {
        if (this._childMap == null) {
            this._childMap = new HashMap(21);
            Database database = this.getDatabase();
            String string = CmUtil.getConnName(this.getURL());
            String[] stringArray = database.listObjectTypes();
            int n = 0;
            while (n < stringArray.length) {
                String string2 = stringArray[n];
                if ("JAVA SOURCE".equals(string2) || "JAVA CLASS".equals(string2) || "JAVA RESOURCE".equals(string2)) {
                    string2 = "JAVA";
                }
                if (this._childMap.get(string2) == null) {
                    this.createChildFolder(database, string, string2, this._userName);
                    if ("SYNONYM".equals(string2)) {
                        this.createChildFolder(database, string, "PUBLIC_SYNONYM", "PUBLIC");
                    }
                }
                ++n;
            }
        }
    }

    private void createChildFolder(Database database, String string, String string2, String string3) {
        URL uRL = CmUtil.getFolderURL(string, null, string3, string2);
        OCBBaseFolder oCBBaseFolder = JdbcNodeFactory.getFolder(uRL, database, null);
        if (oCBBaseFolder != null) {
            this._childMap.put(string2, oCBBaseFolder);
        }
    }

    public OCBBaseFolder getNodeByType(String string) {
        if (this._childMap == null) {
            this.getChildrenList();
        }
        if ("JAVA SOURCE".equals(string) || "JAVA CLASS".equals(string) || "JAVA RESOURCE".equals(string)) {
            string = "JAVA";
        }
        return (OCBBaseFolder)this._childMap.get(string);
    }

    public String getName() {
        String string = super.getName();
        return string != null && string.length() > 0 ? string : ConnectionArb.getString(373);
    }

    public int compareTo(Object object) {
        OCBBaseNode oCBBaseNode = (OCBBaseNode)object;
        return this.getShortLabel().compareTo(oCBBaseNode.getShortLabel());
    }

    private void _handleAdd(List list) {
        if (list != null && list.size() > 0) {
            URL uRL = this.getURL();
            String string = CmUtil.getConnName(uRL);
            Database database = this.getDatabase();
            ArrayList<Node> arrayList = new ArrayList<Node>();
            SchemaObject schemaObject = (SchemaObject)list.get(0);
            String string2 = schemaObject.getType();
            OCBBaseFolder oCBBaseFolder = this.getNodeByType(string2);
            int n = 0;
            while (n < list.size()) {
                schemaObject = (SchemaObject)list.get(n);
                Node node = oCBBaseFolder.createChild(this.getObjectName(string2, schemaObject.getName()));
                if (node != null && oCBBaseFolder.add((Element)node)) {
                    arrayList.add(node);
                }
                ++n;
            }
            if (arrayList.size() > 0) {
                SwingUtilities.invokeLater(new 1(this, oCBBaseFolder, arrayList));
            }
        }
    }

    private void _handleRemove(List list) {
        OCBBaseFolder oCBBaseFolder;
        if (list != null && list.size() > 0) {
            URL uRL = this.getURL();
            String string = CmUtil.getConnName(uRL);
            Database database = this.getDatabase();
            SchemaObject schemaObject = (SchemaObject)list.get(0);
            String string2 = schemaObject.getType();
            OCBBaseFolder oCBBaseFolder2 = this.getNodeByType(string2);
            if (!"RECYCLEBIN".equals(string2)) {
                ArrayList<Node> arrayList = new ArrayList<Node>();
                int n = 0;
                while (n < list.size()) {
                    schemaObject = (SchemaObject)list.get(n);
                    Node node = oCBBaseFolder2.createChild(this.getObjectName(string2, schemaObject.getName()));
                    if (node != null && oCBBaseFolder2.remove((Element)node)) {
                        try {
                            node.close();
                            NodeFactory.uncache((URL)node.getURL());
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        arrayList.add(node);
                    }
                    ++n;
                }
                if (arrayList.size() > 0) {
                    UpdateMessage.fireChildrenRemoved((Subject)oCBBaseFolder2, arrayList);
                }
            }
        }
        if (this.getDatabase().supportsObjectType("RECYCLEBIN") && (oCBBaseFolder = this.getNodeByType("RECYCLEBIN")).isOpen()) {
            oCBBaseFolder.refresh();
        }
    }

    protected boolean loadInThread() {
        return false;
    }

    private String getObjectName(String string, String string2) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(string2.length() + 7);
        if ("JAVA CLASS".equals(string)) {
            fastStringBuffer.append('/').append(string2).append(".class");
        } else if ("JAVA SOURCE".equals(string)) {
            fastStringBuffer.append('/').append(string2).append(".java");
        } else if ("JAVA RESOURCE".equals(string)) {
            fastStringBuffer.append('/').append(string2);
        } else {
            fastStringBuffer.append(string2);
        }
        return fastStringBuffer.toString();
    }

    static String ra$_userName(SchemaFolder schemaFolder) {
        return schemaFolder._userName;
    }

    static void mav$_handleRemove(SchemaFolder schemaFolder, List list) {
        schemaFolder._handleRemove(list);
    }

    static void mav$_handleAdd(SchemaFolder schemaFolder, List list) {
        schemaFolder._handleAdd(list);
    }

    public final class 2
    implements Comparator {
        public int compare(Object object, Object object2) {
            if (object.equals(object2)) {
                return 0;
            }
            if (object.equals("RECYCLEBIN")) {
                return 100;
            }
            if (object2.equals("RECYCLEBIN")) {
                return -100;
            }
            return object.toString().compareTo(object2.toString());
        }
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ OCBBaseFolder v$parent;
        private final /* synthetic */ List v$nodes;
        final /* synthetic */ SchemaFolder this$0;

        public void run() {
            UpdateMessage.fireChildrenAdded((Subject)this.v$parent, (Collection)this.v$nodes);
        }

        public 1(SchemaFolder schemaFolder, OCBBaseFolder oCBBaseFolder, List list) {
            this.v$nodes = list;
            this.v$parent = oCBBaseFolder;
            this.this$0 = schemaFolder;
        }
    }

    private class Adapter
    extends DBObjectProviderAdapter {
        public void schemaObjectsAdded(DBObjectProvider dBObjectProvider, Schema schema, SchemaObject[] schemaObjectArray) {
            if (schema.getName().equals(SchemaFolder.ra$_userName(SchemaFolder.this))) {
                SchemaFolder.mav$_handleAdd(SchemaFolder.this, Arrays.asList(schemaObjectArray));
            }
        }

        public void schemaObjectsRemoved(DBObjectProvider dBObjectProvider, Schema schema, SchemaObject[] schemaObjectArray) {
            if (schema.getName().equals(SchemaFolder.ra$_userName(SchemaFolder.this))) {
                SchemaFolder.mav$_handleRemove(SchemaFolder.this, Arrays.asList(schemaObjectArray));
            }
        }

        private Adapter() {
        }

        Adapter(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

