/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.browser.jdbc;

import java.io.IOException;
import java.net.URL;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.browser.jdbc.ViewNode;

public class SynonymViewNode
extends ViewNode {
    private Synonym _synModel;

    public SynonymViewNode() {
    }

    public SynonymViewNode(URL uRL) {
        super(uRL);
    }

    public String getViewName() {
        SchemaObject schemaObject = this.getSynonymReference();
        return schemaObject != null ? schemaObject.getName() : null;
    }

    public String getViewSchema() {
        SchemaObject schemaObject = this.getSynonymReference();
        return schemaObject != null ? schemaObject.getSchema().getName() : null;
    }

    public Synonym getSynonym() {
        this.ensureOpen();
        if (this._synModel == null) {
            try {
                Database database = this.getDatabase();
                this._synModel = (Synonym)database.getObject("SYNONYM", database.getSchema(CmUtil.getSchema(this.getURL())), this.getName());
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return this._synModel;
    }

    protected void closeImpl() throws IOException {
        super.closeImpl();
        this._synModel = null;
    }

    protected SchemaObject getSynonymReference() {
        SchemaObject schemaObject = null;
        Synonym synonym = this.getSynonym();
        try {
            if (synonym != null) {
                schemaObject = (SchemaObject)synonym.getReference().resolveID();
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return schemaObject;
    }
}

