/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.compiler;

import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import oracle.javatools.util.Copyable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilerOptions
implements Copyable {
    public static final String KEY = "PlSqlCompilerSettings";
    private Map<WarningCategory, WarningValue> _flags;

    void $init$() {
        this._flags = new EnumMap<WarningCategory, WarningValue>(WarningCategory.class);
    }

    public CompilerOptions() {
        this.$init$();
    }

    public Object copyTo(Object object) {
        CompilerOptions compilerOptions = object instanceof CompilerOptions ? (CompilerOptions)object : new CompilerOptions();
        this.copyToImpl(compilerOptions);
        return compilerOptions;
    }

    private void copyToImpl(CompilerOptions compilerOptions) {
        compilerOptions._flags.clear();
        compilerOptions._flags.putAll(this._flags);
    }

    public Set<WarningCategory> getCategories() {
        return this._flags.keySet();
    }

    public WarningValue getWarningValue(WarningCategory warningCategory) {
        return this._flags.get((Object)warningCategory);
    }

    public void setWarningValue(WarningCategory warningCategory, WarningValue warningValue) {
        this._flags.put(warningCategory, warningValue);
    }

    public void setWarningFlags(String string) {
        this._flags.clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(58);
            if (n <= 0) continue;
            try {
                WarningValue warningValue = WarningValue.valueOf(string2.substring(0, n));
                WarningCategory warningCategory = WarningCategory.valueOf(string2.substring(n + 1));
                this._flags.put(warningCategory, warningValue);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public String getWarningFlags() {
        StringBuffer stringBuffer = new StringBuffer();
        for (WarningCategory warningCategory : this._flags.keySet()) {
            WarningValue warningValue = this._flags.get((Object)warningCategory);
            if (warningValue == null) continue;
            stringBuffer.append((Object)warningValue).append(':').append((Object)warningCategory).append('|');
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class WarningCategory
    extends Enum {
        private static final /* synthetic */ WarningCategory[] $v;
        public static final /* enum */ WarningCategory ALL;
        public static final /* enum */ WarningCategory INFORMATIONAL;
        public static final /* enum */ WarningCategory SEVERE;
        public static final /* enum */ WarningCategory PERFORMANCE;

        public static WarningCategory valueOf(String string) {
            return Enum.valueOf(WarningCategory.class, string);
        }

        public static final WarningCategory[] values() {
            return (WarningCategory[])$v.clone();
        }

        static {
            WarningCategory[] warningCategoryArray = new WarningCategory[4];
            warningCategoryArray[3] = PERFORMANCE = new WarningCategory();
            warningCategoryArray[2] = SEVERE = new WarningCategory();
            warningCategoryArray[1] = INFORMATIONAL = new WarningCategory();
            warningCategoryArray[0] = ALL = new WarningCategory();
            $v = warningCategoryArray;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class WarningValue
    extends Enum {
        private static final /* synthetic */ WarningValue[] $v;
        public static final /* enum */ WarningValue ENABLE;
        public static final /* enum */ WarningValue DISABLE;
        public static final /* enum */ WarningValue ERROR;

        public static WarningValue valueOf(String string) {
            return Enum.valueOf(WarningValue.class, string);
        }

        public static final WarningValue[] values() {
            return (WarningValue[])$v.clone();
        }

        static {
            WarningValue[] warningValueArray = new WarningValue[3];
            warningValueArray[2] = ERROR = new WarningValue();
            warningValueArray[1] = DISABLE = new WarningValue();
            warningValueArray[0] = ENABLE = new WarningValue();
            $v = warningValueArray;
        }
    }
}

