/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.compiler;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import oracle.ide.Addin;
import oracle.ide.config.ClientSetting;
import oracle.ide.model.Project;
import oracle.javatools.db.Database;
import oracle.javatools.db.PlSql;
import oracle.javatools.db.SpecPlSql;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.browser.jdbc.PlSqlBaseNode;
import oracle.jdeveloper.cm.dt.compiler.OraPls;
import oracle.jdeveloper.cm.dt.compiler.OraSubmitResults;
import oracle.jdeveloper.cm.dt.compiler.PlSqlErrorInfo;
import oracle.jdeveloper.compiler.IdeStorage;
import oracle.jdeveloper.compiler.JCompiler;
import oracle.jdeveloper.compiler.Translator;
import oracle.jdevimpl.cm.dt.config.ConnectionOptions;
import oracle.ojc.interfaces.Storage;

public final class PlSqlTranslator
implements Addin,
Translator {
    private static final String NAME = "PlSql";
    private Translator.Log _log;
    private static final PlSqlNodeComparator COMPARATOR = new PlSqlNodeComparator(null);

    void $init$() {
        this._log = null;
    }

    public PlSqlTranslator() {
        this.$init$();
    }

    public String getName() {
        return NAME;
    }

    public ArrayList getInputTypes() {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(".plsql");
        return arrayList;
    }

    public boolean needToBuild(Storage storage) {
        return false;
    }

    public ArrayList getOutputTypes() {
        ArrayList arrayList = new ArrayList(0);
        return arrayList;
    }

    public boolean canBuild(Storage storage) {
        return storage instanceof IdeStorage && ((IdeStorage)storage).node instanceof PlSqlBaseNode;
    }

    public void setProject(Project project) {
    }

    public void updateProject(Project project) {
    }

    public void setParameter(String string, String string2) {
    }

    public void setLog(Translator.Log log) {
        this._log = log;
    }

    public int translate(Project project, boolean bl, ArrayList arrayList, ArrayList arrayList2) {
        ClientSetting clientSetting = ClientSetting.findOrCreate((String)"oracle.onlinedb");
        String string = null;
        if (project != null) {
            Map map = project.getTransientProperties();
            string = (String)map.get("PLSQL_DEBUG");
        }
        boolean bl2 = string != null ? Boolean.parseBoolean(string) : ((ConnectionOptions)clientSetting.getData("ConnectionOptions")).isGeneratePlSqlDebugInfo();
        int n = 0;
        int n2 = arrayList.size();
        try {
            Collections.sort(arrayList, COMPARATOR);
            int n3 = 0;
            while (n3 < n2 && !Thread.currentThread().isInterrupted()) {
                IdeStorage ideStorage = (IdeStorage)arrayList.get(n3);
                PlSqlBaseNode plSqlBaseNode = (PlSqlBaseNode)ideStorage.node;
                Database database = plSqlBaseNode.getDatabase();
                URL uRL = plSqlBaseNode.getURL();
                String string2 = CmUtil.getDbObjectType(uRL);
                if (PlSql.isPlSql((String)string2)) {
                    PlSql plSql = (PlSql)database.getObject(string2, database.getSchema(CmUtil.getSchema(uRL)), CmUtil.getName(uRL));
                    if (plSql != null) {
                        if (plSqlBaseNode.isBody()) {
                            ((SpecPlSql)plSql).setBodySource(plSqlBaseNode.getSource());
                        } else {
                            plSql.setSource(plSqlBaseNode.getSource());
                        }
                    }
                } else if ("TRIGGER".equals(string2)) {
                    // empty if block
                }
                String string3 = CmUtil.getSchema(uRL);
                OraPls oraPls = new OraPls(database);
                oraPls.setGenerateDebug(bl2);
                OraSubmitResults oraSubmitResults = oraPls.PlsSubmit(string3, plSqlBaseNode.getSource());
                n = oraSubmitResults.getErrorCount();
                List<PlSqlErrorInfo> list = oraSubmitResults.getErrorList();
                if (list != null) {
                    for (PlSqlErrorInfo plSqlErrorInfo : list) {
                        if (plSqlErrorInfo.isWarning()) {
                            this._log.warning((Storage)ideStorage, plSqlErrorInfo.getLineNumber(), plSqlErrorInfo.getColumn(), 0, plSqlErrorInfo.getErrorMessage());
                            continue;
                        }
                        this._log.error((Storage)ideStorage, plSqlErrorInfo.getLineNumber(), plSqlErrorInfo.getColumn(), 0, plSqlErrorInfo.getErrorMessage());
                    }
                }
                if (!oraSubmitResults.isSubmitFailed()) {
                    plSqlBaseNode.markDirty(false);
                    plSqlBaseNode.refreshTimestampOverride();
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            n = 1;
        }
        return n;
    }

    public void initialize() {
        JCompiler.getInstance().registerTranslator((Translator)this);
    }

    public void shutdown() {
        JCompiler.getInstance().unregisterTranslator((Translator)this);
    }

    private static final class PlSqlNodeComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            IdeStorage ideStorage = (IdeStorage)object;
            IdeStorage ideStorage2 = (IdeStorage)object2;
            int n = ideStorage.getName().compareTo(ideStorage2.getName());
            if (n == 0) {
                PlSqlBaseNode plSqlBaseNode = (PlSqlBaseNode)ideStorage.node;
                String string = plSqlBaseNode.getObjectType();
                n = "PACKAGE".equals(string) || "TYPE".equals(string) ? -1 : 1;
            }
            return n;
        }

        private PlSqlNodeComparator() {
        }

        PlSqlNodeComparator(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

