/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.controls;

import java.awt.Color;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import oracle.ide.layout.ViewId;
import oracle.ide.log.DefaultLogPage;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.controls.EditableResultSetTableModel;
import oracle.jdeveloper.cm.dt.controls.ResultSetTable;

public class EditableResultSetTable
extends ResultSetTable {
    private DataEditorLogPage _logPage;
    private boolean _insertOnly;

    public EditableResultSetTable() {
        EditableResultSetCellRenderer editableResultSetCellRenderer = new EditableResultSetCellRenderer();
        try {
            this.setDefaultRenderer(Class.forName("java.lang.Object"), editableResultSetCellRenderer);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._logPage = null;
        this._insertOnly = false;
    }

    public boolean save() {
        TableModel tableModel = this.getModel();
        boolean bl = true;
        DataEditorLogPage dataEditorLogPage = this.getLogPage();
        dataEditorLogPage.clearAll();
        if (tableModel instanceof EditableResultSetTableModel) {
            TableCellEditor tableCellEditor;
            if (this.isEditing() && (tableCellEditor = this.getCellEditor(this.getEditingRow(), this.getEditingColumn())) != null) {
                tableCellEditor.stopCellEditing();
            }
            EditableResultSetTableModel editableResultSetTableModel = (EditableResultSetTableModel)tableModel;
            int n = editableResultSetTableModel.save();
            dataEditorLogPage.show();
            dataEditorLogPage.activate();
            ArrayList arrayList = editableResultSetTableModel.getLog();
            int n2 = 0;
            while (n2 < arrayList.size()) {
                if (arrayList.get(n2) != null) {
                    dataEditorLogPage.log(arrayList.get(n2) + System.getProperty("line.separator"));
                }
                ++n2;
            }
            dataEditorLogPage.log(System.getProperty("line.separator"));
            if (n > 0) {
                if (n == 1) {
                    dataEditorLogPage.log(MessageFormat.format(ConnectionArb.getString(668), editableResultSetTableModel.getTableName()) + System.getProperty("line.separator"));
                } else {
                    dataEditorLogPage.log(MessageFormat.format(ConnectionArb.getString(669), new Integer(n), editableResultSetTableModel.getTableName()) + System.getProperty("line.separator"));
                }
                int n3 = 0;
                while (n3 < editableResultSetTableModel.getRowCount()) {
                    if (editableResultSetTableModel.isRowError(n3)) {
                        dataEditorLogPage.log(MessageFormat.format(ConnectionArb.getString(670), new Integer(n3 + 1), editableResultSetTableModel.getErrorMessage(n3)));
                    }
                    ++n3;
                }
            } else {
                dataEditorLogPage.log(ConnectionArb.getString(671) + System.getProperty("line.separator"));
            }
        }
        return bl;
    }

    public boolean rollback() {
        TableModel tableModel = this.getModel();
        boolean bl = true;
        DataEditorLogPage dataEditorLogPage = this.getLogPage();
        dataEditorLogPage.clearAll();
        if (tableModel instanceof EditableResultSetTableModel) {
            TableCellEditor tableCellEditor;
            if (this.isEditing() && (tableCellEditor = this.getCellEditor(this.getEditingRow(), this.getEditingColumn())) != null) {
                tableCellEditor.stopCellEditing();
            }
            EditableResultSetTableModel editableResultSetTableModel = (EditableResultSetTableModel)tableModel;
            int n = editableResultSetTableModel.rollback();
            dataEditorLogPage.show();
            dataEditorLogPage.activate();
            dataEditorLogPage.log(ConnectionArb.getString(673) + System.getProperty("line.separator"));
        }
        return bl;
    }

    public boolean deleteRow() {
        int n = this.getSelectedRowCount();
        if (n < 1) {
            return true;
        }
        TableModel tableModel = this.getModel();
        if (tableModel instanceof EditableResultSetTableModel) {
            EditableResultSetTableModel editableResultSetTableModel = (EditableResultSetTableModel)tableModel;
            if (n == 1) {
                if (editableResultSetTableModel.isRowDeleted(this.getSelectedRow())) {
                    editableResultSetTableModel.markRowDeleted(this.getSelectedRow(), false);
                } else {
                    editableResultSetTableModel.markRowDeleted(this.getSelectedRow(), true);
                }
            } else {
                int[] nArray = this.getSelectedRows();
                int n2 = 0;
                while (n2 < n) {
                    if (editableResultSetTableModel.isRowDeleted(nArray[n2])) {
                        editableResultSetTableModel.markRowDeleted(nArray[n2], false);
                    } else {
                        editableResultSetTableModel.markRowDeleted(nArray[n2], true);
                    }
                    ++n2;
                }
            }
            this.repaint();
        }
        return true;
    }

    public boolean insertRow() {
        TableModel tableModel;
        TableCellEditor tableCellEditor;
        int n = this.getSelectedRow();
        if (n < 0) {
            n = 0;
        }
        if (this.isEditing() && (tableCellEditor = this.getCellEditor(this.getEditingRow(), this.getEditingColumn())) != null) {
            tableCellEditor.stopCellEditing();
        }
        if ((tableModel = this.getModel()) instanceof EditableResultSetTableModel) {
            EditableResultSetTableModel editableResultSetTableModel = (EditableResultSetTableModel)tableModel;
            editableResultSetTableModel.addRow(n);
            this.changeSelection(n, 0, false, false);
            this.repaint();
        }
        return true;
    }

    public void setInsertOnly() {
        this._insertOnly = true;
        TableModel tableModel = this.getModel();
        if (tableModel instanceof EditableResultSetTableModel) {
            EditableResultSetTableModel editableResultSetTableModel = (EditableResultSetTableModel)tableModel;
            editableResultSetTableModel.setInsertOnly();
        }
    }

    public boolean getChanged() {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof EditableResultSetTableModel) {
            EditableResultSetTableModel editableResultSetTableModel = (EditableResultSetTableModel)tableModel;
            return editableResultSetTableModel.getChanged();
        }
        return false;
    }

    public void setChanged(boolean bl) {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof EditableResultSetTableModel) {
            EditableResultSetTableModel editableResultSetTableModel = (EditableResultSetTableModel)tableModel;
            editableResultSetTableModel.setChanged(bl);
        }
    }

    public boolean isValid() {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof EditableResultSetTableModel) {
            EditableResultSetTableModel editableResultSetTableModel = (EditableResultSetTableModel)tableModel;
            return editableResultSetTableModel.isValid();
        }
        return false;
    }

    public boolean canDeleteRow(int n) {
        if (!this._insertOnly) {
            return true;
        }
        TableModel tableModel = this.getModel();
        if (tableModel instanceof EditableResultSetTableModel) {
            EditableResultSetTableModel editableResultSetTableModel = (EditableResultSetTableModel)tableModel;
            return editableResultSetTableModel.isRowNew(n);
        }
        return false;
    }

    private DataEditorLogPage getLogPage() {
        if (this._logPage != null) {
            return this._logPage;
        }
        LogManager logManager = LogManager.getLogManager();
        if (logManager != null) {
            TableModel tableModel = this.getModel();
            if (tableModel instanceof EditableResultSetTableModel) {
                EditableResultSetTableModel editableResultSetTableModel = (EditableResultSetTableModel)tableModel;
                this._logPage = new DataEditorLogPage(editableResultSetTableModel.getTableName());
                logManager.addPage((LogPage)this._logPage);
            }
            return this._logPage;
        }
        return null;
    }

    private class EditableResultSetCellRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            TableModel tableModel = jTable.getModel();
            if (tableModel instanceof EditableResultSetTableModel) {
                EditableResultSetTableModel editableResultSetTableModel = (EditableResultSetTableModel)tableModel;
                if (editableResultSetTableModel.isRowDeleted(n) && !jTable.isRowSelected(n)) {
                    component.setForeground(Color.lightGray);
                } else if (!jTable.isRowSelected(n)) {
                    component.setForeground(Color.black);
                }
                if (editableResultSetTableModel.isRowError(n) && !jTable.isRowSelected(n)) {
                    component.setBackground(Color.red);
                } else if (!jTable.isRowSelected(n)) {
                    if (!editableResultSetTableModel.isCellEditable(n, n2 + 1)) {
                        component.setBackground(new Color(230, 230, 230));
                    } else {
                        component.setBackground(Color.white);
                    }
                }
            }
            return component;
        }
    }

    private final class DataEditorLogPage
    extends DefaultLogPage {
        public DataEditorLogPage(String string) {
            super(new ViewId("DataEditorLogPage", MessageFormat.format(ConnectionArb.getString(672), string)), null, false, DefaultLogPage.HIDE_FIX_SOURCE_MENU);
        }
    }
}

