/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.cm.dt.ConnectionArb;

public class SQLErrorDialog
extends JPanel
implements ActionListener {
    private BorderLayout layMain;
    private JMultiLineLabel lblMsg;
    private JButton btnBack;
    private JButton btnForward;
    private JPanel pnlBottom;
    private GridBagLayout layBottom;
    private JPanel pnlButtons;
    private GridLayout layButtons;
    private Component glue;
    protected List _errs;
    private int _idx;
    private static final String BACK_CMD = "BACK";
    private static final String FWD_CMD = "FWD";

    void $init$() {
        this.layMain = new BorderLayout();
        this.lblMsg = new JMultiLineLabel();
        this.btnBack = new JButton();
        this.btnForward = new JButton();
        this.pnlBottom = new JPanel();
        this.layBottom = new GridBagLayout();
        this.pnlButtons = new JPanel();
        this.layButtons = new GridLayout();
        this.glue = Box.createGlue();
    }

    protected SQLErrorDialog() {
        this.$init$();
    }

    private void setError(SQLException sQLException) {
        ArrayList<SQLException> arrayList = new ArrayList<SQLException>();
        while (sQLException != null) {
            arrayList.add(sQLException);
            sQLException = sQLException.getNextException();
        }
        this.setErrors(arrayList);
    }

    public static void showErrorDialog(Component component, String string, SQLException sQLException) {
        SQLErrorDialog sQLErrorDialog = new SQLErrorDialog();
        sQLErrorDialog.setError(sQLException);
        sQLErrorDialog.runErrorDialog(component, string, null);
    }

    protected void runErrorDialog(Component component, String string, String string2) {
        MessageDialog.error((Component)component, (Object)this, (String)string, (String)string2);
    }

    protected boolean runConfirmDialog(Component component, String string, String string2) {
        return MessageDialog.confirm((Component)component, (Object)this, (String)string, (String)string2, (boolean)false, (String)"OK", (String)"Cancel");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (BACK_CMD.equals(string)) {
            --this._idx;
            this._update();
        } else if (FWD_CMD.equals(string)) {
            ++this._idx;
            this._update();
        }
    }

    protected void setErrors(List list) {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._errs = list;
        this._idx = this._errs.size() > 0 ? 0 : -1;
        this.pnlBottom.setVisible(this._errs.size() > 1);
        this._update();
    }

    private void _update() {
        this.btnBack.setEnabled(this._idx > 0);
        this.btnForward.setEnabled(this._idx < this._errs.size() - 1);
        Exception exception = this._idx != -1 ? (Exception)this._errs.get(this._idx) : null;
        this.updateExceptionComponent(exception);
    }

    protected void updateExceptionComponent(Exception exception) {
        SQLException sQLException = (SQLException)exception;
        String string = sQLException.getLocalizedMessage();
        if (string != null && !string.endsWith("\n")) {
            string = string + '\n';
        }
        String string2 = sQLException != null ? ConnectionArb.format(515, string, Integer.toString(sQLException.getErrorCode())) : ConnectionArb.getString(516);
        this.lblMsg.setText(string2);
    }

    protected Component getExceptionComponent() {
        this.lblMsg.setPreferredAspectRatio(5.0f);
        return this.lblMsg;
    }

    private void jbInit() {
        this.setLayout(this.layMain);
        ResourceUtils.resButton((AbstractButton)this.btnBack, (String)ConnectionArb.getString(517));
        this.btnBack.setActionCommand(BACK_CMD);
        this.btnBack.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this.btnForward, (String)ConnectionArb.getString(518));
        this.btnForward.setActionCommand(FWD_CMD);
        this.btnForward.addActionListener(this);
        this.pnlBottom.setLayout(this.layBottom);
        this.pnlBottom.setBorder(BorderFactory.createEmptyBorder(15, 0, 0, 0));
        this.pnlButtons.setLayout(this.layButtons);
        this.layButtons.setColumns(2);
        this.layButtons.setHgap(5);
        this.add(this.getExceptionComponent(), "Center");
        this.pnlButtons.add((Component)this.btnBack, null);
        this.pnlButtons.add((Component)this.btnForward, null);
        this.pnlBottom.add(this.glue, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlBottom.add((Component)this.pnlButtons, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.pnlBottom, "South");
    }
}

