/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.ui;

import java.awt.Component;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.ide.Ide;
import oracle.ide.panels.MDDPanel;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.Namespace;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.cm.ds.db.DBUtil;
import oracle.jdeveloper.cm.dt.dialog.SQLErrorDialog;
import oracle.jdeveloper.cm.dt.verifier.Verifier;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class DBObjectAbstractDialog {
    protected List _navigables;
    protected Map _verifiers;
    private boolean m_updatable;

    void $init$() {
        this._navigables = new ArrayList();
        this._verifiers = new HashMap();
        this.m_updatable = true;
    }

    public DBObjectAbstractDialog() {
        this.$init$();
    }

    public void registerNavigable(Navigable navigable) {
        if (!this._navigables.contains(navigable)) {
            this._navigables.add(navigable);
        }
    }

    public void unregisterNavigable(Navigable navigable) {
        if (this._navigables.contains(navigable)) {
            this._navigables.remove(navigable);
        }
    }

    protected Navigable[] getNavigables() {
        return this._navigables.toArray(new Navigable[this._navigables.size()]);
    }

    public void registerVerifier(String string, Class clazz) {
        this._verifiers.put(string, clazz);
    }

    public void unregisterVerifier(String string) {
        this._verifiers.remove(string);
    }

    public void setUpdateable(boolean bl) {
        this.m_updatable = bl;
    }

    protected boolean isUpdatable() {
        return this.m_updatable;
    }

    public Namespace createNamespace(DBObjectProvider dBObjectProvider, SchemaObject schemaObject, DBObject dBObject) {
        return this.createNamespace(dBObjectProvider, schemaObject, dBObject, true);
    }

    public Namespace createCreateNamespace(DBObjectProvider dBObjectProvider, SchemaObject schemaObject, DBObject dBObject) {
        return this.createNamespace(dBObjectProvider, schemaObject, dBObject, false);
    }

    public Namespace createNamespace(DBObjectProvider dBObjectProvider, SchemaObject schemaObject, DBObject dBObject, boolean bl) {
        SchemaObject schemaObject2 = null;
        Namespace namespace = new Namespace();
        namespace.put("DBObjectProvider", (Object)dBObjectProvider);
        if (schemaObject != null) {
            DBObject dBObject2;
            if (bl) {
                schemaObject2 = (SchemaObject)DBUtil.makeTemporaryCopy((DBObject)schemaObject);
                namespace.put("OriginalObject", (Object)schemaObject);
                namespace.put("NewObject", (Object)schemaObject2);
            } else {
                namespace.put("NewObject", (Object)schemaObject);
            }
            if (dBObject != null && schemaObject2 != null && (dBObject2 = DBUtil.findChildInCopy((DBObject)schemaObject, (DBObject)schemaObject2, (DBObject)dBObject)) != null) {
                namespace.put("DefaultChild", (Object)dBObject2);
            }
            try {
                Schema schema = schemaObject.getSchema();
                namespace.put("Schema", (Object)schema);
                Schema[] schemaArray = dBObjectProvider.listSchemas();
                namespace.put("SchemaList", (Object)schemaArray);
            }
            catch (DBException dBException) {
                Throwable throwable = dBException.getCause();
                if (throwable instanceof SQLException) {
                    SQLErrorDialog.showErrorDialog(IdeUtil.getMainWindow(), "Error Getting Schema List", (SQLException)throwable);
                }
                ExceptionDialog.showExceptionDialog((Component)IdeUtil.getMainWindow(), (Throwable)(throwable != null ? throwable : dBException), (String)"Error Getting Schema List", (String)"An error was encountered trying to get the list of schemas.", null);
            }
            for (String string : this._verifiers.keySet()) {
                Class clazz = (Class)this._verifiers.get(string);
                try {
                    Object t = clazz.newInstance();
                    if (t instanceof Verifier) {
                        Verifier verifier = (Verifier)t;
                        if (schemaObject2 == null) {
                            verifier.initializeVerifier(dBObjectProvider, null, schemaObject);
                        } else {
                            verifier.initializeVerifier(dBObjectProvider, schemaObject, schemaObject2);
                        }
                        verifier.setEditable(this.isUpdatable());
                    }
                    namespace.put(string, t);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return namespace;
    }

    protected MDDPanel getEditMDDPanel(Navigable[] navigableArray) {
        return new EditMDDPanel(navigableArray, null);
    }

    protected void applyEdit(Traversable traversable, Namespace namespace) throws TraversalException {
        SchemaObject schemaObject;
        SchemaObject schemaObject2 = (SchemaObject)namespace.find("OriginalObject");
        if (ModelUtil.areDifferent((Object)schemaObject2, (Object)(schemaObject = (SchemaObject)namespace.find("NewObject")))) {
            DBObjectProvider dBObjectProvider = (DBObjectProvider)namespace.find("DBObjectProvider");
            try {
                String string = schemaObject.getSchema().getName();
                Schema schema = dBObjectProvider.getSchema(string);
                if (schema == null) {
                    dBObjectProvider.createSchema(schemaObject.getSchema(), false);
                }
                dBObjectProvider.updateObject(schemaObject2, schemaObject);
            }
            catch (DBException dBException) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)dBException, (String)CmWizardsArb.getString(249), (String)dBException.getMessage(), null);
                throw new TraversalException(null);
            }
        }
    }

    protected class EditMDDPanel
    extends MDDPanel {
        private EditMDDPanel(Navigable[] navigableArray) {
            super(navigableArray);
        }

        public void onExit(TraversableContext traversableContext) throws TraversalException {
            super.onExit(traversableContext);
            DBObjectAbstractDialog.this.applyEdit((Traversable)this, (Namespace)traversableContext);
        }

        EditMDDPanel(Navigable[] navigableArray, 1 var3_3) {
            this(navigableArray);
        }

        public final class 1 {
        }
    }
}

