/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.ui;

import java.awt.Component;
import java.util.Comparator;
import javax.accessibility.AccessibleContext;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import oracle.ide.resource.IdeIcons;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.util.ModelUtil;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Schema;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.sql.AliasFragment;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.DBObjectUsage;
import oracle.javatools.db.sql.FKUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.FunctionDefinition;
import oracle.javatools.db.sql.JoinObject;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.jdeveloper.cm.ds.db.DBUtil;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.ui.SchemaObjectDescriptor;
import oracle.jdeveloper.cm.dt.ui.TreeNodeMaker;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class DBObjectRenderer
implements Comparator,
TreeCellRenderer,
ListCellRenderer,
TableCellRenderer {
    private static final String EMPTY = "<" + CmWizardsArb.getString(250) + ">";
    private TableCellRenderer _tableDelegate;
    private ListCellRenderer _listDelegate;
    private TreeCellRenderer _treeDelegate;
    private String _nullLabel;
    private DBObjectProvider _prov;
    private boolean _iconify;
    private boolean _typeCompare;

    public DBObjectRenderer() {
    }

    public DBObjectRenderer(boolean bl) {
        this._iconify = bl;
    }

    public String getNullLabel() {
        return this._nullLabel;
    }

    public void setNullLabel(String string) {
        this._nullLabel = string;
    }

    public void setProvider(DBObjectProvider dBObjectProvider) {
        this._prov = dBObjectProvider;
    }

    public void setIncludeIcon(boolean bl) {
        this._iconify = bl;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (object instanceof DBObject && (object = ((DBObject)object).getName()) == null) {
            object = this._nullLabel;
        }
        if (this._tableDelegate == null) {
            this._tableDelegate = new DefaultTableCellRenderer();
        }
        return this._tableDelegate.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        if (this._listDelegate == null) {
            this._listDelegate = new DefaultListCellRenderer();
        }
        Object object2 = object;
        String string = null;
        if (object instanceof SQLFragment) {
            object2 = ((SQLFragment)object).getSQLText();
        } else if (object instanceof DBObject) {
            string = ((DBObject)object).getType();
            object2 = ((DBObject)object).getName();
            if (this._prov != null) {
                String string2 = null;
                try {
                    string2 = this._prov.quoteIdentifier((String)object2, false);
                }
                catch (DBException dBException) {
                    string2 = (String)object2;
                }
                object2 = string2;
            }
            if (!ModelUtil.hasLength((String)((String)object2)) && object instanceof Schema && ((Schema)object).getProperty("isDefaultSchema", (Object)Boolean.FALSE).equals(Boolean.TRUE)) {
                object2 = ConnectionArb.getString(373);
            }
            if (object2 == null) {
                object2 = this._nullLabel;
            }
        } else if (object instanceof SchemaObjectDescriptor) {
            object2 = ((SchemaObjectDescriptor)object).getName();
            String string3 = ((SchemaObjectDescriptor)object).getOriginalName();
            if (string3 != null && !string3.equals(object2)) {
                object2 = (String)object2 + " (was " + string3 + ")";
            }
            string = ((SchemaObjectDescriptor)object).getType();
        }
        JLabel jLabel = (JLabel)this._listDelegate.getListCellRendererComponent(jList, object2, n, bl, bl2);
        if (this._iconify && string != null) {
            jLabel.setIcon(DBUtil.getNodeIcon(string));
        }
        if (object instanceof AliasFragment) {
            this.setupAliasFragmentLabel(jLabel, (AliasFragment)object);
        } else if (object instanceof OrderByObject && (object2 == null || ((OrderByObject)object).getExpression() == null)) {
            jLabel.setText(EMPTY);
        }
        return jLabel;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        Icon icon;
        if (this._treeDelegate == null) {
            this._treeDelegate = new DefaultTreeCellRenderer();
        }
        JLabel jLabel = (JLabel)this._treeDelegate.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        String string = null;
        if (object instanceof DefaultMutableTreeNode) {
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (object2 instanceof SchemaObjectDescriptor) {
                jLabel.setText(((SchemaObjectDescriptor)object2).getName());
                string = ((SchemaObjectDescriptor)object2).getType();
            } else if (object2 instanceof AliasFragment) {
                if (object2 instanceof FromObject && ((FromObject)object2).getExpression() instanceof JoinObject) {
                    JoinObject joinObject = (JoinObject)((FromObject)object2).getExpression();
                    jLabel.setText(joinObject.getJoinType() + " JOIN");
                    if (this._iconify) {
                        jLabel.setIcon(DBUtil.getNodeIcon("CONSTRAINT"));
                    }
                } else {
                    this.setupAliasFragmentLabel(jLabel, (AliasFragment)object2);
                }
            } else if (object2 instanceof FKUsage) {
                FromObject fromObject;
                String string2 = null;
                DBObjectID dBObjectID = ((FKUsage)object2).getObjectID();
                if (dBObjectID != null) {
                    try {
                        DBObject dBObject = dBObjectID.resolveID();
                        string2 = dBObject.getName();
                    }
                    catch (DBException dBException) {
                        // empty catch block
                    }
                }
                if ((fromObject = ((FKUsage)object2).getRightFromObject()) != null) {
                    string2 = string2 + " (" + fromObject.getName() + ")";
                }
                jLabel.setText(string2);
                if (this._iconify) {
                    jLabel.setIcon(DBUtil.getNodeIcon("CONSTRAINT"));
                }
            } else if (object2 instanceof SQLFragment) {
                String string3 = ((SQLFragment)object2).getSQLText();
                jLabel.setText(string3);
                DBObjectRenderer.setToolTipText(jLabel, string3);
                if (object2 instanceof ColumnUsage) {
                    jLabel.setIcon(ConnectionArb.getIcon(444));
                } else {
                    jLabel.setIcon(ConnectionArb.getIcon(415));
                }
            } else if (object2 instanceof DBObject) {
                jLabel.setText(((DBObject)object2).getName());
                DBObjectRenderer.setToolTipText(jLabel, DBUtil.getFullyQualifiedName((DBObject)((DBObject)object2)));
                if (object2 instanceof FKConstraint) {
                    jLabel.setIcon(ConnectionArb.getIcon(445));
                } else if (object2 instanceof CheckConstraint) {
                    jLabel.setIcon(ConnectionArb.getIcon(692));
                } else if (object2 instanceof PKConstraint || object2 instanceof UniqueConstraint) {
                    jLabel.setIcon(ConnectionArb.getIcon(411));
                } else {
                    string = ((DBObject)object2).getType();
                }
            } else if (object2 instanceof String && this._iconify && !bl3) {
                Icon icon2 = DBUtil.getFolderIcon((String)object2);
                if (icon2 == null) {
                    jLabel.setIcon(IdeIcons.getIcon((int)4));
                } else {
                    jLabel.setIcon(icon2);
                }
            }
        }
        if (this._iconify && string != null && (icon = DBUtil.getNodeIcon(string)) != null) {
            jLabel.setIcon(icon);
        }
        return jLabel;
    }

    public int compare(Object object, Object object2) {
        if (object instanceof AliasFragment) {
            if (object2 instanceof AliasFragment) {
                return this.compare(((AliasFragment)object).getName(), ((AliasFragment)object2).getName());
            }
            return -100;
        }
        if (object instanceof SQLFragment) {
            if (object2 instanceof SQLFragment) {
                return this.compare(((SQLFragment)object).getSQLText(), ((SQLFragment)object2).getSQLText());
            }
            return -100;
        }
        if (object instanceof FunctionDefinition) {
            if (object2 instanceof FunctionDefinition) {
                return this.compare(((FunctionDefinition)object).getName(), ((FunctionDefinition)object2).getName());
            }
            return 100;
        }
        if (object instanceof DBObject) {
            if (object2 instanceof DBObject) {
                return this.compare((DBObject)object, (DBObject)object2);
            }
            return 100;
        }
        return 100;
    }

    public int compare(DBObject dBObject, DBObject dBObject2) {
        String string;
        String string2;
        int n;
        if (this._typeCompare && (n = this.compare(string2 = dBObject.getType(), string = dBObject2.getType())) != 0) {
            return n;
        }
        String string3 = dBObject.getName();
        String string4 = dBObject2.getName();
        return this.compare(string3, string4);
    }

    private int compare(String string, String string2) {
        return string == null ? (string2 == null ? 0 : 1) : string.compareTo(string2);
    }

    public void setCompareByType(boolean bl) {
        this._typeCompare = bl;
    }

    private void setupAliasFragmentLabel(JLabel jLabel, AliasFragment aliasFragment) {
        DBObjectID dBObjectID;
        String string = aliasFragment.getAlias();
        SQLFragment sQLFragment = aliasFragment.getExpression();
        String string2 = null;
        if (sQLFragment != null) {
            string2 = sQLFragment.getSQLText();
        }
        FastStringBuffer fastStringBuffer = new FastStringBuffer();
        if (ModelUtil.hasLength((String)string)) {
            fastStringBuffer.append(string);
            fastStringBuffer.append(" (");
            fastStringBuffer.append(string2);
            fastStringBuffer.append(")");
        } else if (ModelUtil.hasLength((String)string2)) {
            fastStringBuffer.append(string2);
        } else {
            fastStringBuffer.append(EMPTY);
        }
        jLabel.setText(fastStringBuffer.toString());
        if (this._iconify && sQLFragment instanceof DBObjectUsage && (dBObjectID = ((DBObjectUsage)sQLFragment).getObjectID()) != null) {
            String string3 = dBObjectID.getType();
            jLabel.setIcon(DBUtil.getNodeIcon(string3));
        }
    }

    public static void setToolTipText(JComponent jComponent, String string) {
        jComponent.setToolTipText(string);
        AccessibleContext accessibleContext = jComponent.getAccessibleContext();
        if (accessibleContext != null) {
            accessibleContext.setAccessibleName(string == null ? "" : string);
            accessibleContext.setAccessibleDescription("");
        }
    }

    public static DefaultMutableTreeNode createTreeNode(DBObject dBObject, boolean bl) {
        return DBObjectRenderer.createTreeNode(dBObject, bl, null);
    }

    public static DefaultMutableTreeNode createTreeNode(DBObject dBObject, boolean bl, String[] stringArray) {
        TreeNodeMaker treeNodeMaker = new TreeNodeMaker(true, stringArray);
        return treeNodeMaker.createTreeNode(dBObject);
    }

    public static DefaultMutableTreeNode createTreeNode(SQLFragment sQLFragment, boolean bl) {
        TreeNodeMaker treeNodeMaker = new TreeNodeMaker(true);
        return treeNodeMaker.createTreeNode(sQLFragment);
    }
}

