/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.ui;

import java.util.Collection;
import java.util.HashMap;
import javax.swing.JMenuItem;
import oracle.ide.util.MnemonicSolver;
import oracle.ide.util.ModelUtil;
import oracle.jdeveloper.cm.dt.ui.LabeledItem;

public class MnemonicResolver {
    private MnemonicSolver mnenomicSolver;
    private HashMap itemMap;

    public MnemonicResolver() {
        this.$init$();
    }

    public void addLabels(LabeledItem[] labeledItemArray) {
        int n = 0;
        while (n < labeledItemArray.length) {
            this.addLabel(labeledItemArray[n], null, false);
            ++n;
        }
    }

    public void addLabel(LabeledItem labeledItem) {
        this.addLabel(labeledItem, null, false);
    }

    public void addLabel(LabeledItem labeledItem, boolean bl) {
        this.addLabel(labeledItem, null, bl);
    }

    public void addLabel(LabeledItem labeledItem, String string, boolean bl) {
        if (labeledItem != null) {
            JMenuItem jMenuItem = new JMenuItem(ModelUtil.hasLength((String)string) ? string : labeledItem.getText(), labeledItem.getMnemonic());
            this.mnenomicSolver.addMenuLabel(jMenuItem, bl);
            this.itemMap.put(jMenuItem, labeledItem);
        }
    }

    public void addExcluded(String string) {
        if (ModelUtil.hasLength((String)string)) {
            int n = 0;
            while (n < string.length()) {
                this.mnenomicSolver.addMenuLabel(string.substring(n, n + 1), (int)string.charAt(n), true);
                ++n;
            }
        }
    }

    public void addExcluded(int n) {
        char[] cArray = new char[]{(char)n};
        this.mnenomicSolver.addMenuLabel(new String(cArray), n, true);
    }

    public void resolve() {
        Collection collection = this.mnenomicSolver.solve();
        for (MnemonicSolver.MenuLabel menuLabel : collection) {
            JMenuItem jMenuItem = menuLabel.getMenuItem();
            if (jMenuItem == null) continue;
            int n = menuLabel.getMnemonic();
            LabeledItem labeledItem = (LabeledItem)this.itemMap.get(jMenuItem);
            labeledItem.setText(menuLabel.getText());
            labeledItem.setMnemonic(n);
        }
    }

    void $init$() {
        this.mnenomicSolver = new MnemonicSolver();
        this.itemMap = new HashMap();
    }
}

