/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.ui;

import oracle.ide.util.ModelUtil;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;

public class SchemaObjectDescriptor {
    private String m_name;
    private SchemaObject m_obj;
    private String m_originalName;
    private String m_type;
    private String m_schema;

    public SchemaObjectDescriptor(String string, String string2, String string3) {
        this.m_originalName = string;
        this.m_type = string2;
        this.m_schema = string3;
    }

    public SchemaObjectDescriptor(SchemaObject schemaObject) {
        this.m_obj = schemaObject;
    }

    public String getName() {
        if (this.m_name != null) {
            return this.m_name;
        }
        return this.getOriginalName();
    }

    public String getOriginalName() {
        if (this.m_obj == null) {
            return this.m_originalName;
        }
        return this.m_obj.getName();
    }

    public String getType() {
        if (this.m_obj == null) {
            return this.m_type;
        }
        return this.m_obj.getType();
    }

    public String getSchema() {
        Schema schema;
        if (this.m_obj != null && (schema = this.m_obj.getSchema()) != null) {
            return schema.getName();
        }
        return this.m_schema;
    }

    public SchemaObject getObject() {
        return this.m_obj;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public void setOriginalName(String string) {
        this.m_originalName = string;
    }

    public void setType(String string) {
        this.m_type = string;
    }

    public void setSchema(String string) {
        this.m_schema = string;
    }

    public boolean equals(Object object) {
        return object instanceof SchemaObjectDescriptor && this.equalsImpl((SchemaObjectDescriptor)object, false);
    }

    protected boolean equalsImpl(SchemaObjectDescriptor schemaObjectDescriptor, boolean bl) {
        if (this.m_obj == null) {
            return ModelUtil.areEqual((Object)this.m_originalName, (Object)schemaObjectDescriptor.m_originalName) && ModelUtil.areEqual((Object)this.m_type, (Object)schemaObjectDescriptor.m_type) && ModelUtil.areEqual((Object)this.m_schema, (Object)schemaObjectDescriptor.m_schema) && (!bl || ModelUtil.areEqual((Object)this.m_name, (Object)schemaObjectDescriptor.m_name));
        }
        return ModelUtil.areEqual((Object)this.m_obj, (Object)schemaObjectDescriptor.m_obj) && (!bl || ModelUtil.areEqual((Object)this.m_name, (Object)schemaObjectDescriptor.m_name));
    }

    public boolean equals(Object object, boolean bl) {
        return object instanceof SchemaObjectDescriptor && this.equalsImpl((SchemaObjectDescriptor)object, bl);
    }

    public String toString() {
        return this.getOriginalName() + " (" + this.getSchema() + ")";
    }

    public SchemaObject unwrapDescriptor(DBObjectProvider dBObjectProvider) throws DBException {
        if (this.m_obj == null) {
            Schema schema = dBObjectProvider.getSchema(this.getSchema());
            this.m_obj = dBObjectProvider.getObject(this.getType(), schema, this.getOriginalName());
        }
        return this.m_obj;
    }

    public static SchemaObject[] unwrapDescriptors(SchemaObjectDescriptor[] schemaObjectDescriptorArray, DBObjectProvider dBObjectProvider) throws DBException {
        if (schemaObjectDescriptorArray != null) {
            SchemaObject[] schemaObjectArray = new SchemaObject[schemaObjectDescriptorArray.length];
            int n = 0;
            while (n < schemaObjectDescriptorArray.length) {
                schemaObjectArray[n] = schemaObjectDescriptorArray[n].unwrapDescriptor(dBObjectProvider);
                ++n;
            }
            return schemaObjectArray;
        }
        return null;
    }

    public static SchemaObjectDescriptor[] createDescriptors(SchemaObject[] schemaObjectArray) {
        if (schemaObjectArray != null) {
            SchemaObjectDescriptor[] schemaObjectDescriptorArray = new SchemaObjectDescriptor[schemaObjectArray.length];
            int n = 0;
            while (n < schemaObjectArray.length) {
                schemaObjectDescriptorArray[n] = new SchemaObjectDescriptor(schemaObjectArray[n]);
                ++n;
            }
            return schemaObjectDescriptorArray;
        }
        return null;
    }

    public static SchemaObjectDescriptor[] createDescriptors(DBObjectID[] dBObjectIDArray) {
        if (dBObjectIDArray != null) {
            SchemaObjectDescriptor[] schemaObjectDescriptorArray = new SchemaObjectDescriptor[dBObjectIDArray.length];
            int n = 0;
            while (n < dBObjectIDArray.length) {
                try {
                    DBObject dBObject = dBObjectIDArray[n].resolveID();
                    if (dBObject != null && dBObject instanceof SchemaObject) {
                        schemaObjectDescriptorArray[n] = new SchemaObjectDescriptor((SchemaObject)dBObject);
                    }
                }
                catch (DBException dBException) {
                    // empty catch block
                }
                ++n;
            }
            return schemaObjectDescriptorArray;
        }
        return null;
    }
}

