/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.ui;

import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxEditor;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.MutableComboBoxModel;
import oracle.ide.controls.AbstractPicker;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ValidationException;
import oracle.jdeveloper.cm.dt.ui.DBObjectRenderer;
import oracle.jdeveloper.cm.dt.verifier.Verifier;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class SchemaPicker
extends AbstractPicker {
    private DBObjectProvider _prov;
    private Verifier _verifier;

    public SchemaPicker() {
        Handler handler = new Handler(null);
        super.setEncoder((AbstractPicker.PickerValueEncoder)handler);
        super.setValidator((AbstractPicker.PickerResultValidator)handler);
        super.setEditor((ComboBoxEditor)new Editor(this.getEditor()));
        super.setRenderer((ListCellRenderer)new DBObjectRenderer());
    }

    public void setProvider(DBObjectProvider dBObjectProvider) {
        this._prov = dBObjectProvider;
    }

    public DBObjectProvider getProvider() {
        return this._prov;
    }

    public void setVerifier(Verifier verifier) {
        this._verifier = verifier;
    }

    public Verifier getVerifier() {
        return this._verifier;
    }

    protected void doBrowse() {
    }

    public void setSelectedItem(Object object) {
        if (object instanceof String) {
            object = new Schema((String)object);
        }
        if (object instanceof Schema) {
            MutableComboBoxModel mutableComboBoxModel = (MutableComboBoxModel)this.getModel();
            int n = 0;
            while (n < mutableComboBoxModel.getSize()) {
                Schema schema = (Schema)mutableComboBoxModel.getElementAt(n);
                if (schema.getName().equals(((Schema)object).getName())) {
                    object = schema;
                    break;
                }
                ++n;
            }
        }
        super.setSelectedItem(object);
    }

    public Schema getSchema(Schema[] schemaArray) throws TraversalException {
        Object object = this.getSelectedItem();
        String string = null;
        if (object instanceof String) {
            string = (String)object;
            if (this._prov != null) {
                if (!this._prov.isValidName("SCHEMA", string)) {
                    throw new TraversalException(CmWizardsArb.format(40, string), CmWizardsArb.getString(0));
                }
                string = this._prov.getInternalName(string);
            }
            object = new Schema(string);
        } else {
            string = ((Schema)object).getName();
        }
        Schema schema = (Schema)object;
        boolean bl = false;
        int n = 0;
        while (n < schemaArray.length) {
            if (string.equals(schemaArray[n].getName())) {
                bl = true;
                schema = schemaArray[n];
                break;
            }
            ++n;
        }
        if (!bl && this._prov != null) {
            try {
                this._prov.validateObject((DBObject)schema);
            }
            catch (ValidationException validationException) {
                throw new TraversalException(validationException.getMessage(), CmWizardsArb.getString(0));
            }
        }
        return schema;
    }

    static DBObjectProvider ra$_prov(SchemaPicker schemaPicker) {
        return schemaPicker._prov;
    }

    private class Handler
    implements AbstractPicker.PickerResultValidator,
    AbstractPicker.PickerValueEncoder {
        public Object encodeValue(Object object) {
            Object object2 = null;
            if (object instanceof Schema) {
                object2 = object;
            } else if (object instanceof String) {
                String string = (String)object;
                if (SchemaPicker.ra$_prov(SchemaPicker.this) != null) {
                    if (!SchemaPicker.ra$_prov(SchemaPicker.this).isValidName("SCHEMA", string)) {
                        try {
                            string = SchemaPicker.ra$_prov(SchemaPicker.this).quoteIdentifier(string, false);
                        }
                        catch (DBException dBException) {
                            // empty catch block
                        }
                    }
                    string = SchemaPicker.ra$_prov(SchemaPicker.this).getInternalName(string);
                }
                object2 = new Schema(string);
            }
            return object2;
        }

        public boolean isResultValid(Object object) {
            return object instanceof String ? SchemaPicker.ra$_prov(SchemaPicker.this).isValidName("SCHEMA", (String)object) : true;
        }

        public String getInvalidValueMsg(Object object) {
            return CmWizardsArb.format(40, object.toString());
        }

        private Handler() {
        }

        Handler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class Editor
    implements ComboBoxEditor {
        private ComboBoxEditor m_editor;

        public Editor(ComboBoxEditor comboBoxEditor) {
            this.m_editor = comboBoxEditor;
        }

        public Component getEditorComponent() {
            return this.m_editor.getEditorComponent();
        }

        public void setItem(Object object) {
            Component component;
            this.m_editor.setItem(object);
            if (object != null && (component = this.m_editor.getEditorComponent()) instanceof JTextField && SchemaPicker.ra$_prov(SchemaPicker.this) != null) {
                String string = null;
                string = object instanceof DBObject ? SchemaPicker.ra$_prov(SchemaPicker.this).getExternalName(((DBObject)object).getName()) : object.toString();
                ((JTextField)component).setText(string);
            }
        }

        public Object getItem() {
            return this.m_editor.getItem();
        }

        public void selectAll() {
            this.m_editor.selectAll();
        }

        public void addActionListener(ActionListener actionListener) {
            this.m_editor.addActionListener(actionListener);
        }

        public void removeActionListener(ActionListener actionListener) {
            this.m_editor.removeActionListener(actionListener);
        }
    }
}

