/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.bali.ewt.shuttle.ShuttleEvent;
import oracle.bali.ewt.shuttle.ShuttleListener;
import oracle.ide.component.CheckBoxListPanel;
import oracle.ide.config.ClientSetting;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.controls.checkboxlist.CheckBoxListItemStateListener;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.DynamicPropertySet;
import oracle.javatools.util.DynamicPropertySetImpl;
import oracle.jdeveloper.cm.ds.db.DBUtil;
import oracle.jdeveloper.cm.dt.ui.DBObjectRenderer;
import oracle.jdeveloper.cm.dt.ui.DBObjectSourcePicker;
import oracle.jdeveloper.cm.dt.ui.SchemaObjectDescriptor;
import oracle.jdeveloper.cm.dt.ui.SchemaObjectTargetPicker;
import oracle.jdeveloper.cm.dt.ui.SchemaPicker;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class SelectDBObjectsPanel
extends DefaultTraversablePanel
implements CheckBoxListItemStateListener,
KeyListener,
ShuttleListener,
DocumentListener,
ItemListener,
ActionListener {
    public static final String SELECTED_OBJECTS = "SelectDBObjectsPanel.SELECTED_OBJECTS";
    public static final String SETTINGS_KEY = SelectDBObjectsPanel.class.getName();
    private static final String SETTINGS_AUTO_QUERY_KEY = "autoQuery";
    private static final String SETTINGS_QUERY_KEY = "query";
    private static final String SETTINGS_FILTER_KEY = "filter";
    protected WizardCallbacks m_callBacks;
    private boolean m_entered;
    private boolean m_init;
    private Schema m_publicSchema;
    private DBObjectProvider m_pro;
    private SchemaObjectTargetPicker m_chosen;
    private DBObjectSourcePicker m_from;
    private List m_selectedTypes;
    private Timer m_timer;
    private JPanel m_centerPanel;
    private JLabel m_filterLabel;
    private JTextField m_filter;
    private JCheckBox m_autoQuery;
    private JLabel m_schemasLabel;
    protected DefaultComboBoxModel m_schemasModel;
    private SchemaPicker m_schemas;
    private JButton m_query;
    private JEWTDialog m_typesDialog;
    private CheckBoxListModel m_typeBoxes;
    private CheckBoxListPanel m_typesPanel;
    private JLabel m_typesDialogErrorLabel;
    private JLabel m_typeLabel;
    private JButton m_typeButton;
    protected Shuttle m_shuttle;

    void $init$() {
        this.m_centerPanel = new JPanel();
        this.m_filterLabel = new JLabel();
        this.m_filter = new JTextField();
        this.m_autoQuery = new JCheckBox();
        this.m_schemasLabel = new JLabel();
        this.m_schemasModel = new NonNullableComboBoxModel();
        this.m_schemas = new SchemaPicker();
        this.m_query = new JButton();
        this.m_typeLabel = new JLabel();
        this.m_typeButton = new JButton();
        this.m_shuttle = new Shuttle();
    }

    public SelectDBObjectsPanel() {
        this.$init$();
        try {
            this.layoutComponents();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void layoutComponents() {
        this.m_centerPanel.setLayout(new GridBagLayout());
        JPanel jPanel = this.getRow1();
        this.m_centerPanel.add((Component)jPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel2 = this.getRow2();
        this.m_centerPanel.add((Component)jPanel2, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.m_shuttle.addShuttleListener((ShuttleListener)this);
        this.m_centerPanel.add((Component)this.m_shuttle, new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.setLayout(new BorderLayout(5, 5));
        this.add(this.m_centerPanel, "Center");
    }

    private JPanel getRow1() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        ResourceUtils.resLabel((JLabel)this.m_schemasLabel, (Component)((Object)this.m_schemas), (String)CmWizardsArb.getString(311));
        jPanel.add((Component)this.m_schemasLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.m_schemas.setModel(this.m_schemasModel);
        this.m_schemas.addActionListener(this);
        jPanel.add((Component)((Object)this.m_schemas), new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 15), 0, 0));
        jPanel.add((Component)this.m_typeLabel, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.m_typeButton.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this.m_typeButton, (String)CmWizardsArb.getString(307));
        jPanel.add((Component)this.m_typeButton, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        return jPanel;
    }

    private JPanel getRow2() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        ResourceUtils.resLabel((JLabel)this.m_filterLabel, (Component)this.m_filter, (String)CmWizardsArb.getString(312));
        jPanel.add((Component)this.m_filterLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.m_filter.getDocument().addDocumentListener(this);
        this.m_filter.addKeyListener(this);
        jPanel.add((Component)this.m_filter, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        ResourceUtils.resButton((AbstractButton)this.m_autoQuery, (String)CmWizardsArb.getString(313));
        this.m_autoQuery.addItemListener(this);
        jPanel.add((Component)this.m_autoQuery, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 5), 0, 0));
        ResourceUtils.resButton((AbstractButton)this.m_query, (String)CmWizardsArb.getString(314));
        this.m_query.addActionListener(this);
        jPanel.add((Component)this.m_query, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        return jPanel;
    }

    private void setupTypesModel() {
        this.m_typesPanel = null;
        this.m_typeBoxes = new CheckBoxListModel();
        Object[] objectArray = this.getAvailableTypes();
        Arrays.sort(objectArray);
        int n = 0;
        while (n < objectArray.length) {
            String string = DBUtil.getDisplayName((String)objectArray[n]);
            Icon icon = DBUtil.getNodeIcon((String)objectArray[n]);
            this.m_typeBoxes.addElement(objectArray[n], icon, true, true, string);
            ++n;
        }
        this.m_typeBoxes.addCheckBoxStateListener((CheckBoxListItemStateListener)this);
    }

    protected final DBObjectProvider getProvider() {
        return this.m_pro;
    }

    protected DBObjectSourcePicker getFromPicker() {
        if (this.m_from == null) {
            this.m_from = new DBObjectSourcePicker(this.m_pro, false, true);
        }
        return this.m_from;
    }

    protected ItemPicker getToPicker() {
        if (this.m_chosen == null) {
            this.m_chosen = new SchemaObjectTargetPicker();
            if (this.canRenameObjects()) {
                this.m_chosen.setCanRename(true);
                this.m_shuttle.addShuttleListener((ShuttleListener)this.m_chosen);
            }
        }
        return this.m_chosen;
    }

    protected boolean canFinish() {
        return false;
    }

    protected boolean canAlwaysNext() {
        return false;
    }

    protected boolean canRenameObjects() {
        return false;
    }

    protected String[] getAvailableTypes() {
        return new String[]{"TABLE", "VIEW"};
    }

    protected String getProviderKey() {
        return "DBObjectProvider";
    }

    public final void onEntry(TraversableContext traversableContext) {
        this.m_callBacks = traversableContext.getWizardCallbacks();
        boolean bl = false;
        DBObjectProvider dBObjectProvider = (DBObjectProvider)traversableContext.get(this.getProviderKey());
        if (this.m_pro != dBObjectProvider) {
            bl = true;
        }
        this.m_pro = dBObjectProvider;
        if (this.m_pro != null) {
            this.init(bl, traversableContext);
            ItemPicker itemPicker = this.getToPicker();
            if (itemPicker instanceof Traversable) {
                ((Traversable)itemPicker).onEntry(traversableContext);
            }
            this.entered();
        }
    }

    public final void onExit(TraversableContext traversableContext) throws TraversalException {
        if (this.m_pro != null) {
            ItemPicker itemPicker = this.getToPicker();
            if (itemPicker instanceof Traversable) {
                ((Traversable)itemPicker).onExit(traversableContext);
            }
            this.exited();
            this.commit(traversableContext);
            this.saveSettings();
        }
    }

    private void entered() {
        this.m_entered = true;
    }

    private void exited() {
        this.m_entered = false;
        this.saveSettings();
    }

    protected void commit(TraversableContext traversableContext) throws TraversalException {
        traversableContext.put(SELECTED_OBJECTS, this.getSelectedObjects());
    }

    protected Object getSelectedObjects() {
        Object[] objectArray = null;
        if (this.m_chosen == null) {
            ItemPicker itemPicker = this.getToPicker();
            objectArray = itemPicker.getAllSelectableItems();
        } else {
            ListModel listModel = this.m_chosen.getList().getModel();
            int n = listModel.getSize();
            objectArray = new SchemaObjectDescriptor[n];
            int n2 = 0;
            while (n2 < n) {
                ((SchemaObjectDescriptor[])objectArray)[n2] = (SchemaObjectDescriptor)listModel.getElementAt(n2);
                ++n2;
            }
        }
        return objectArray;
    }

    protected void setIncludePublicSchema(boolean bl) {
        this.m_publicSchema = bl ? new Schema("PUBLIC") : null;
    }

    protected void init(boolean bl, TraversableContext traversableContext) {
        boolean bl2 = bl;
        if (!this.m_init) {
            this.m_init = true;
            bl2 = true;
        }
        this.setupTypesModel();
        this.loadSettings();
        if (bl2) {
            Schema schema = (Schema)traversableContext.get("Schema");
            this.m_schemas.setProvider(this.m_pro);
            this.getFromPicker().setProvider(this.m_pro);
            this.m_schemasModel.removeAllElements();
            try {
                Schema[] schemaArray = this.m_pro.listSchemas();
                TreeSet<Schema> treeSet = new TreeSet<Schema>();
                treeSet.addAll(Arrays.asList(schemaArray));
                if (this.m_publicSchema != null) {
                    treeSet.add(this.m_publicSchema);
                }
                Iterator iterator = treeSet.iterator();
                while (iterator.hasNext()) {
                    this.m_schemasModel.addElement(iterator.next());
                }
            }
            catch (DBException dBException) {
                dBException.printStackTrace();
            }
            if (schema != null && this.m_schemasModel.getIndexOf(schema) >= 0) {
                this.m_schemasModel.setSelectedItem(schema);
            } else if (this.m_pro != null && this.m_pro instanceof Database) {
                try {
                    String string = ((Database)this.m_pro).getUserName();
                    Schema schema2 = this.m_pro.getSchema(string);
                    if (this.m_schemasModel.getIndexOf(schema2) >= 0) {
                        this.m_schemasModel.setSelectedItem(schema2);
                    }
                }
                catch (DBException dBException) {
                    // empty catch block
                }
            }
            this.selectTypes();
            if (this.m_autoQuery.isSelected()) {
                this.fireQuery();
            }
        }
        this.checkWizardButtons();
        this.m_shuttle.setFromPicker((ItemPicker)this.getFromPicker());
        this.m_shuttle.setToPicker(this.getToPicker());
        if (this.m_callBacks != null) {
            if (this.m_autoQuery.isSelected()) {
                if (!this.getToPicker().isSelectableItemPresent()) {
                    this.m_callBacks.wizardSetInitialFocus((Component)this.getFromPicker().getTree());
                }
            } else {
                this.m_callBacks.wizardSetInitialFocus((Component)this.m_query);
            }
        }
    }

    protected void fireQuery() {
        this.getTimer().stop();
        DBObjectSourcePicker dBObjectSourcePicker = this.getFromPicker();
        if (dBObjectSourcePicker != null && this.m_selectedTypes != null) {
            Schema schema = (Schema)this.m_schemas.getSelectedItem();
            String string = this.m_filter.getText();
            String[] stringArray = this.m_selectedTypes.toArray(new String[this.m_selectedTypes.size()]);
            this.setupQuery(dBObjectSourcePicker, schema, string, stringArray);
            this.getTimer().stop();
            dBObjectSourcePicker.query();
            this.m_shuttle.setEnabled(true);
        }
    }

    protected void setupQuery(DBObjectSourcePicker dBObjectSourcePicker, Schema schema, String string, String[] stringArray) {
        dBObjectSourcePicker.setSchema(schema);
        dBObjectSourcePicker.setTypes(stringArray);
        if (string.startsWith("'") && string.endsWith("'") && !string.startsWith("''") && !string.endsWith("''")) {
            string = string.substring(1, string.length() - 1);
        }
        string = string.replaceAll("'", "''");
        if ((string = this.m_pro.getInternalName(string)).indexOf("%") < 0 && !string.endsWith("%")) {
            string = string + "%";
        }
        dBObjectSourcePicker.setFilter(string);
        this.m_filter.setText(this.externaliseFilter(string));
    }

    private String externaliseFilter(String string) {
        String string2;
        String string3;
        String string4 = string3 = ModelUtil.hasLength((String)string) ? this.m_pro.getExternalName(string) : "";
        if (string.indexOf(37) < 0) {
            String string5 = this.m_pro.getIdentifierQuoteString();
            if (string5 != null && string3.endsWith(string5)) {
                return string3.substring(0, string3.lastIndexOf(string5)) + '%' + string5;
            }
            return string3 + '%';
        }
        String string6 = string.replaceAll("%", "");
        String string7 = string2 = ModelUtil.hasLength((String)string6) ? this.m_pro.getExternalName(string6) : string6;
        if (string6.equals(string2)) {
            return string;
        }
        return string3;
    }

    private void selectTypes() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer();
        fastStringBuffer.append(CmWizardsArb.getString(310));
        this.m_selectedTypes = this.m_typeBoxes.getSelectionList();
        if (this.m_selectedTypes != null) {
            Iterator iterator = this.m_selectedTypes.iterator();
            while (iterator.hasNext()) {
                fastStringBuffer.append(" ");
                fastStringBuffer.append(DBUtil.getDisplayName((String)iterator.next()));
            }
        }
        DBObjectRenderer.setToolTipText(this.m_typeButton, fastStringBuffer.toString());
        if (this.m_selectedTypes == null || this.m_selectedTypes.size() < this.m_typeBoxes.getSize()) {
            this.m_typeLabel.setText(CmWizardsArb.getString(308));
        } else {
            this.m_typeLabel.setText(CmWizardsArb.getString(309));
        }
    }

    private Timer getTimer() {
        if (this.m_timer == null) {
            1 var1_1 = new 1();
            this.m_timer = new Timer(2000, var1_1);
            this.m_timer.setRepeats(false);
        }
        return this.m_timer;
    }

    protected String getSettingsKey() {
        return SETTINGS_KEY;
    }

    protected void loadSettings() {
        String string = this.getSettingsKey();
        DynamicPropertySet dynamicPropertySet = null;
        if (string != null) {
            ClientSetting clientSetting = ClientSetting.findOrCreate((String)"oracle.onlinedb");
            dynamicPropertySet = (DynamicPropertySet)clientSetting.getData(string);
        }
        if (dynamicPropertySet != null) {
            Boolean bl = (Boolean)dynamicPropertySet.getProperty(SETTINGS_AUTO_QUERY_KEY);
            if (bl != null) {
                this.m_autoQuery.setSelected(bl);
                this.m_query.setEnabled(bl ^ true);
            }
            this.m_typeBoxes.deselectAll();
            int n = 0;
            while (n < this.m_typeBoxes.getSize()) {
                String string2 = (String)this.m_typeBoxes.getUserObjectAt(n);
                boolean bl2 = dynamicPropertySet.getProperty(SETTINGS_QUERY_KEY + string2, (Object)Boolean.TRUE).equals(Boolean.TRUE);
                if (bl2) {
                    this.m_typeBoxes.setElementSelected(n);
                }
                ++n;
            }
            List list = this.m_typeBoxes.getSelectionList();
            if (list == null || list.size() < 1) {
                this.m_typeBoxes.selectAll();
            }
            this.m_filter.setText((String)dynamicPropertySet.getProperty(SETTINGS_FILTER_KEY));
        } else {
            this.setDefaultSettings();
        }
    }

    protected void setDefaultSettings() {
        boolean bl = this.m_pro instanceof Database ^ true;
        this.m_autoQuery.setSelected(bl);
        this.m_query.setEnabled(bl ^ true);
    }

    protected void saveSettings() {
        String string = this.getSettingsKey();
        if (string != null) {
            ClientSetting clientSetting = ClientSetting.findOrCreate((String)"oracle.onlinedb");
            DynamicPropertySet dynamicPropertySet = (DynamicPropertySet)clientSetting.getData(string);
            if (dynamicPropertySet == null) {
                dynamicPropertySet = new DynamicPropertySetImpl();
                clientSetting.putData(string, (Copyable)dynamicPropertySet);
            }
            dynamicPropertySet.setProperty(SETTINGS_AUTO_QUERY_KEY, (Object)(this.m_autoQuery.isSelected() ? Boolean.TRUE : Boolean.FALSE));
            int n = 0;
            while (n < this.m_typeBoxes.getSize()) {
                String string2 = (String)this.m_typeBoxes.getUserObjectAt(n);
                dynamicPropertySet.setProperty(SETTINGS_QUERY_KEY + string2, (Object)(this.m_typeBoxes.isElementSelected(n) ? Boolean.TRUE : Boolean.FALSE));
                ++n;
            }
            dynamicPropertySet.setProperty(SETTINGS_FILTER_KEY, (Object)this.m_filter.getText());
        }
    }

    protected void checkWizardButtons() {
        ItemPicker itemPicker;
        if (this.m_callBacks != null && (itemPicker = this.getToPicker()) != null) {
            Boolean bl;
            Transferable[] transferableArray = itemPicker.getAllSelectableItems();
            boolean bl2 = transferableArray != null && transferableArray.length > 0;
            Boolean bl3 = bl = this.canFinish() && bl2 ? Boolean.TRUE : Boolean.FALSE;
            Boolean bl4 = this.canAlwaysNext() ? Boolean.TRUE : (bl2 ? Boolean.TRUE : Boolean.FALSE);
            this.m_callBacks.wizardEnableButtons(null, bl4, bl);
        }
    }

    private void resolveMnemonics() {
    }

    private void showFilterTypesDialog() {
        this.m_typesDialog = JEWTDialog.createDialog((Component)this.m_typeButton, (String)CmWizardsArb.getString(489), (int)3);
        JPanel jPanel = new JPanel(new BorderLayout(0, 5));
        if (this.m_typesPanel == null) {
            this.m_typesPanel = new CheckBoxListPanel(this.m_typeBoxes);
            this.m_typesPanel.getList().setLayoutOrientation(1);
        }
        jPanel.add((Component)this.m_typesPanel, "Center");
        if (this.m_typesDialogErrorLabel == null) {
            this.m_typesDialogErrorLabel = new JLabel(" ");
        }
        jPanel.add((Component)this.m_typesDialogErrorLabel, "South");
        this.m_typesDialog.setContent((Component)jPanel);
        try {
            if (this.m_typesDialog.runDialog()) {
                this.selectTypes();
                if (this.m_autoQuery.isSelected()) {
                    this.fireQuery();
                }
            } else {
                this.m_typeBoxes.deselectAll();
                int n = 0;
                while (n < this.m_typeBoxes.getSize()) {
                    if (this.m_selectedTypes.contains(this.m_typeBoxes.getUserObjectAt(n))) {
                        this.m_typeBoxes.setElementSelected(n);
                    }
                    ++n;
                }
            }
        }
        finally {
            this.m_typesDialog.dispose();
            this.m_typesDialog = null;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.m_entered) {
            Object object = actionEvent.getSource();
            if (object == this.m_query) {
                this.fireQuery();
            } else if (object == this.m_schemas) {
                if (this.m_autoQuery.isSelected()) {
                    this.fireQuery();
                }
            } else if (object == this.m_typeButton) {
                this.showFilterTypesDialog();
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object;
        if (this.m_entered && (object = itemEvent.getSource()) == this.m_autoQuery) {
            switch (itemEvent.getStateChange()) {
                case 1: {
                    this.m_query.setEnabled(false);
                    this.fireQuery();
                    break;
                }
                case 2: {
                    this.m_query.setEnabled(true);
                }
            }
        }
    }

    private void showTypesErrorDialog(Component component) {
        MessageDialog.error((Component)component, (Object)CmWizardsArb.getString(328), (String)CmWizardsArb.getString(329), null);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.m_entered && this.m_autoQuery.isSelected()) {
            this.getTimer().restart();
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.m_entered && this.m_autoQuery.isSelected()) {
            this.getTimer().restart();
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.m_entered && this.m_autoQuery.isSelected()) {
            this.getTimer().restart();
        }
    }

    public void shuttleItemsMoved(ShuttleEvent shuttleEvent) {
        this.checkWizardButtons();
    }

    public void shuttleItemsRemoved(ShuttleEvent shuttleEvent) {
        this.checkWizardButtons();
    }

    public void shuttleItemsReordered(ShuttleEvent shuttleEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.fireQuery();
            keyEvent.consume();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void stateChanged(Object object) {
        if (this.m_typesDialog != null) {
            List list = this.m_typeBoxes.getSelectionList();
            if (list == null || list.isEmpty()) {
                this.m_typesDialogErrorLabel.setText(CmWizardsArb.getString(328));
                this.m_typesDialog.setOKButtonEnabled(false);
            } else {
                this.m_typesDialogErrorLabel.setText(" ");
                this.m_typesDialog.setOKButtonEnabled(true);
            }
        }
    }

    public final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SelectDBObjectsPanel.this.fireQuery();
        }
    }
}

