/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.ide.Ide;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TabbedPanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.cm.dt.dialog.SQLErrorDialog;
import oracle.jdeveloper.cm.dt.ui.BaseInfoPanel;
import oracle.jdeveloper.cm.dt.ui.DBObjectRenderer;
import oracle.jdeveloper.cm.dt.ui.OracleDBWizardFactory;
import oracle.jdeveloper.cm.dt.ui.SchemaPicker;
import oracle.jdeveloper.cm.dt.ui.UIConstants;
import oracle.jdeveloper.cm.dt.verifier.SchemaObjectInfoVerifier;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class TabbedDBPanel
extends BaseInfoPanel
implements KeyListener,
FocusListener,
ActionListener,
UIConstants {
    public static final String DEFAULT_TABSET_KEY = "DEFAULT";
    protected final SchemaPicker _cmbOwner;
    protected final DefaultComboBoxModel _mdlOwner;
    private final DBObjectRenderer _rndOwner;
    private final JLabel _errLabel;
    protected SchemaObject _schemaObject;
    protected Schema[] _schemas;
    protected OracleDatabase _db;
    protected SchemaObjectInfoVerifier _verifier;
    protected String _errorTitle;
    protected final JTextField _fldName;
    private Map<String, TabbedPanel> _mapTabPanels;
    private CardLayout _layTabHost;
    private JPanel _pnlTabHost;
    private TraversableContext _dataContext;
    private TabbedPanel _currTabPanel;
    private String _topLabelText;
    protected boolean _edit;

    void $init$() {
        this._cmbOwner = new SchemaPicker();
        this._mdlOwner = new NonNullableComboBoxModel();
        this._rndOwner = new DBObjectRenderer();
        this._errLabel = new JLabel();
        this._schemaObject = null;
        this._db = null;
        this._verifier = null;
        this._errorTitle = null;
        this._fldName = new JTextField();
        this._mapTabPanels = new HashMap<String, TabbedPanel>();
        this._layTabHost = new CardLayout();
        this._pnlTabHost = new JPanel(this._layTabHost);
    }

    public TabbedDBPanel() {
        this.$init$();
        this._edit = false;
        this._errorTitle = "Error";
    }

    public TabbedDBPanel(Navigable[] navigableArray) {
        this();
        this.addTabSet(navigableArray, DEFAULT_TABSET_KEY);
        this._currTabPanel = this._mapTabPanels.get(DEFAULT_TABSET_KEY);
    }

    public void addTabSet(Navigable[] navigableArray, String string) {
        TabbedPanel tabbedPanel = new TabbedPanel(navigableArray);
        this._mapTabPanels.put(string, tabbedPanel);
        this._pnlTabHost.add((Component)tabbedPanel, string);
        if (this._currTabPanel == null) {
            this._currTabPanel = tabbedPanel;
        }
    }

    public void showTabSet(String string) throws TraversalException {
        TabbedPanel tabbedPanel = this._mapTabPanels.get(string);
        if (tabbedPanel != null) {
            this._currTabPanel.onExit(this._dataContext);
            this._currTabPanel = tabbedPanel;
            this._layTabHost.show(this._pnlTabHost, string);
            tabbedPanel.onEntry(this._dataContext);
        }
    }

    public boolean setRootNavigables(Navigable[] navigableArray) {
        return false;
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.commit((SchemaObject)traversableContext.find("OriginalObject"), (SchemaObject)traversableContext.find("NewObject"), (Schema[])traversableContext.find("SchemaList"));
        try {
            this._currTabPanel.onExit(traversableContext);
            if (this._edit) {
                this.modifyObject(traversableContext);
            } else {
                this.createObject(traversableContext);
            }
        }
        catch (TraversalException traversalException) {
            this._currTabPanel.onEntry(traversableContext);
            throw traversalException;
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        DBObjectProvider dBObjectProvider = (DBObjectProvider)traversableContext.find("DBObjectProvider");
        this._schemaObject = (SchemaObject)traversableContext.find("NewObject");
        this._verifier = (SchemaObjectInfoVerifier)traversableContext.find("SchemaObjectInfoVerifier");
        this._schemas = (Schema[])traversableContext.find("SchemaList");
        this._db = (OracleDatabase)traversableContext.find("DBObjectProvider");
        if (traversableContext.find("OriginalObject") != null) {
            this._edit = true;
        }
        this.init(dBObjectProvider, this._schemaObject, this._verifier, this._schemas);
        this._dataContext = traversableContext;
        this._currTabPanel.onEntry(traversableContext);
    }

    public Component getComponent() {
        if (this.getComponentCount() == 0) {
            JPanel jPanel = this.buildPnlInfo();
            this.setLayout(new BorderLayout());
            this.add(jPanel, "North");
            this.add(this._pnlTabHost, "Center");
        }
        return this;
    }

    public void setTopLabel(String string) {
        this._topLabelText = string;
    }

    protected void init(DBObjectProvider dBObjectProvider, SchemaObject schemaObject, SchemaObjectInfoVerifier schemaObjectInfoVerifier, Schema[] schemaArray) {
        this.init(dBObjectProvider, schemaObjectInfoVerifier);
        this._cmbOwner.setProvider(dBObjectProvider);
        this._rndOwner.setProvider(dBObjectProvider);
        this._mdlOwner.removeAllElements();
        int n = 0;
        while (n < schemaArray.length) {
            this._mdlOwner.addElement(schemaArray[n]);
            ++n;
        }
        this.validateSchemaPermissions();
        Schema schema = schemaObject.getSchema();
        if (schema != null) {
            if (this._mdlOwner.getIndexOf(schema) < 0) {
                this._mdlOwner.addElement(schema);
            }
            this._mdlOwner.setSelectedItem(schema);
        }
        this._cmbOwner.setEnabled(schemaObjectInfoVerifier == null || schemaObjectInfoVerifier.canChangeSchema());
        this._cmbOwner.setEditable(schemaObjectInfoVerifier == null || schemaObjectInfoVerifier.canCreateSchema());
        String string = this.getExternalName(schemaObject.getName());
        this._fldName.setText(string);
        this._fldName.setEnabled(schemaObjectInfoVerifier == null || schemaObjectInfoVerifier.canChangeName());
    }

    protected void commit(SchemaObject schemaObject, SchemaObject schemaObject2, Schema[] schemaArray) throws TraversalException {
        SchemaObjectInfoVerifier schemaObjectInfoVerifier = (SchemaObjectInfoVerifier)this.getVerifier();
        Schema schema = this._cmbOwner.getSchema(schemaArray);
        String string = this.getInternalName(this._fldName.getText());
        schemaObject2.setSchema(schema);
        schemaObject2.setName(string);
        schemaObjectInfoVerifier.verifyObject();
    }

    protected void createObject(TraversableContext traversableContext) throws TraversalException {
        this.createObject(traversableContext, "NewObject");
    }

    protected void createObject(TraversableContext traversableContext, String string) throws TraversalException {
        OracleDBWizardFactory.createOracleObject(traversableContext, string, this._errorTitle, "Error creating object");
    }

    protected void modifyObject(TraversableContext traversableContext) throws TraversalException {
        SchemaObject schemaObject = (SchemaObject)traversableContext.find("OriginalObject");
        SchemaObject schemaObject2 = (SchemaObject)traversableContext.find("NewObject");
        OracleDatabase oracleDatabase = (OracleDatabase)traversableContext.find("DBObjectProvider");
        try {
            oracleDatabase.updateObject(schemaObject, schemaObject2);
        }
        catch (DBException dBException) {
            Throwable throwable = dBException.getCause();
            if (throwable instanceof SQLException) {
                SQLErrorDialog.showErrorDialog(null, this._errorTitle, (SQLException)throwable);
            } else {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)(throwable != null ? throwable : dBException), (String)this._errorTitle, (String)"Error creating table", null);
            }
            throw new TraversalException(null);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.updateIdentifier(true);
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.updateIdentifier(true);
    }

    protected void updateIdentifier(boolean bl) {
        if (this._schemaObject != null) {
            String string = this._fldName.getText();
            try {
                this._verifier.verifyName(string);
                string = this._db.getInternalName(string, this._schemaObject.getType());
                this._schemaObject.setName(string);
                this._fldName.setBackground(new Color(255, 255, 255));
                this._errLabel.setText("");
            }
            catch (TraversalException traversalException) {
                this._fldName.setBackground(new Color(255, 150, 150));
                this._errLabel.setText(traversalException.getLocalizedMessage());
                return;
            }
            try {
                boolean bl2;
                Schema schema = this._cmbOwner.getSchema(this._schemas);
                if (bl && !this._edit && (bl2 = this._db.exists(this._schemaObject.getType(), schema.getName(), string))) {
                    this._fldName.setBackground(new Color(255, 150, 150));
                    this._errLabel.setText(MessageFormat.format(CmWizardsArb.getString(486), this._schemaObject.getType()));
                }
                this._schemaObject.setSchema(schema);
            }
            catch (TraversalException traversalException) {
                traversalException.printStackTrace();
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this._errLabel.getText().length() > 0) {
            this.updateIdentifier(true);
        } else {
            this.updateIdentifier(false);
        }
    }

    public void setErrorTitle(String string) {
        this._errorTitle = string;
    }

    private void validateSchemaPermissions() {
        int n = this._mdlOwner.getSize() - 1;
        while (n >= 0) {
            Schema schema = (Schema)this._mdlOwner.getElementAt(n);
            if (!this._edit) {
                if (!this._db.hasPriviledge(this._schemaObject.getType(), schema, "CREATE")) {
                    this._mdlOwner.removeElementAt(n);
                }
            } else if (this._db.hasPriviledge(this._schemaObject.getType(), this._schemas[n], "MODIFY")) {
                this._mdlOwner.removeElementAt(n);
            }
            --n;
        }
    }

    public String getHelpID() {
        return this._currTabPanel.getHelpID();
    }

    protected JPanel buildPnlInfo() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel();
        this._cmbOwner.setModel(this._mdlOwner);
        this._cmbOwner.setRenderer(this._rndOwner);
        this._cmbOwner.addActionListener(this);
        ResourceUtils.resLabel((JLabel)jLabel, (Component)((Object)this._cmbOwner), (String)CmWizardsArb.getString(17));
        jPanel.add((Component)jLabel, this.gbc(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 15)));
        jPanel.add((Component)((Object)this._cmbOwner), this.gbc(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0)));
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._fldName, (String)CmWizardsArb.getString(18));
        this._fldName.setColumns(30);
        this._fldName.addKeyListener(this);
        this._fldName.addFocusListener(this);
        jPanel.add((Component)jLabel2, this.gbc(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 15)));
        jPanel.add((Component)this._fldName, this.gbc(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 0, 0)));
        jPanel.add((Component)this._errLabel, this.gbc(2, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 0, 0, 0)));
        jPanel.add(Box.createHorizontalGlue(), this.gbc(2, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 0, 0, 0)));
        return jPanel;
    }
}

