/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.ui;

import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.sql.DBObjectUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.JoinObject;
import oracle.javatools.db.sql.RelationUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.SelectObjectUsage;
import oracle.javatools.db.sql.SynonymUsage;

public class TreeNodeMaker {
    private boolean m_showChildren;
    private String[] m_childTypes;
    private boolean m_fkDeep;

    public TreeNodeMaker() {
    }

    public TreeNodeMaker(boolean bl) {
        this.m_showChildren = bl;
    }

    public TreeNodeMaker(boolean bl, String[] stringArray) {
        this.m_showChildren = bl;
        this.m_childTypes = stringArray;
    }

    public void setShowChildren(boolean bl) {
        this.m_showChildren = bl;
    }

    public boolean getShowChildren() {
        return this.m_showChildren;
    }

    public void setChildTypes(String[] stringArray) {
        this.m_childTypes = stringArray;
    }

    public void setDeepFKs(boolean bl) {
        this.m_fkDeep = bl;
    }

    public DefaultMutableTreeNode createTreeNode(DBObject dBObject) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        block8: {
            if (dBObject instanceof FKConstraint) {
                return new FKTreeNode((FKConstraint)dBObject);
            }
            defaultMutableTreeNode = new DefaultMutableTreeNode(dBObject);
            if (!this.m_showChildren) break block8;
            if (this.m_childTypes == null) {
                DBObject[] dBObjectArray = dBObject.getOwnedObjects();
                int n = 0;
                while (n < dBObjectArray.length) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = this.createTreeNode(dBObjectArray[n]);
                    if (defaultMutableTreeNode2 != null) {
                        defaultMutableTreeNode.add(defaultMutableTreeNode2);
                    }
                    ++n;
                }
            } else {
                int n = 0;
                while (n < this.m_childTypes.length) {
                    DBObject[] dBObjectArray = dBObject.getOwnedObjects(new String[]{this.m_childTypes[n]});
                    int n2 = 0;
                    while (n2 < dBObjectArray.length) {
                        DefaultMutableTreeNode defaultMutableTreeNode3 = this.createTreeNode(dBObjectArray[n2]);
                        if (defaultMutableTreeNode3 != null) {
                            defaultMutableTreeNode.add(defaultMutableTreeNode3);
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
        }
        return defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode createTreeNode(SQLFragment sQLFragment) {
        return this.createTreeNode(sQLFragment, false);
    }

    public DefaultMutableTreeNode createTreeNode(SQLFragment sQLFragment, boolean bl) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        block10: {
            SQLFragment sQLFragment2;
            block11: {
                SchemaObject schemaObject;
                SQLFragment sQLFragment3;
                defaultMutableTreeNode = new DefaultMutableTreeNode(sQLFragment);
                if (sQLFragment instanceof FromObject && this.m_showChildren && (sQLFragment3 = ((FromObject)sQLFragment).getExpression()) instanceof JoinObject) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = this.createTreeNode((SQLFragment)((JoinObject)sQLFragment3).getLeftExpression());
                    DefaultMutableTreeNode defaultMutableTreeNode3 = this.createTreeNode((SQLFragment)((JoinObject)sQLFragment3).getRightExpression());
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                    defaultMutableTreeNode.add(defaultMutableTreeNode3);
                }
                if (!bl || !(sQLFragment instanceof FromObject) || (sQLFragment2 = ((FromObject)sQLFragment).getExpression()) == null) break block10;
                if (!(sQLFragment2 instanceof DBObjectUsage)) break block11;
                Relation relation = null;
                if (sQLFragment2 instanceof RelationUsage) {
                    DBObjectID dBObjectID = ((RelationUsage)sQLFragment2).getObjectID();
                    if (dBObjectID != null) {
                        try {
                            relation = (Relation)dBObjectID.resolveID();
                        }
                        catch (DBException dBException) {}
                    }
                } else if (sQLFragment2 instanceof SynonymUsage && (schemaObject = ((SynonymUsage)sQLFragment2).getReferencedObject()) instanceof Relation) {
                    relation = (Relation)schemaObject;
                }
                if (relation == null) break block10;
                Column[] columnArray = relation.getColumns();
                int n = 0;
                while (columnArray != null && n < columnArray.length) {
                    defaultMutableTreeNode.add(this.createTreeNode((DBObject)columnArray[n]));
                    ++n;
                }
                break block10;
            }
            if (sQLFragment2 instanceof SQLQuery) {
                SelectObject[] selectObjectArray = ((SQLQuery)sQLFragment2).getSelectObjects();
                int n = 0;
                while (n < selectObjectArray.length) {
                    defaultMutableTreeNode.add(this.createTreeNode((SQLFragment)new SelectObjectUsage(selectObjectArray[n], (FromObject)sQLFragment)));
                    ++n;
                }
            }
        }
        return defaultMutableTreeNode;
    }

    static boolean ra$m_fkDeep(TreeNodeMaker treeNodeMaker) {
        return treeNodeMaker.m_fkDeep;
    }

    private class FKTreeNode
    extends DefaultMutableTreeNode {
        private boolean m_init;

        FKTreeNode(FKConstraint fKConstraint) {
            super(fKConstraint);
        }

        FKConstraint getFKConstraint() {
            return (FKConstraint)this.getUserObject();
        }

        private void init() {
            if (!this.m_init) {
                try {
                    DBObjectID dBObjectID;
                    DBObject dBObject;
                    this.m_init = true;
                    if (TreeNodeMaker.ra$m_fkDeep(TreeNodeMaker.this) && (dBObject = (dBObjectID = this.getFKConstraint().getReferenceID()).resolveID()) != null && dBObject instanceof Constraint) {
                        this.add(TreeNodeMaker.this.createTreeNode((DBObject)((Constraint)dBObject).getRelation()));
                    }
                }
                catch (DBException dBException) {
                    dBException.printStackTrace();
                }
            }
        }

        public Enumeration children() {
            this.init();
            return super.children();
        }

        public TreeNode getChildAfter(TreeNode treeNode) {
            this.init();
            return super.getChildAfter(treeNode);
        }

        public TreeNode getChildAt(int n) {
            this.init();
            return super.getChildAt(n);
        }

        public TreeNode getChildBefore(TreeNode treeNode) {
            this.init();
            return super.getChildBefore(treeNode);
        }

        public int getChildCount() {
            this.init();
            return super.getChildCount();
        }

        public TreeNode getLastChild() {
            this.init();
            return super.getLastChild();
        }

        public void insert(MutableTreeNode mutableTreeNode, int n) {
            this.init();
            super.insert(mutableTreeNode, n);
        }

        public boolean isLeaf() {
            return false;
        }
    }
}

