/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.ui.plsql;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.datatypes.ObjectType;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.ui.plsql.NewPlsqlPanel;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public final class NewUserDefinedTypePanel
extends NewPlsqlPanel {
    private NewPlsqlPanel.PlSqlComboItem m_default;

    public NewUserDefinedTypePanel() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_sqlplsqlsubprogram_html");
    }

    public String getHeaderTitle() {
        return CmWizardsArb.getString(414);
    }

    public String getHeaderDescription() {
        return CmWizardsArb.getString(415);
    }

    public String getNameLabel() {
        return CmWizardsArb.getString(18);
    }

    public String getTypeLabel() {
        return CmWizardsArb.getString(416);
    }

    public String getDefaultName(TraversableContext traversableContext) {
        ObjectType objectType = (ObjectType)traversableContext.find("NewObject");
        return objectType.getName();
    }

    public List getTypeList(TraversableContext traversableContext) {
        ArrayList<NewPlsqlPanel.PlSqlComboItem> arrayList = new ArrayList<NewPlsqlPanel.PlSqlComboItem>();
        arrayList.add((NewPlsqlPanel)this.new NewPlsqlPanel.PlSqlComboItem("TYPE", 286, 290, true));
        this.m_default = (NewPlsqlPanel)this.new NewPlsqlPanel.PlSqlComboItem("TYPE", 283, 287, false);
        arrayList.add(this.m_default);
        arrayList.add(new NewPlsqlPanel.PlSqlComboItem("TYPE", 284, 287, 288, false));
        arrayList.add((NewPlsqlPanel)this.new NewPlsqlPanel.PlSqlComboItem("TYPE", 285, 289, true));
        return arrayList;
    }

    public NewPlsqlPanel.PlSqlComboItem getDefaultComboItem() {
        return this.m_default;
    }

    protected void performProcess(TraversableContext traversableContext) throws TraversalException {
        DBObjectProvider dBObjectProvider = (DBObjectProvider)traversableContext.find("DBObjectProvider");
        ObjectType objectType = (ObjectType)traversableContext.find("NewObject");
        String string = this.getSelectedName();
        try {
            dBObjectProvider.validateName(objectType.getType(), string);
        }
        catch (InvalidNameException invalidNameException) {
            throw new TraversalException(invalidNameException.getMessage(), CmWizardsArb.format(246, string));
        }
        objectType.setName(dBObjectProvider.getInternalName(string));
        String string2 = dBObjectProvider.getExternalName(objectType.getName());
        Schema[] schemaArray = (Schema[])traversableContext.find("SchemaList");
        Schema schema = this.getSelectedSchema(schemaArray);
        objectType.setSchema(schema);
        NewPlsqlPanel.PlSqlComboItem plSqlComboItem = this.getSelectedType();
        if (plSqlComboItem.isCollectionType()) {
            objectType.setTypeCode("COLLECTION");
        } else {
            objectType.setTypeCode("OBJECT");
        }
        objectType.setSource(ConnectionArb.format(plSqlComboItem.getPlsql(), string2));
        int n = plSqlComboItem.getExtraPlsql();
        objectType.setBodySource(n > 0 ? ConnectionArb.format(n, string2) : null);
        try {
            dBObjectProvider.validateObject((DBObject)objectType);
        }
        catch (ValidationException validationException) {
            throw new TraversalException(validationException.getMessage(), CmWizardsArb.format(246, string2));
        }
    }
}

