/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.ui.reconcile;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import oracle.jdeveloper.cm.ds.db.DBUtil;
import oracle.jdeveloper.cm.dt.ui.reconcile.ReconcileTreeNode;

public class CompareTreeCellRenderer
implements TreeCellRenderer {
    private TreeCellRenderer m_treeDelegate;
    private boolean m_iconify;
    private static LineBorder m_lineBorder;
    private static EmptyBorder m_emptyBorder;

    void $init$() {
        this.m_iconify = true;
    }

    public CompareTreeCellRenderer() {
        this.$init$();
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        Object object2;
        if (this.m_treeDelegate == null) {
            this.m_treeDelegate = new DefaultTreeCellRenderer();
        }
        JLabel jLabel = (JLabel)this.m_treeDelegate.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        jLabel.setOpaque(false);
        jLabel.setBackground(Color.WHITE);
        jLabel.setForeground(Color.BLACK);
        if (bl4) {
            if (m_lineBorder == null) {
                m_lineBorder = new LineBorder(Color.ORANGE);
            }
            jLabel.setBorder(m_lineBorder);
        } else {
            if (m_emptyBorder == null) {
                m_emptyBorder = new EmptyBorder(1, 1, 1, 1);
            }
            jLabel.setBorder(m_emptyBorder);
        }
        if (object instanceof ReconcileTreeNode) {
            ReconcileTreeNode reconcileTreeNode = (ReconcileTreeNode)object;
            jLabel.setIcon(reconcileTreeNode.isShuttled() ? reconcileTreeNode.getShuttledIcon() : reconcileTreeNode.getIcon());
            jLabel.setOpaque(true);
            jLabel.setBackground(reconcileTreeNode.getBackground());
            jLabel.setFont(jLabel.getFont().deriveFont(0));
            if (reconcileTreeNode.isHighLighted()) {
                jLabel.setFont(jLabel.getFont().deriveFont(1));
                jLabel.setBackground(reconcileTreeNode.getHighLightBackground());
            } else if (reconcileTreeNode.isShuttled()) {
                jLabel.setBackground(reconcileTreeNode.getShuttledBackground());
            } else if (reconcileTreeNode.isChildShuttled()) {
                jLabel.setBackground(reconcileTreeNode.getShuttledBackground());
            }
            jLabel.setText(reconcileTreeNode.isShuttled() || reconcileTreeNode.isChildShuttled() ? reconcileTreeNode.getShuttledText() : reconcileTreeNode.getText());
        } else if (object instanceof DefaultMutableTreeNode && (object2 = ((DefaultMutableTreeNode)object).getUserObject()) instanceof String && this.m_iconify) {
            jLabel.setIcon(DBUtil.getFolderIcon((String)object2));
        }
        return jLabel;
    }
}

