/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.ui.reconcile;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.ide.util.ModelUtil;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.ResultSet;
import oracle.jdeveloper.cm.ds.db.DBUtil;
import oracle.jdeveloper.cm.dt.ui.reconcile.DependancySeeker;

public class DependancyManager {
    public static final String DEPENDANCY_DIRECTION_ADD = "add";
    public static final String DEPENDANCY_DIRECTION_REVERT = "revert";
    private DiffContext m_diffContext;
    private ResultSet m_root;
    private String m_dependency_direction;
    private HashMap m_dependancies;
    private HashMap m_seekers;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        $assertionsDisabled = DependancyManager.class.desiredAssertionStatus() ^ true;
    }

    void $init$() {
        this.m_dependancies = new HashMap();
        this.m_seekers = new HashMap();
    }

    public DependancyManager(DiffContext diffContext) {
        this.$init$();
        this.m_diffContext = diffContext;
        this.m_root = diffContext.getResult();
    }

    public void registerDependancySeeker(Class clazz, DependancySeeker dependancySeeker) {
        this.m_seekers.put(clazz, dependancySeeker);
    }

    public void analyseDependencies() {
        if (this.m_root != null) {
            this.walker(null, this.m_root);
        }
    }

    private Set getDependancies(ResultSet resultSet, String string) {
        Set set = (Set)this.m_dependancies.get(resultSet);
        HashSet<ResultSet> hashSet = new HashSet<ResultSet>();
        for (Dependancy dependancy : set) {
            if (ModelUtil.hasLength((String)string) && !Dependancy.mav$getDirection(dependancy).equals(string)) continue;
            hashSet.add(Dependancy.mav$getResultSet(dependancy));
        }
        return hashSet;
    }

    public Set getRevertDependancies(ResultSet resultSet) {
        return this.getDependancies(resultSet, DEPENDANCY_DIRECTION_ADD);
    }

    public Set getAddDependancies(ResultSet resultSet) {
        return this.getDependancies(resultSet, DEPENDANCY_DIRECTION_REVERT);
    }

    public Set getDependancies(ResultSet resultSet) {
        return this.getDependancies(resultSet, null);
    }

    public Set getResultSetsWithDependancies() {
        return this.m_dependancies.keySet();
    }

    public void setResultSet(ResultSet resultSet) {
        this.m_root = resultSet;
    }

    public ResultSet getResultSet() {
        return this.m_root;
    }

    public void print() {
        if (this.m_dependancies.size() > 0) {
            DBUtil.getLog().trace("Dependancies...");
        } else {
            DBUtil.getLog().trace("No dependancies.");
        }
        for (ResultSet resultSet : this.m_dependancies.keySet()) {
            resultSet.printOne();
            DBUtil.getLog().trace("Related to ...");
            DBUtil.getLog().trace("<<<");
            for (Dependancy dependancy : (Set)this.m_dependancies.get(resultSet)) {
                ResultSet resultSet2 = Dependancy.mav$getResultSet(dependancy);
                String string = Dependancy.mav$getDirection(dependancy);
                if (DEPENDANCY_DIRECTION_ADD.equals(string)) {
                    DBUtil.getLog().trace("ADD");
                } else if (DEPENDANCY_DIRECTION_REVERT.equals(string)) {
                    DBUtil.getLog().trace("REVERT");
                }
                resultSet2.printOne();
            }
            DBUtil.getLog().trace(">>>");
        }
    }

    private void walker(ResultSet resultSet, ResultSet resultSet2) {
        this.m_diffContext.getEngine().checkProgress();
        if (!resultSet2.isSame()) {
            Iterator<Object> iterator = null;
            if ("MAP".equals(resultSet2.getType()) || "LEAF".equals(resultSet2.getType())) {
                Class clazz = resultSet2.getResultSetClass();
                DependancySeeker dependancySeeker = (DependancySeeker)DiffEngine.searchMap((Map)this.m_seekers, (Class)clazz);
                if (dependancySeeker != null) {
                    this.updateDependancies(resultSet2, dependancySeeker.getDependancies(this.m_root, resultSet, resultSet2));
                }
                if ("MAP".equals(resultSet2.getType())) {
                    iterator = resultSet2.getNotSameObjectMap().values().iterator();
                }
            } else if ("LIST".equals(resultSet2.getType())) {
                iterator = resultSet2.getNotSameObjectList().iterator();
            }
            if (iterator != null) {
                while (iterator.hasNext()) {
                    this.walker(resultSet2, (ResultSet)iterator.next());
                }
            }
        }
    }

    private void updateDependancies(ResultSet resultSet, List list) {
        for (ResultSet resultSet2 : list) {
            if (!$assertionsDisabled && resultSet2 == null) {
                throw new AssertionError();
            }
            this.addDependancy(resultSet2, resultSet, DEPENDANCY_DIRECTION_ADD);
            this.addDependancy(resultSet, resultSet2, DEPENDANCY_DIRECTION_REVERT);
        }
    }

    private void addDependancy(ResultSet resultSet, ResultSet resultSet2, String string) {
        HashSet<Dependancy> hashSet = (HashSet<Dependancy>)this.m_dependancies.get(resultSet);
        Dependancy dependancy = new Dependancy(resultSet2, string);
        if (hashSet == null) {
            hashSet = new HashSet<Dependancy>();
            hashSet.add(dependancy);
            this.m_dependancies.put(resultSet, hashSet);
        } else {
            hashSet.add(dependancy);
        }
    }

    private class Dependancy {
        ResultSet m_resultSet;
        String m_direction;

        Dependancy(ResultSet resultSet, String string) {
            this.m_resultSet = resultSet;
            this.m_direction = string;
        }

        private ResultSet getResultSet() {
            return this.m_resultSet;
        }

        private String getDirection() {
            return this.m_direction;
        }

        static ResultSet mav$getResultSet(Dependancy dependancy) {
            return dependancy.getResultSet();
        }

        static String mav$getDirection(Dependancy dependancy) {
            return dependancy.getDirection();
        }
    }
}

