/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.ui.reconcile;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.util.ModelUtil;
import oracle.javatools.db.diff.ResultSet;
import oracle.jdeveloper.cm.dt.ui.AbstractTreePicker;
import oracle.jdeveloper.cm.dt.ui.reconcile.CompareTreeCellRenderer;
import oracle.jdeveloper.cm.dt.ui.reconcile.DependancyManager;
import oracle.jdeveloper.cm.dt.ui.reconcile.ReconcileTreeModel;
import oracle.jdeveloper.cm.dt.ui.reconcile.ReconcileTreeNode;

public class ReconcilePicker
extends AbstractTreePicker {
    private CompareTreeCellRenderer m_renderer;
    private DefaultMutableTreeNode m_top;
    private ReconcileTreeModel m_treeModel;
    private JTree m_rptree;
    private Transferable[] m_all;
    private Map m_nodes;
    static DataFlavor TRANSFERABLE_FLAVOR = new DataFlavor(ResultSetTransferable.class, "ResultSet");

    void $init$() {
        this.m_renderer = new CompareTreeCellRenderer();
        this.m_nodes = new HashMap();
    }

    public ReconcilePicker() {
        this.$init$();
        this.m_top = new DefaultMutableTreeNode("XXXXXX");
        this.m_treeModel = new ReconcileTreeModel(this.m_top);
        this.m_rptree = new JTree(this.m_treeModel);
        this.setTree(this.m_rptree);
        this.m_rptree.setRootVisible(false);
        this.m_rptree.setCellRenderer(this.m_renderer);
        this.m_rptree.setShowsRootHandles(true);
        this.m_rptree.setScrollsOnExpand(true);
        this.m_rptree.getSelectionModel().setSelectionMode(4);
    }

    public DefaultTreeModel getTreeModel() {
        return this.m_treeModel;
    }

    public JTree getJTree() {
        return this.m_rptree;
    }

    public ReconcileTreeNode[] getTopTreeNodes() {
        ReconcileTreeNode[] reconcileTreeNodeArray = null;
        if (this.m_top != null) {
            reconcileTreeNodeArray = new ReconcileTreeNode[this.m_top.getChildCount()];
            int n = 0;
            while (n < reconcileTreeNodeArray.length) {
                reconcileTreeNodeArray[n] = (ReconcileTreeNode)this.m_top.getChildAt(n);
                ++n;
            }
        }
        return reconcileTreeNodeArray;
    }

    protected void buildTree(boolean bl, DependancyManager dependancyManager) {
        ResultSet resultSet = dependancyManager.getResultSet();
        this.buildTree(bl, resultSet, this.m_top);
        this.m_treeModel.reload();
    }

    private void mapNode(ResultSet resultSet, DefaultMutableTreeNode defaultMutableTreeNode) {
        this.m_nodes.put(resultSet, defaultMutableTreeNode);
    }

    private DefaultMutableTreeNode buildTree(boolean bl, ResultSet resultSet, DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        if ("LIST".equals(resultSet.getType())) {
            String string = resultSet.getName();
            if (ModelUtil.hasLength((String)string)) {
                defaultMutableTreeNode2 = new ReconcileTreeNode(bl, resultSet);
                this.mapNode(resultSet, defaultMutableTreeNode2);
                if (defaultMutableTreeNode != null) {
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                }
            } else {
                defaultMutableTreeNode2 = defaultMutableTreeNode;
            }
            List list = resultSet.getAllObjectsList();
            for (ResultSet resultSet2 : list) {
                if (!resultSet2.isDisplay()) continue;
                DefaultMutableTreeNode defaultMutableTreeNode3 = this.buildTree(bl, resultSet2, defaultMutableTreeNode2);
                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            }
        } else if ("MAP".equals(resultSet.getType())) {
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof ResultSet && "MAP".equals(((ResultSet)object).getType())) {
                defaultMutableTreeNode2 = defaultMutableTreeNode;
            } else {
                defaultMutableTreeNode2 = new ReconcileTreeNode(bl, resultSet);
                this.mapNode(resultSet, defaultMutableTreeNode2);
                if (defaultMutableTreeNode != null) {
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                }
            }
            Map map = resultSet.getAllObjectsMap();
            List<Object> list = new ArrayList(map.keySet());
            if (defaultMutableTreeNode2 instanceof ReconcileTreeNode) {
                list = ((ReconcileTreeNode)defaultMutableTreeNode2).orderChildren(resultSet, list);
            }
            for (String string : list) {
                ResultSet resultSet3 = (ResultSet)map.get(string);
                if (!resultSet3.isDisplay()) continue;
                this.buildTree(bl, resultSet3, defaultMutableTreeNode2);
            }
        } else {
            defaultMutableTreeNode2 = new ReconcileTreeNode(bl, resultSet);
            this.mapNode(resultSet, defaultMutableTreeNode2);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        return defaultMutableTreeNode2;
    }

    public ReconcileTreeNode getReconcileTreeNode(ResultSet resultSet) {
        return (ReconcileTreeNode)this.m_nodes.get(resultSet);
    }

    public Transferable[] getAllSelectableItems() {
        if (this.m_all == null) {
            ArrayList arrayList = new ArrayList();
            Enumeration<TreeNode> enumeration = this.m_top.children();
            while (enumeration.hasMoreElements()) {
                ReconcileTreeNode reconcileTreeNode = (ReconcileTreeNode)enumeration.nextElement();
                this.addAllSelectableItems(arrayList, reconcileTreeNode);
            }
            this.m_all = arrayList.toArray(new Transferable[arrayList.size()]);
        }
        return this.m_all;
    }

    private void addAllSelectableItems(List list, ReconcileTreeNode reconcileTreeNode) {
        ResultSet resultSet = reconcileTreeNode.getResultSet();
        if (!resultSet.isSame()) {
            list.add(new ResultSetTransferable(resultSet));
            Iterator iterator = reconcileTreeNode.getAllChildren().iterator();
            while (iterator.hasNext()) {
                this.addAllSelectableItems(list, (ReconcileTreeNode)iterator.next());
            }
        }
    }

    public boolean addSelectedItems(Transferable[] transferableArray) {
        return true;
    }

    public void removeSelectedItems() {
    }

    public void removeAllSelectableItems() {
    }

    public Transferable createTransferable(TreePath treePath) {
        ReconcileTreeNode reconcileTreeNode = (ReconcileTreeNode)treePath.getLastPathComponent();
        ResultSetTransferable resultSetTransferable = new ResultSetTransferable(reconcileTreeNode.getResultSet());
        this.m_nodes.put(resultSetTransferable, reconcileTreeNode);
        return resultSetTransferable;
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.m_rptree.addTreeSelectionListener(treeSelectionListener);
    }

    public void addTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.m_rptree.addTreeExpansionListener(treeExpansionListener);
    }

    private boolean isSelectableChildPresent(ReconcileTreeNode reconcileTreeNode) {
        boolean bl;
        boolean bl2 = bl = !reconcileTreeNode.getResultSet().isSame() && !reconcileTreeNode.isShuttled();
        if (!bl && reconcileTreeNode.getChildCount() > 0) {
            int n = reconcileTreeNode.getChildCount() - 1;
            while (n >= 0) {
                bl = this.isSelectableChildPresent((ReconcileTreeNode)reconcileTreeNode.getChildAt(n));
                if (bl) break;
                --n;
            }
        }
        return bl;
    }

    public boolean isSelectableItemPresent() {
        boolean bl = super.isSelectableItemPresent();
        int n = 0;
        while (n < this.m_top.getChildCount()) {
            TreeNode treeNode = this.m_top.getChildAt(n);
            ReconcileTreeNode reconcileTreeNode = (ReconcileTreeNode)treeNode;
            bl = reconcileTreeNode.isFrom() ? this.isSelectableChildPresent(reconcileTreeNode) : reconcileTreeNode.isChildShuttled();
            if (bl) break;
            ++n;
        }
        return bl;
    }

    public boolean isItemSelected() {
        boolean bl = super.isItemSelected();
        if (bl) {
            bl = false;
            TreePath[] treePathArray = this.m_rptree.getSelectionPaths();
            int n = 0;
            while (treePathArray != null && n < treePathArray.length) {
                ReconcileTreeNode reconcileTreeNode = (ReconcileTreeNode)treePathArray[n].getLastPathComponent();
                if (reconcileTreeNode.isHighLighted()) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    public class ResultSetTransferable
    implements Transferable {
        private ResultSet m_rs;

        ResultSetTransferable(ResultSet resultSet) {
            this.m_rs = resultSet;
        }

        public ResultSet getResultSet() {
            return this.m_rs;
        }

        public Object getTransferData(DataFlavor dataFlavor) {
            return this.m_rs;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{TRANSFERABLE_FLAVOR};
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return dataFlavor == TRANSFERABLE_FLAVOR;
        }
    }
}

