/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.ui.reconcile;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import oracle.bali.share.nls.StringUtils;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.jdeveloper.cm.ds.db.DBUtil;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class ReconcileTreeNode
extends DefaultMutableTreeNode {
    private static Comparator s_changeNodeComparator = new ReconcileNodeComparator(null);
    private boolean m_from;
    private boolean m_highLighted;
    private boolean m_shuttled;
    private boolean m_childShuttled;
    private Set m_dependantChanges;
    private DBObject m_dbObject;
    private ReconcileTreeNode m_partner;
    private Object m_parent;
    private DefaultMutableTreeNode m_defaultMutableTreeNode;
    private Icon m_icon;
    private Icon m_shuttledIcon;
    private String m_text;
    private String m_shuttledText;
    private Color m_background;
    private Color m_shuttledBackground;
    private Color m_highLightBackground;
    private static final Color BACKGROUND = Color.WHITE;
    private static HighlightRegistry highlightRegistry = EditorProperties.getProperties().getHighlightRegistry();
    private static Class ehl = null;
    private static HashMap s_nameMap;
    private static String[] s_onDelete;
    private static HashMap s_intDecode;
    private static String[] s_order;

    static {
        try {
            ehl = Class.forName("oracle.javatools.compare.view.wedge.EditorHighlighter");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        s_nameMap = new HashMap();
        s_nameMap.put("indexes", CmWizardsArb.getString(458));
        s_nameMap.put("constraints", CmWizardsArb.getString(459));
        s_nameMap.put("TableType", CmWizardsArb.getString(460));
        s_nameMap.put("columns", CmWizardsArb.getString(461));
        s_nameMap.put("name", CmWizardsArb.getString(462));
        s_nameMap.put("schema", CmWizardsArb.getString(463));
        s_nameMap.put("notNull", CmWizardsArb.getString(464));
        s_nameMap.put("dataTypeUsage", CmWizardsArb.getString(465));
        s_nameMap.put("scale", CmWizardsArb.getString(466));
        s_nameMap.put("precision", CmWizardsArb.getString(467));
        s_nameMap.put("dataTypeID", CmWizardsArb.getString(468));
        s_nameMap.put("default", CmWizardsArb.getString(469));
        s_nameMap.put("comment", CmWizardsArb.getString(470));
        s_nameMap.put("deleteMode", CmWizardsArb.getString(471));
        s_nameMap.put("ReferencedSchema", CmWizardsArb.getString(475));
        s_nameMap.put("enabled", CmWizardsArb.getString(476));
        s_nameMap.put("ReferencedRelation", CmWizardsArb.getString(477));
        s_nameMap.put("ReferencedColumn", CmWizardsArb.getString(478));
        s_nameMap.put("ReferencedConstraintName", CmWizardsArb.getString(479));
        s_onDelete = new String[]{CmWizardsArb.getString(472), CmWizardsArb.getString(473), CmWizardsArb.getString(474)};
        s_intDecode = new HashMap();
        s_intDecode.put("deleteMode", s_onDelete);
        s_order = new String[]{"schema", "name", "TableType", "columns", "constraints", "indexes", "dataTypeUsage", "default", "notNull", "comment", "enabled", "deleteMode", "ReferencedSchema", "ReferencedRelation", "ReferencedConstraintName", "ReferencedColumn"};
    }

    void $init$() {
        this.m_highLighted = false;
        this.m_shuttled = false;
        this.m_childShuttled = false;
        this.m_dependantChanges = new HashSet();
    }

    public ReconcileTreeNode(boolean bl, ResultSet resultSet) {
        super(resultSet);
        this.$init$();
        this.m_from = bl;
        this.m_shuttled = false;
        Object object = resultSet.a();
        if (bl) {
            object = resultSet.b();
        }
        if ("MAP".equals(resultSet.getType()) && object instanceof DBObject) {
            this.m_dbObject = (DBObject)object;
        }
        this.setIcon();
        this.setText();
        this.setColor();
    }

    public List orderChildren(ResultSet resultSet, List list) {
        ArrayList arrayList = new ArrayList(list);
        ArrayList arrayList2 = new ArrayList();
        DataTypeUsage dataTypeUsage = null;
        Iterator<String> iterator = Arrays.asList(s_order).iterator();
        Object object = resultSet.getResultSetObject();
        if (object instanceof DataTypeUsage && (dataTypeUsage = (DataTypeUsage)resultSet.a()) != null) {
            ArrayList arrayList3 = new ArrayList(dataTypeUsage.getAttributeValues().keySet());
            arrayList3.add(0, "Datatype");
            iterator = arrayList3.iterator();
        }
        while (iterator.hasNext()) {
            String string = iterator.next();
            int n = arrayList.indexOf(string);
            while (n > 0) {
                arrayList2.add(arrayList.remove(n));
                n = arrayList.indexOf(string);
            }
        }
        arrayList2.addAll(arrayList);
        return arrayList2;
    }

    public boolean isLeaf() {
        return "LEAF".equals(this.getResultSet().getType());
    }

    public boolean isAdd() {
        ResultSet resultSet = this.getResultSet();
        return resultSet != null && !resultSet.isSame() && this.getResultSet().a() == null && this.getResultSet().b() != null;
    }

    public boolean isDrop() {
        ResultSet resultSet = this.getResultSet();
        return resultSet != null && !resultSet.isSame() && this.getResultSet().a() != null && this.getResultSet().b() == null;
    }

    public boolean isChange() {
        ResultSet resultSet = this.getResultSet();
        return resultSet != null && !resultSet.isSame() && this.getResultSet().a() != null && this.getResultSet().b() != null;
    }

    private String decode(String string, String string2) {
        int n;
        String[] stringArray;
        String string3 = string2;
        if (string2 != null && (stringArray = (String[])s_intDecode.get(string)) != null && (n = Integer.parseInt(string2)) < stringArray.length) {
            string3 = stringArray[n];
        }
        return string3;
    }

    private void setText() {
        String string;
        ResultSet resultSet;
        boolean bl;
        block26: {
            bl = false;
            resultSet = this.getResultSet();
            string = resultSet.getName();
            Object object = resultSet.getResultSetObject();
            if (string != "Datatype" && object instanceof DataTypeUsage) {
                try {
                    DataType dataType;
                    DataTypeAttribute dataTypeAttribute;
                    DataTypeUsage dataTypeUsage = (DataTypeUsage)object;
                    if (resultSet.a() != null) {
                        dataTypeUsage = (DataTypeUsage)resultSet.a();
                    }
                    if ((dataTypeAttribute = (dataType = DataTypeHelper.getDataType((DataTypeUsage)dataTypeUsage)).getDataTypeAttribute(string)) == null && resultSet.b() != null) {
                        dataTypeUsage = (DataTypeUsage)resultSet.b();
                        dataType = DataTypeHelper.getDataType((DataTypeUsage)dataTypeUsage);
                        dataTypeAttribute = dataType.getDataTypeAttribute(string);
                    }
                    if (dataTypeAttribute != null) {
                        string = dataTypeAttribute.getLabel();
                        string = StringUtils.stripMnemonic((String)string);
                        break block26;
                    }
                    string = "";
                }
                catch (DBException dBException) {}
            } else if (s_nameMap.containsKey(string)) {
                string = (String)s_nameMap.get(string);
                bl = true;
            }
        }
        this.m_text = this.isLeaf() ? CmWizardsArb.format(457, string, this.decode(resultSet.getName(), this.isFrom() ? resultSet.getBVal() : resultSet.getAVal())) : (!bl && this.m_dbObject instanceof FKConstraint && DBUtil.isDangling((DBObjectID)((FKConstraint)this.m_dbObject).getReferenceID()) ? CmWizardsArb.format(456, string) : CmWizardsArb.format(455, string));
        if (this.isFrom()) {
            if (this.isAdd()) {
                this.m_text = this.isLeaf() ? CmWizardsArb.format(438, string, this.decode(resultSet.getName(), resultSet.getBVal())) : CmWizardsArb.format(437, string);
            } else if (this.isDrop()) {
                this.m_text = this.isLeaf() ? CmWizardsArb.format(442, string) : CmWizardsArb.format(441, string);
            } else if (this.isChange()) {
                this.m_text = this.isLeaf() ? CmWizardsArb.format(440, string, this.decode(resultSet.getName(), resultSet.getBVal())) : CmWizardsArb.format(439, string);
            }
            this.m_shuttledText = this.m_text;
        } else if (this.isAdd()) {
            if (this.isLeaf()) {
                this.m_text = CmWizardsArb.format(444, string);
                this.m_shuttledText = CmWizardsArb.format(453, string, this.decode(resultSet.getName(), resultSet.getBVal()));
            } else {
                this.m_text = CmWizardsArb.getString(443);
                this.m_shuttledText = CmWizardsArb.format(449, string);
            }
        } else if (this.isDrop()) {
            if (this.isLeaf()) {
                this.m_text = CmWizardsArb.format(448, string, this.decode(resultSet.getName(), resultSet.getAVal()));
                this.m_shuttledText = CmWizardsArb.format(454, string, this.decode(resultSet.getName(), resultSet.getBVal()));
            } else {
                this.m_text = CmWizardsArb.format(447, string);
                this.m_shuttledText = CmWizardsArb.format(451, this.decode(resultSet.getName(), string));
            }
        } else if (this.isChange()) {
            if (this.isLeaf()) {
                this.m_text = CmWizardsArb.format(446, string, resultSet.getAVal());
                this.m_shuttledText = CmWizardsArb.format(452, string, this.decode(resultSet.getName(), resultSet.getAVal()), this.decode(resultSet.getName(), resultSet.getBVal()));
            } else {
                this.m_text = CmWizardsArb.format(445, string);
                this.m_shuttledText = CmWizardsArb.format(450, string);
            }
        }
    }

    private void setColor() {
        block7: {
            block8: {
                block6: {
                    if (!this.isAdd()) break block6;
                    HighlightStyle highlightStyle = highlightRegistry.lookupStyle("compare-addition");
                    this.m_highLightBackground = highlightStyle.getBackgroundColor().darker();
                    if (this.isFrom()) {
                        this.m_background = highlightStyle.getBackgroundColor();
                        this.m_shuttledBackground = BACKGROUND;
                    } else {
                        this.m_background = BACKGROUND;
                        this.m_shuttledBackground = highlightStyle.getBackgroundColor();
                    }
                    break block7;
                }
                if (!this.isDrop()) break block8;
                HighlightStyle highlightStyle = highlightRegistry.lookupStyle("compare-deletion");
                this.m_highLightBackground = highlightStyle.getBackgroundColor().darker();
                if (this.isFrom()) {
                    this.m_background = highlightStyle.getBackgroundColor();
                    this.m_shuttledBackground = BACKGROUND;
                } else {
                    this.m_background = BACKGROUND;
                    this.m_shuttledBackground = highlightStyle.getBackgroundColor();
                }
                break block7;
            }
            if (!this.isChange()) break block7;
            HighlightStyle highlightStyle = highlightRegistry.lookupStyle("compare-update");
            this.m_highLightBackground = highlightStyle.getBackgroundColor().darker();
            if (this.isFrom()) {
                this.m_background = highlightStyle.getBackgroundColor();
                this.m_shuttledBackground = BACKGROUND;
            } else {
                this.m_background = BACKGROUND;
                this.m_shuttledBackground = highlightStyle.getBackgroundColor();
            }
        }
    }

    private void setIcon() {
        ResultSet resultSet = this.getResultSet();
        this.m_icon = null;
        this.m_shuttledIcon = null;
        if ("MAP".equals(resultSet.getType())) {
            DBObject dBObject = null;
            if (resultSet.a() instanceof DBObject) {
                dBObject = (DBObject)resultSet.a();
            }
            DBObject dBObject2 = null;
            if (resultSet.b() instanceof DBObject) {
                dBObject2 = (DBObject)resultSet.b();
            }
            if (this.isFrom() && dBObject2 != null) {
                this.m_shuttledIcon = this.m_icon = DBUtil.getNodeIcon(dBObject2.getType());
            } else if (this.isTo()) {
                if (dBObject != null) {
                    this.m_icon = DBUtil.getNodeIcon(dBObject.getType());
                }
                if (dBObject2 != null) {
                    this.m_shuttledIcon = DBUtil.getNodeIcon(dBObject2.getType());
                }
            }
        }
    }

    public Icon getIcon() {
        return this.m_icon;
    }

    public Icon getShuttledIcon() {
        return this.m_shuttledIcon;
    }

    public String getShuttledText() {
        return this.m_shuttledText;
    }

    public String getText() {
        return this.m_text;
    }

    public Color getHighLightBackground() {
        return this.m_highLightBackground;
    }

    public Color getShuttledBackground() {
        return this.m_shuttledBackground;
    }

    public Color getBackground() {
        return this.m_background;
    }

    public void setPartner(ReconcileTreeNode reconcileTreeNode) {
        this.m_partner = reconcileTreeNode;
    }

    public ReconcileTreeNode getPartner() {
        return this.m_partner;
    }

    public DBObject getDBObject() {
        return this.m_dbObject;
    }

    public boolean isFrom() {
        return this.m_from;
    }

    public boolean isTo() {
        return this.m_from ^ true;
    }

    public ResultSet getResultSet() {
        return (ResultSet)this.getUserObject();
    }

    private Set getAttributes() {
        TreeSet<ReconcileTreeNode> treeSet = new TreeSet<ReconcileTreeNode>(s_changeNodeComparator);
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            ReconcileTreeNode reconcileTreeNode = (ReconcileTreeNode)enumeration.nextElement();
            ResultSet resultSet = (ResultSet)reconcileTreeNode.getUserObject();
            if (!"LEAF".equals(resultSet.getType())) continue;
            treeSet.add(reconcileTreeNode);
        }
        return treeSet;
    }

    public Collection getAllChildren() {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList;
    }

    private Set getChildLists() {
        TreeSet<ReconcileTreeNode> treeSet = new TreeSet<ReconcileTreeNode>(s_changeNodeComparator);
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            ReconcileTreeNode reconcileTreeNode = (ReconcileTreeNode)enumeration.nextElement();
            ResultSet resultSet = (ResultSet)reconcileTreeNode.getUserObject();
            if (!"LIST".equals(resultSet.getType())) continue;
            treeSet.add(reconcileTreeNode);
        }
        return treeSet;
    }

    private Set getChildren() {
        TreeSet<ReconcileTreeNode> treeSet = new TreeSet<ReconcileTreeNode>(s_changeNodeComparator);
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            ReconcileTreeNode reconcileTreeNode = (ReconcileTreeNode)enumeration.nextElement();
            ResultSet resultSet = reconcileTreeNode.getResultSet();
            if (!"MAP".equals(resultSet.getType())) continue;
            treeSet.add(reconcileTreeNode);
        }
        return treeSet;
    }

    public boolean isShuttled() {
        boolean bl = false;
        if (this.m_from) {
            if (this.m_partner != null) {
                bl = this.m_partner.isShuttled();
            }
        } else {
            bl = this.m_shuttled;
        }
        return bl;
    }

    public boolean isChildShuttled() {
        return this.m_childShuttled;
    }

    public boolean updateChildShuttled() {
        boolean bl = this.isShuttled();
        if (!bl) {
            Collection collection = this.getAllChildren();
            boolean bl2 = collection.size() > 0;
            boolean bl3 = true;
            for (ReconcileTreeNode reconcileTreeNode : collection) {
                ResultSet resultSet = reconcileTreeNode.getResultSet();
                if (resultSet.isSame()) continue;
                bl |= reconcileTreeNode.updateChildShuttled();
                bl2 &= reconcileTreeNode.isShuttled();
                bl3 &= reconcileTreeNode.isShuttled() ^ true;
            }
            this.m_childShuttled = bl;
            if (bl2) {
                // empty if block
            }
            if (bl3) {
                // empty if block
            }
        }
        this.m_childShuttled = bl;
        return bl;
    }

    public void setShuttled(DefaultTreeModel defaultTreeModel, DefaultTreeModel defaultTreeModel2, boolean bl) {
        if (this.m_from) {
            this.m_partner.setShuttled(defaultTreeModel, defaultTreeModel2, bl);
        } else {
            this.m_shuttled = bl;
        }
        for (ReconcileTreeNode reconcileTreeNode : this.getAllChildren()) {
            ResultSet resultSet = reconcileTreeNode.getResultSet();
            if (resultSet.isSame()) continue;
            reconcileTreeNode.setShuttled(defaultTreeModel, defaultTreeModel2, bl);
        }
        ReconcileTreeNode reconcileTreeNode = bl ? this.getPartner() : this;
        for (ReconcileTreeNode reconcileTreeNode2 : reconcileTreeNode.getDependantChanges()) {
            ResultSet resultSet = reconcileTreeNode2.getResultSet();
            if (resultSet.isSame() || reconcileTreeNode2.isShuttled() == bl) continue;
            reconcileTreeNode2.setShuttled(defaultTreeModel, defaultTreeModel2, bl);
        }
        this.nodeChanged(defaultTreeModel, defaultTreeModel2);
    }

    private void nodeChanged(DefaultTreeModel defaultTreeModel, DefaultTreeModel defaultTreeModel2) {
        if (this.m_from) {
            defaultTreeModel.nodeChanged(this);
        } else {
            defaultTreeModel2.nodeChanged(this);
        }
    }

    public boolean isHighLighted() {
        return this.m_highLighted;
    }

    private boolean isSuitableToHighLight() {
        boolean bl = false;
        if (!this.getResultSet().isSame()) {
            bl = this.isFrom() ? this.isShuttled() ^ true : this.isShuttled();
        }
        return bl;
    }

    public void setHighLighted(DefaultTreeModel defaultTreeModel, DefaultTreeModel defaultTreeModel2, boolean bl) {
        if (this.m_highLighted != (bl &= this.isSuitableToHighLight())) {
            this.m_highLighted = bl;
            Enumeration<TreeNode> enumeration = this.children();
            while (enumeration.hasMoreElements()) {
                ReconcileTreeNode reconcileTreeNode = (ReconcileTreeNode)enumeration.nextElement();
                reconcileTreeNode.setHighLighted(defaultTreeModel, defaultTreeModel2, bl);
            }
            this.nodeChanged(defaultTreeModel, defaultTreeModel2);
        }
    }

    public Set getDependantChanges() {
        return this.m_dependantChanges;
    }

    public void addDependantChange(ReconcileTreeNode reconcileTreeNode) {
        this.m_dependantChanges.add(reconcileTreeNode);
    }

    public void setDependantsHighLighted(DefaultTreeModel defaultTreeModel, DefaultTreeModel defaultTreeModel2, boolean bl) {
        if (this.m_highLighted != (bl &= this.isSuitableToHighLight())) {
            this.setHighLighted(defaultTreeModel, defaultTreeModel2, bl);
            for (ReconcileTreeNode reconcileTreeNode : this.getDependantChanges()) {
                reconcileTreeNode.setDependantsHighLighted(defaultTreeModel, defaultTreeModel2, bl);
            }
        }
    }

    public String toString() {
        String string = "";
        if (this.m_dbObject != null) {
            string = this.m_dbObject.getName();
        }
        return string;
    }

    private static class ReconcileNodeComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            String string = ((ReconcileTreeNode)object).getResultSet().getName();
            String string2 = ((ReconcileTreeNode)object2).getResultSet().getName();
            return string.compareTo(string2);
        }

        private ReconcileNodeComparator() {
        }

        ReconcileNodeComparator(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

