/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.ui.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.controls.DescriptionScrollPane;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.sql.NonDeclarativeSQLQuery;
import oracle.javatools.db.sql.SQLParseException;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.cm.dt.ui.ExpressionEditSupport;
import oracle.jdeveloper.cm.dt.ui.sql.BaseSQLQueryBuilderPanel;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class QueryPanel
extends BaseSQLQueryBuilderPanel
implements DocumentListener,
ActionListener {
    private JWrappedLabel m_desc;
    private JLabel m_queryLabel;
    private JTextArea m_query;
    private ExpressionEditSupport m_undo;
    private boolean m_commitPending;
    private boolean m_invalidChangeCommitted;
    private JButton m_test;
    private JButton m_revert;
    private JLabel m_feedbackLabel;
    private DescriptionScrollPane m_feedback;
    private String m_originalText;
    private SQLQueryBuilder m_builder;

    void $init$() {
        this.m_desc = new JWrappedLabel(CmWizardsArb.getString(347));
        this.m_queryLabel = new JLabel();
        this.m_query = new JTextArea();
        this.m_undo = new ExpressionEditSupport(this.m_query);
        this.m_test = new JButton();
        this.m_revert = new JButton();
        this.m_feedbackLabel = new JLabel();
        this.m_feedback = new DescriptionScrollPane();
    }

    public QueryPanel() {
        this.$init$();
        try {
            this.layoutComponents();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected boolean invalidWithoutBuilder() {
        return false;
    }

    protected void layoutComponents() {
        this.setLayout(new BorderLayout(0, 15));
        this.add((Component)this.m_desc, "North");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        ResourceUtils.resLabel((JLabel)this.m_queryLabel, (Component)this.m_query, (String)CmWizardsArb.getString(348));
        jPanel.add((Component)this.m_queryLabel, new GridBagConstraints(1, 0, 3, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.m_query.setLineWrap(true);
        this.m_query.setWrapStyleWord(true);
        jPanel.add((Component)new JScrollPane(this.m_query, 20, 31), new GridBagConstraints(1, 1, 3, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 5, 0), 0, 0));
        ResourceUtils.resButton((AbstractButton)this.m_revert, (String)CmWizardsArb.getString(350));
        this.m_revert.addActionListener(this);
        jPanel.add((Component)this.m_revert, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 5), 0, 0));
        ResourceUtils.resButton((AbstractButton)this.m_test, (String)CmWizardsArb.getString(351));
        this.m_test.addActionListener(this);
        jPanel.add((Component)this.m_test, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0));
        ResourceUtils.resLabel((JLabel)this.m_feedbackLabel, (Component)this.m_feedback.getLabelComponent(), (String)CmWizardsArb.getString(349));
        this.m_feedback.setBorder(null);
        this.m_feedback.setColumnHeaderView((Component)this.m_feedbackLabel);
        jPanel.add((Component)this.m_feedback, new GridBagConstraints(1, 2, 1, 2, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add(Box.createVerticalGlue(), new GridBagConstraints(2, 3, 1, 1, 0.0, 0.5, 12, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(jPanel, "Center");
    }

    protected void init(SQLQueryBuilder sQLQueryBuilder, DBObject dBObject) {
        SQLQuery sQLQuery = null;
        Object object = this.m_namespace.get("NewObject");
        if (object instanceof SQLQuery) {
            sQLQuery = (SQLQuery)object;
        } else if (object instanceof SQLQueryOwner) {
            sQLQuery = ((SQLQueryOwner)object).getSQLQuery();
        }
        if (sQLQuery != null) {
            this.m_originalText = sQLQuery.getSQLText().trim();
            this.initQuery();
        }
        this.m_invalidChangeCommitted = false;
    }

    private void initQuery() {
        this.m_query.setText(this.m_originalText);
        this.m_query.getDocument().addDocumentListener(this);
        this.m_commitPending = this.m_invalidChangeCommitted;
        this.m_revert.setEnabled(false);
        this.m_test.setEnabled(false);
        this.setFeedback(null);
        this.validate();
    }

    private void setFeedback(String string) {
        this.m_feedback.setText(string);
        this.m_feedback.getAccessibleContext().setAccessibleName(this.m_feedbackLabel.getText());
        this.m_feedback.getAccessibleContext().setAccessibleDescription(string);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (this.m_commitPending) {
            String string = this.m_query.getText().trim();
            if (this.m_invalidChangeCommitted || ModelUtil.areDifferent((Object)string, (Object)this.m_originalText)) {
                this.m_invalidChangeCommitted = false;
                Object object = this.m_namespace.get("NewObject");
                try {
                    SQLQueryBuilder sQLQueryBuilder = SQLQueryBuilderFactory.createBuilder((DBObjectProvider)this.m_pro, (Schema)this.m_defaultSchema, (String)string);
                    traversableContext.put("SQLQueryBuilder", (Object)sQLQueryBuilder);
                    if (object instanceof SQLQueryOwner) {
                        ((SQLQueryOwner)object).setSQLQuery((SQLQuery)new NonDeclarativeSQLQuery(string));
                    } else {
                        traversableContext.put("NewObject", (Object)sQLQueryBuilder.getSQLQuery());
                    }
                }
                catch (SQLParseException sQLParseException) {
                    throw new TraversalException(sQLParseException.getMessage());
                }
                catch (SQLQueryException sQLQueryException) {
                    NonDeclarativeSQLQuery nonDeclarativeSQLQuery = new NonDeclarativeSQLQuery(string);
                    if (object instanceof SQLQueryOwner) {
                        ((SQLQueryOwner)object).setSQLQuery((SQLQuery)nonDeclarativeSQLQuery);
                        if (object instanceof Relation) {
                            ((Relation)object).setColumns(null);
                        }
                    } else {
                        traversableContext.put("NewObject", (Object)nonDeclarativeSQLQuery);
                    }
                    traversableContext.put("SQLQueryBuilder", null);
                    this.m_invalidChangeCommitted = true;
                }
                catch (Exception exception) {
                    throw new TraversalException("An error has occured " + exception.getMessage());
                }
            }
        }
    }

    private void queryEdited() {
        this.m_commitPending = true;
        this.m_revert.setEnabled(true);
        this.m_test.setEnabled(true);
        this.m_query.getDocument().removeDocumentListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_test) {
            try {
                SQLQueryBuilderFactory.createBuilder((DBObjectProvider)this.m_pro, (Schema)this.m_defaultSchema, (String)this.m_query.getText().trim());
                this.setFeedback(CmWizardsArb.getString(352));
            }
            catch (SQLParseException sQLParseException) {
                this.setFeedback(sQLParseException.getMessage());
            }
            catch (SQLQueryException sQLQueryException) {
                FastStringBuffer fastStringBuffer = new FastStringBuffer();
                fastStringBuffer.append(CmWizardsArb.getString(353));
                fastStringBuffer.append("\n\n").append(sQLQueryException.getMessage());
                this.setFeedback(fastStringBuffer.toString());
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)((Object)this), (Throwable)exception);
            }
            this.validate();
            this.m_feedback.getLabelComponent().requestFocusInWindow();
        } else if (object == this.m_revert) {
            this.initQuery();
            this.m_query.requestFocusInWindow();
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.queryEdited();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.queryEdited();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.queryEdited();
    }
}

