/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.ui.sql;

import java.awt.Component;
import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.View;
import oracle.jdeveloper.cm.dt.ui.DBObjectRenderer;
import oracle.jdeveloper.cm.dt.ui.DBObjectSourcePicker;
import oracle.jdeveloper.cm.dt.ui.DBObjectTransferable;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class QuickPickSourcePicker
extends DBObjectSourcePicker {
    private View m_view;

    public QuickPickSourcePicker(DBObjectProvider dBObjectProvider, boolean bl, boolean bl2) {
        super(dBObjectProvider, bl, bl2);
        this.m_dbRenderer = new Renderer(null);
        this.m_dbRenderer.setIncludeIcon(true);
        this.m_tree.setCellRenderer(this.m_dbRenderer);
        this.m_nodeMaker.setDeepFKs(true);
        this.m_nodeMaker.setChildTypes(new String[]{"COLUMN", "FKConstraint"});
        ToolTipManager.sharedInstance().registerComponent(this.m_tree);
    }

    public void removeSelectedItems() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        TreePath[] treePathArray = this.m_tree.getSelectionPaths();
        if (treePathArray != null && treePathArray.length == 1 && (defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[0].getLastPathComponent()).getUserObject() instanceof Relation) {
            this.m_tree.expandPath(treePathArray[0]);
        }
        super.removeSelectedItems();
    }

    public void setView(View view) {
        this.m_view = view;
    }

    protected SchemaObject[] filterAndSort(SchemaObject[] schemaObjectArray) {
        if (this.m_view != null && schemaObjectArray != null) {
            int n = -1;
            int n2 = 0;
            while (n2 < schemaObjectArray.length) {
                if (schemaObjectArray[n2] instanceof View && schemaObjectArray[n2].getName().equals(this.m_view.getName())) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            if (n >= 0) {
                SchemaObject[] schemaObjectArray2 = new SchemaObject[schemaObjectArray.length - 1];
                System.arraycopy(schemaObjectArray, 0, schemaObjectArray2, 0, n);
                System.arraycopy(schemaObjectArray, n + 1, schemaObjectArray2, n, schemaObjectArray2.length - n);
                schemaObjectArray = schemaObjectArray2;
            }
        }
        return super.filterAndSort(schemaObjectArray);
    }

    public Transferable createTransferable(TreePath treePath) {
        DBObjectTransferable dBObjectTransferable = (DBObjectTransferable)super.createTransferable(treePath);
        if (dBObjectTransferable.getDBObject() instanceof FKConstraint) {
            dBObjectTransferable = null;
        }
        return dBObjectTransferable;
    }

    private class Renderer
    extends DBObjectRenderer {
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JComponent jComponent = (JComponent)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object instanceof DefaultMutableTreeNode) {
                Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
                if (object2 instanceof Relation) {
                    DBObjectRenderer.setToolTipText(jComponent, CmWizardsArb.getString(326));
                } else if (object2 instanceof FKConstraint) {
                    DBObjectRenderer.setToolTipText(jComponent, CmWizardsArb.getString(327));
                } else {
                    DBObjectRenderer.setToolTipText(jComponent, null);
                }
            }
            return jComponent;
        }

        private Renderer() {
        }

        Renderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

