/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.ui.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ide.controls.JComboCardPanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.OracleIndexOrganizedTableProperties;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.jdeveloper.cm.dt.ui.BaseInfoPanel;
import oracle.jdeveloper.cm.dt.ui.DBObjectRenderer;
import oracle.jdeveloper.cm.dt.ui.table.StorageInfoPanel;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class IOTInfoPanel
extends BaseInfoPanel
implements ActionListener {
    private DBObjectRenderer m_rend;
    private JLabel m_incColLabel;
    private JComboBox m_incColComboBox;
    private JCheckBox m_keyCompCheckBox;
    private NumberTextField m_keyCompField;
    private JLabel m_pctLabel;
    private NumberTextField m_pctField;
    private JCheckBox m_mappingCheckBox;
    private JCheckBox m_overflowCheckBox;
    private StorageInfoPanel m_overflowPropsPanel;

    void $init$() {
        this.m_rend = new DBObjectRenderer();
        this.m_incColLabel = new JLabel();
        this.m_incColComboBox = new JComboBox();
        this.m_keyCompCheckBox = new JCheckBox();
        this.m_keyCompField = new NumberTextField();
        this.m_pctLabel = new JLabel();
        this.m_pctField = new NumberTextField();
        this.m_mappingCheckBox = new JCheckBox();
        this.m_overflowCheckBox = new JCheckBox();
        this.m_overflowPropsPanel = new StorageInfoPanel();
    }

    public IOTInfoPanel() {
        this.$init$();
        try {
            this.layoutComponents();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void layoutComponents() {
        this.m_incColComboBox.setRenderer(this.m_rend);
        this.m_keyCompField.setDecimal(false);
        this.m_keyCompField.setSigned(false);
        this.m_overflowPropsPanel.setTopLabelText(null);
        this.m_overflowCheckBox.addActionListener(this);
        this.m_keyCompCheckBox.addActionListener(this);
        this.setLayout(new GridBagLayout());
        ResourceUtils.resLabel((JLabel)this.m_incColLabel, (Component)this.m_incColComboBox, (String)CmWizardsArb.getString(503));
        ResourceUtils.resButton((AbstractButton)this.m_keyCompCheckBox, (String)CmWizardsArb.getString(505));
        ResourceUtils.resButton((AbstractButton)this.m_overflowCheckBox, (String)CmWizardsArb.getString(507));
        ResourceUtils.resButton((AbstractButton)this.m_mappingCheckBox, (String)CmWizardsArb.getString(506));
        ResourceUtils.resLabel((JLabel)this.m_pctLabel, (Component)this.m_pctField, (String)CmWizardsArb.getString(504));
        int n = 0;
        this.add(this.m_pctLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.m_pctField, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 20), 0, 0));
        this.add(this.m_keyCompCheckBox, new GridBagConstraints(2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.m_keyCompField, new GridBagConstraints(3, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.m_incColLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.m_incColComboBox, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 20), 0, 0));
        this.add(this.m_mappingCheckBox, new GridBagConstraints(2, n, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        JComboCardPanel jComboCardPanel = new JComboCardPanel(new JLabel(), (JComponent)this.m_overflowCheckBox);
        this.m_overflowPropsPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        jComboCardPanel.showSubPanel((JComponent)((Object)this.m_overflowPropsPanel));
        this.add((Component)jComboCardPanel, new GridBagConstraints(0, ++n, 4, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        DBObjectProvider dBObjectProvider = (DBObjectProvider)traversableContext.get("DBObjectProvider");
        Table table = (Table)traversableContext.get("NewObject");
        Table table2 = (Table)traversableContext.get("OriginalObject");
        String[] stringArray = (String[])traversableContext.find("Tablespaces");
        OracleIndexOrganizedTableProperties oracleIndexOrganizedTableProperties = (OracleIndexOrganizedTableProperties)table.getProperty("OracleIndexOrganizedTableProperties");
        this.init(dBObjectProvider, table, oracleIndexOrganizedTableProperties, stringArray, table2 != null);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DBObjectProvider dBObjectProvider = (DBObjectProvider)traversableContext.get("DBObjectProvider");
        Table table = (Table)traversableContext.get("NewObject");
        OracleIndexOrganizedTableProperties oracleIndexOrganizedTableProperties = (OracleIndexOrganizedTableProperties)table.getProperty("OracleIndexOrganizedTableProperties");
        if (oracleIndexOrganizedTableProperties == null) {
            oracleIndexOrganizedTableProperties = new OracleIndexOrganizedTableProperties();
            table.setProperty("OracleIndexOrganizedTableProperties", (Object)oracleIndexOrganizedTableProperties);
        }
        this.commit(dBObjectProvider, table, oracleIndexOrganizedTableProperties);
    }

    private void init(DBObjectProvider dBObjectProvider, Table table, OracleIndexOrganizedTableProperties oracleIndexOrganizedTableProperties, String[] stringArray, boolean bl) {
        this.initDynamicControls(table);
        this.m_overflowPropsPanel.init(dBObjectProvider, oracleIndexOrganizedTableProperties == null ? null : oracleIndexOrganizedTableProperties.getOverflowProperties(), null, stringArray);
        if (oracleIndexOrganizedTableProperties != null) {
            this.m_mappingCheckBox.setSelected(oracleIndexOrganizedTableProperties.isMapped());
            this.m_pctField.setNumber((Number)oracleIndexOrganizedTableProperties.getPctThreshold());
            Integer n = oracleIndexOrganizedTableProperties.getKeyCompression();
            this.m_keyCompCheckBox.setSelected(n != null);
            this.m_keyCompField.setEnabled(n != null);
            this.m_keyCompField.setNumber((Number)n);
            DBObjectID dBObjectID = oracleIndexOrganizedTableProperties.getIncludeColumn();
            if (dBObjectID != null) {
                try {
                    Column column = (Column)dBObjectID.resolveID();
                    if (column != null) {
                        this.m_incColComboBox.setSelectedItem(column);
                        if (bl) {
                            this.m_incColComboBox.removeItem(" ");
                        }
                    }
                }
                catch (DBException dBException) {
                    // empty catch block
                }
            }
            if (oracleIndexOrganizedTableProperties.isOverflowable()) {
                this.m_overflowCheckBox.setSelected(true);
                this.overflowEnable(true);
                if (bl) {
                    this.m_overflowCheckBox.setEnabled(false);
                }
            } else {
                this.m_overflowCheckBox.setSelected(false);
                this.overflowEnable(false);
            }
        } else {
            this.m_keyCompCheckBox.setSelected(false);
            this.m_keyCompField.setEnabled(false);
            this.m_overflowCheckBox.setSelected(false);
            this.overflowEnable(false);
        }
    }

    private void commit(DBObjectProvider dBObjectProvider, Table table, OracleIndexOrganizedTableProperties oracleIndexOrganizedTableProperties) throws TraversalException {
        Object object = this.m_incColComboBox.getSelectedItem();
        if (object instanceof Column) {
            DBObjectID dBObjectID = ((Column)object).getID();
            if (dBObjectID == null) {
                dBObjectID = TemporaryObjectID.createID((DBObject)((Column)object));
                ((Column)object).setID(dBObjectID);
            }
            oracleIndexOrganizedTableProperties.setIncludeColumn(dBObjectID);
        } else {
            oracleIndexOrganizedTableProperties.setIncludeColumn(null);
        }
        oracleIndexOrganizedTableProperties.setMapped(this.m_mappingCheckBox.isSelected());
        if (this.m_keyCompCheckBox.isSelected()) {
            Number number = this.m_keyCompField.getNumber();
            oracleIndexOrganizedTableProperties.setKeyCompression(Integer.valueOf(number == null ? 0 : number.intValue()));
        } else {
            oracleIndexOrganizedTableProperties.setKeyCompression(null);
        }
        Number number = this.m_pctField.getNumber();
        oracleIndexOrganizedTableProperties.setPctThreshold(number == null ? null : new Integer(number.intValue()));
        if (this.m_overflowCheckBox.isSelected()) {
            oracleIndexOrganizedTableProperties.setOverflowable(true);
            OracleStorageProperties oracleStorageProperties = oracleIndexOrganizedTableProperties.getOverflowProperties();
            if (oracleStorageProperties == null) {
                oracleStorageProperties = new OracleStorageProperties();
                oracleIndexOrganizedTableProperties.setOverflowProperties(oracleStorageProperties);
            }
            this.m_overflowPropsPanel.commit(oracleStorageProperties, true);
        } else {
            oracleIndexOrganizedTableProperties.setOverflowable(false);
        }
        try {
            oracleIndexOrganizedTableProperties.validate(table);
        }
        catch (ValidationException validationException) {
            throw new TraversalException(validationException.getMessage(), validationException.getTitle());
        }
    }

    private void initDynamicControls(Table table) {
        ArrayList<Column> arrayList = new ArrayList<Column>(Arrays.asList(table.getColumns()));
        boolean bl = false;
        Constraint[] constraintArray = table.getConstraints();
        int n = 0;
        while (n < constraintArray.length) {
            Constraint constraint = constraintArray[n];
            if (constraint instanceof PKConstraint) {
                List<Column> list = Arrays.asList(((PKConstraint)constraint).getColumns());
                bl = list.size() > 1;
                Iterator<Column> iterator = list.iterator();
                while (iterator.hasNext()) {
                    if (!iterator.hasNext()) continue;
                    arrayList.remove(iterator.next());
                }
                break;
            }
            ++n;
        }
        this.m_incColComboBox.removeAllItems();
        this.m_incColComboBox.addItem(" ");
        for (Column column : arrayList) {
            this.m_incColComboBox.addItem(column);
        }
        this.m_keyCompCheckBox.setSelected(bl);
        this.m_keyCompCheckBox.setEnabled(bl);
        this.m_keyCompField.setEnabled(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_overflowCheckBox) {
            this.overflowEnable(this.m_overflowCheckBox.isSelected());
        } else if (object == this.m_keyCompCheckBox) {
            this.m_keyCompField.setEnabled(this.m_keyCompCheckBox.isSelected());
        }
    }

    private void overflowEnable(boolean bl) {
        this.m_overflowPropsPanel.enableAllComponents(bl, true);
        this.m_incColLabel.setEnabled(bl);
        this.m_incColComboBox.setEnabled(bl);
        if (!bl) {
            this.m_incColComboBox.setSelectedItem(null);
        }
    }
}

