/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.ui.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.dialogs.DialogUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.cm.dt.ui.ListButtons;
import oracle.jdeveloper.cm.dt.ui.table.PartitionDefinitionPanel;
import oracle.jdeveloper.cm.dt.ui.table.PartitionStoragePanel;
import oracle.jdeveloper.cm.dt.ui.table.StorageInfoPanel;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class PartitionListPanel
extends JPanel
implements ListButtons.Helper,
ListSelectionListener,
ActionListener {
    private OracleTablePartitions.ObjectType m_type;
    private OracleTablePartitions.PartitionType m_partType;
    private OracleTablePartitions.PartitionType m_subpartType;
    private DBObjectProvider m_pro;
    private Table m_table;
    private String[] m_tablespaces;
    private TablePartition m_currentPartition;
    private boolean m_editing;
    private JWrappedLabel m_descLabel;
    private JLabel m_nameLabel;
    private JTextField m_nameField;
    private DefaultListModel m_partListModel;
    private JList m_partList;
    private JLabel m_partLabel;
    private ListButtons m_partButtons;
    private JPanel m_editPanel;
    private JPanel m_editComponentPanel;
    private JLabel m_valuesLabel;
    private JTextField m_valuesField;
    private JButton m_storageButton;
    private JButton m_subPartsButton;

    void $init$() {
        this.m_descLabel = new JWrappedLabel();
        this.m_nameLabel = new JLabel();
        this.m_nameField = new JTextField("");
        this.m_partListModel = new DefaultListModel();
        this.m_partList = new JList(this.m_partListModel);
        this.m_partLabel = new JLabel();
        this.m_partButtons = new ListButtons(this.m_partList, this);
        this.m_editPanel = new JPanel();
        this.m_valuesLabel = new JLabel();
        this.m_valuesField = new JTextField();
        this.m_storageButton = new JButton();
        this.m_subPartsButton = new JButton();
    }

    public PartitionListPanel() {
        this.$init$();
        try {
            this.layoutComponents();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        this.m_partButtons.addActionListener(this);
        this.m_partList.setSelectionMode(0);
        this.m_partList.addListSelectionListener(this);
        ResourceUtils.resLabel((JLabel)this.m_nameLabel, (Component)this.m_nameField, (String)CmWizardsArb.getString(525));
        ResourceUtils.resButton((AbstractButton)this.m_storageButton, (String)CmWizardsArb.getString(527));
        this.m_storageButton.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this.m_subPartsButton, (String)CmWizardsArb.getString(528));
        this.m_subPartsButton.addActionListener(this);
        int n = 0;
        this.add((Component)this.m_descLabel, new GridBagConstraints(0, n, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.m_partLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)new JScrollPane(this.m_partList), new GridBagConstraints(0, ++n, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.m_partButtons, new GridBagConstraints(1, n, 1, 1, 0.0, 1.0, 17, 3, new Insets(5, 5, 0, 5), 0, 0));
        this.m_editPanel.setLayout(new GridBagLayout());
        this.add((Component)this.m_editPanel, new GridBagConstraints(0, ++n, 2, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
    }

    private void layoutEditPanel() {
        int n = 537;
        int n2 = 519;
        OracleTablePartitions.PartitionType partitionType = this.m_partType;
        OracleTablePartitions.PartitionType partitionType2 = null;
        if (this.m_type != OracleTablePartitions.ObjectType.PARTITION) {
            if (this.m_type == OracleTablePartitions.ObjectType.SUBPARTITION || this.m_type == OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE) {
                n = 539;
                n2 = 520;
            } else if (this.m_type == OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION) {
                n = 538;
                n2 = 521;
            }
            OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)this.m_table.getProperty("OracleTablePartitions");
            partitionType = oracleTablePartitions.getPartitionType();
            partitionType2 = this.m_partType;
        }
        this.m_descLabel.setText(CmWizardsArb.format(n, partitionType, partitionType2));
        ResourceUtils.resLabel((JLabel)this.m_partLabel, (Component)this.m_partList, (String)CmWizardsArb.getString(n2));
        this.m_editPanel.removeAll();
        this.m_editPanel.setBorder(BorderFactory.createTitledBorder(this.m_type == OracleTablePartitions.ObjectType.PARTITION ? CmWizardsArb.getString(523) : CmWizardsArb.getString(524)));
        int n3 = 0;
        this.m_editPanel.add((Component)this.m_nameLabel, new GridBagConstraints(0, n3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.m_editPanel.add((Component)this.m_nameField, new GridBagConstraints(1, n3, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        if (this.m_partType == OracleTablePartitions.PartitionType.RANGE || this.m_partType == OracleTablePartitions.PartitionType.LIST) {
            String string = this.m_partType == OracleTablePartitions.PartitionType.RANGE ? "VALUES LESS THAN" : "VALUES";
            ResourceUtils.resLabel((JLabel)this.m_valuesLabel, (Component)this.m_valuesField, (String)CmWizardsArb.format(526, string));
            this.m_editPanel.add((Component)this.m_valuesLabel, new GridBagConstraints(0, ++n3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            this.m_editPanel.add((Component)this.m_valuesField, new GridBagConstraints(1, n3, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        }
        this.m_editPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(0, ++n3, 2, 1, 1.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.m_editPanel.add((Component)this.m_storageButton, new GridBagConstraints(2, n3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        if (this.m_subpartType != null) {
            this.m_editPanel.add((Component)this.m_subPartsButton, new GridBagConstraints(3, n3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        }
        this.validate();
    }

    public void init(DBObjectProvider dBObjectProvider, OracleTablePartitions oracleTablePartitions, Table table, String[] stringArray, boolean bl) {
        this.m_pro = dBObjectProvider;
        this.m_table = table;
        this.m_tablespaces = stringArray;
        this.m_editing = bl;
        TablePartition[] tablePartitionArray = oracleTablePartitions.getPartitions();
        OracleTablePartitions oracleTablePartitions2 = oracleTablePartitions.getSubpartitionModel();
        this.m_subpartType = oracleTablePartitions2 == null ? null : oracleTablePartitions2.getPartitionType();
        this.m_type = oracleTablePartitions.getObjectType();
        this.m_partType = oracleTablePartitions.getPartitionType();
        this.m_partListModel.removeAllElements();
        if (tablePartitionArray != null) {
            int n = 0;
            while (n < tablePartitionArray.length) {
                this.m_partListModel.addElement(tablePartitionArray[n]);
                ++n;
            }
        }
        this.layoutEditPanel();
        this.initCurrentPartition();
        this.m_partButtons.enableButtons();
    }

    public TablePartition[] getPartitions() throws ValidationException {
        if (this.m_currentPartition != null) {
            this.commitCurrentPartition();
        }
        TablePartition[] tablePartitionArray = new TablePartition[this.m_partListModel.getSize()];
        Enumeration enumeration = this.m_partListModel.elements();
        int n = 0;
        while (n < tablePartitionArray.length) {
            tablePartitionArray[n] = (TablePartition)enumeration.nextElement();
            ++n;
        }
        return tablePartitionArray;
    }

    private void addPartition() {
        if (this.m_currentPartition == null || this.tryCommitCurrentPartition()) {
            this.m_currentPartition = null;
            int n = this.m_partList.getSelectedIndex();
            n = n < 0 ? this.m_partListModel.size() : n + 1;
            this.m_partListModel.add(n, new TablePartition(this.m_partType, this.m_type));
            this.m_partList.setSelectedIndex(n);
            if (this.m_partType == OracleTablePartitions.PartitionType.LIST || this.m_partType == OracleTablePartitions.PartitionType.RANGE) {
                this.m_valuesField.requestFocus();
            } else {
                this.m_nameField.requestFocus();
            }
        }
    }

    private void removePartition() {
        int n = this.m_partList.getSelectedIndex();
        if (n >= 0) {
            this.m_currentPartition = null;
            this.m_partListModel.remove(n);
        }
    }

    private boolean tryCommitCurrentPartition() {
        try {
            this.commitCurrentPartition();
        }
        catch (ValidationException validationException) {
            MessageDialog.error((Component)this, (Object)validationException.getMessage(), (String)validationException.getTitle(), null);
            boolean bl = false;
            return bl;
        }
        return true;
    }

    private void commitCurrentPartition() throws ValidationException {
        String string = this.m_nameField.getText();
        if (this.m_type == OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE && !ModelUtil.hasLength((String)string)) {
            throw new ValidationException((DBObject)this.m_table, CmWizardsArb.getString(536));
        }
        if (ModelUtil.hasLength((String)string)) {
            this.m_pro.validateName("PARTITION", string);
            this.m_currentPartition.setName(this.m_pro.getInternalName(string));
        } else {
            this.m_currentPartition.setName(null);
        }
        this.m_currentPartition.setValues(this.m_valuesField.getText());
        this.m_currentPartition.validate(this.m_table);
    }

    private void initCurrentPartition() {
        boolean bl;
        boolean bl2 = bl = this.m_currentPartition != null;
        if (bl) {
            String string = this.m_currentPartition.getName();
            if (ModelUtil.hasLength((String)string)) {
                this.m_nameField.setText(this.m_pro.getExternalName(string));
            } else {
                this.m_nameField.setText(null);
            }
            Object[] objectArray = this.m_currentPartition.getValues();
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < objectArray.length) {
                stringBuffer.append(objectArray[n].toString());
                if (n < objectArray.length - 1) {
                    stringBuffer.append(",");
                }
                ++n;
            }
            this.m_valuesField.setText(stringBuffer.toString());
        } else {
            this.m_nameField.setText(null);
            this.m_valuesField.setText(null);
        }
        this.m_nameField.setEnabled(bl);
        this.m_nameLabel.setEnabled(bl);
        this.m_valuesField.setEnabled(bl);
        this.m_valuesLabel.setEnabled(bl);
        this.m_storageButton.setEnabled(bl);
        this.m_subPartsButton.setEnabled(bl);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.m_descLabel.setEnabled(bl);
        this.m_partLabel.setEnabled(bl);
        this.m_partList.setEnabled(bl);
        this.m_partButtons.setEnabled(bl);
        if (!bl) {
            this.m_partList.setSelectedValue(null, false);
        }
        this.initCurrentPartition();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        TablePartition tablePartition = (TablePartition)this.m_partList.getSelectedValue();
        if (this.m_currentPartition != null && this.m_currentPartition != tablePartition && !this.tryCommitCurrentPartition()) {
            this.m_partList.setSelectedValue(this.m_currentPartition, true);
            return;
        }
        this.m_currentPartition = tablePartition;
        this.initCurrentPartition();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_partButtons) {
            int n = actionEvent.getID();
            if (n == 0) {
                this.addPartition();
            } else if (n == 1) {
                this.removePartition();
            }
        } else if (object == this.m_subPartsButton) {
            if (this.m_currentPartition != null) {
                OracleTablePartitions oracleTablePartitions = this.m_currentPartition.getPartitionLevelSubpartitions();
                OracleTablePartitions oracleTablePartitions2 = oracleTablePartitions == null ? new OracleTablePartitions(this.m_subpartType, OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION) : oracleTablePartitions;
                JEWTDialog jEWTDialog = JEWTDialog.createDialog((Component)DialogUtil.getAncestorDialog((Component)this), (String)CmWizardsArb.getString(522), (int)3);
                PartitionDefinitionPanel partitionDefinitionPanel = new PartitionDefinitionPanel();
                jEWTDialog.setContent((Component)((Object)partitionDefinitionPanel));
                jEWTDialog.setResizable(true);
                jEWTDialog.setSize(500, 300);
                partitionDefinitionPanel.init(this.m_pro, this.m_table, oracleTablePartitions2, this.m_tablespaces, this.m_editing);
                2 var8_8 = new 2(this, oracleTablePartitions, oracleTablePartitions2, partitionDefinitionPanel);
                jEWTDialog.addVetoableChangeListener((VetoableChangeListener)var8_8);
                jEWTDialog.runDialog();
            }
        } else if (object == this.m_storageButton) {
            Object object2;
            String string = this.m_type == OracleTablePartitions.ObjectType.PARTITION ? CmWizardsArb.getString(534) : CmWizardsArb.getString(535);
            JEWTDialog jEWTDialog = JEWTDialog.createDialog((Component)DialogUtil.getAncestorDialog((Component)this), (String)string, (int)3);
            if (this.m_type == OracleTablePartitions.ObjectType.PARTITION && this.m_partType != OracleTablePartitions.PartitionType.HASH) {
                object2 = new StorageInfoPanel();
                ((StorageInfoPanel)object2).init(null, this.m_currentPartition.getSegmentAttributes(), null, this.m_tablespaces);
            } else {
                object2 = new PartitionStoragePanel();
                ((PartitionStoragePanel)object2).init(this.m_currentPartition, this.m_tablespaces);
            }
            jEWTDialog.setContent((Component)object2);
            jEWTDialog.setResizable(true);
            jEWTDialog.setSize(500, 300);
            1 var12_12 = new 1(this, (JPanel)object2);
            jEWTDialog.addVetoableChangeListener((VetoableChangeListener)var12_12);
            jEWTDialog.runDialog();
        }
    }

    public boolean canAdd() {
        TablePartition tablePartition;
        Object[] objectArray;
        return !this.m_editing || this.m_partType != OracleTablePartitions.PartitionType.LIST || this.m_partListModel.size() <= 0 || (objectArray = (tablePartition = (TablePartition)this.m_partListModel.get(this.m_partListModel.size() - 1)).getValues()).length != 1 || !objectArray[0].equals("DEFAULT");
    }

    public boolean canAdd(Object object) {
        return true;
    }

    public boolean canMoveDown(Object object) {
        return true;
    }

    public boolean canMoveUp(Object object) {
        return true;
    }

    public boolean canRemove() {
        if (this.m_editing) {
            return this.m_partListModel.size() > 1;
        }
        return true;
    }

    public boolean canRemove(Object object) {
        return true;
    }

    public boolean canReorder() {
        return this.m_editing ^ true;
    }

    public String getAddTooltipText() {
        return null;
    }

    public String getDownTooltipText() {
        return null;
    }

    public String getRemoveTooltipText() {
        return null;
    }

    public String getUpTooltipText() {
        return null;
    }

    static TablePartition ra$m_currentPartition(PartitionListPanel partitionListPanel) {
        return partitionListPanel.m_currentPartition;
    }

    static Table ra$m_table(PartitionListPanel partitionListPanel) {
        return partitionListPanel.m_table;
    }

    public final class 2
    implements VetoableChangeListener {
        private final /* synthetic */ OracleTablePartitions v$subparts;
        private final /* synthetic */ OracleTablePartitions v$editMe;
        private final /* synthetic */ PartitionDefinitionPanel v$panel;
        final /* synthetic */ PartitionListPanel this$0;

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent)) {
                try {
                    if (this.v$subparts == null) {
                        PartitionListPanel.ra$m_currentPartition(this.this$0).setPartitionLevelSubpartitions(this.v$editMe);
                    }
                    this.v$panel.commit(PartitionListPanel.ra$m_table(this.this$0), this.v$editMe, null, false);
                    PartitionListPanel.ra$m_currentPartition(this.this$0).validatePartitionLevelSubpartitions(PartitionListPanel.ra$m_table(this.this$0));
                }
                catch (ValidationException validationException) {
                    throw new PropertyVetoException(validationException.getMessage(), propertyChangeEvent);
                }
            }
        }

        public 2(PartitionListPanel partitionListPanel, OracleTablePartitions oracleTablePartitions, OracleTablePartitions oracleTablePartitions2, PartitionDefinitionPanel partitionDefinitionPanel) {
            this.v$panel = partitionDefinitionPanel;
            this.v$editMe = oracleTablePartitions2;
            this.v$subparts = oracleTablePartitions;
            this.this$0 = partitionListPanel;
        }
    }

    public final class 1
    implements VetoableChangeListener {
        private final /* synthetic */ JPanel v$panel;
        final /* synthetic */ PartitionListPanel this$0;

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent)) {
                try {
                    if (this.v$panel instanceof StorageInfoPanel) {
                        OracleStorageProperties oracleStorageProperties = PartitionListPanel.ra$m_currentPartition(this.this$0).getSegmentAttributes();
                        if (oracleStorageProperties == null) {
                            oracleStorageProperties = new OracleStorageProperties();
                            PartitionListPanel.ra$m_currentPartition(this.this$0).setSegmentAttributes(oracleStorageProperties);
                        }
                        ((StorageInfoPanel)((Object)this.v$panel)).commit(oracleStorageProperties, true);
                        PartitionListPanel.ra$m_currentPartition(this.this$0).validateSegmentAttributes(PartitionListPanel.ra$m_table(this.this$0));
                    } else {
                        ((PartitionStoragePanel)this.v$panel).commit(PartitionListPanel.ra$m_currentPartition(this.this$0), PartitionListPanel.ra$m_table(this.this$0));
                    }
                }
                catch (TraversalException traversalException) {
                    throw new PropertyVetoException(traversalException.getMessage(), propertyChangeEvent);
                }
                catch (ValidationException validationException) {
                    throw new PropertyVetoException(validationException.getMessage(), propertyChangeEvent);
                }
            }
        }

        public 1(PartitionListPanel partitionListPanel, JPanel jPanel) {
            this.v$panel = jPanel;
            this.this$0 = partitionListPanel;
        }
    }
}

