/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.ui.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.jdeveloper.cm.dt.ui.BaseInfoPanel;
import oracle.jdeveloper.cm.dt.verifier.table.StorageInfoVerifier;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class StorageInfoPanel
extends BaseInfoPanel
implements ItemListener {
    public static final String TABLESPACES_KEY = "Tablespaces";
    public static final String DEFAULT_OPTION = "<DEFAULT>";
    public static final String[] BUFFER_OPTIONS = new String[]{"<DEFAULT>", "KEEP", "RECYCLE"};
    public static final String[] LOGGING_OPTIONS = new String[]{"<DEFAULT>", "ON", "OFF"};
    private BorderLayout layMain;
    private JMultiLineLabel lblTop;
    private JPanel pnlCenter;
    private GridBagLayout layCenter;
    private JLabel lblTablespace;
    protected JComboBox cmbTablespace;
    private JLabel lblPctFree;
    private JLabel lblPctUsed;
    private JLabel lblIniTrans;
    private JLabel lblMaxTrans;
    private StorageNumberField fldPctFree;
    private StorageNumberField fldPctUsed;
    private StorageNumberField fldIniTrans;
    private StorageNumberField fldMaxTrans;
    private JPanel pnlExtents;
    private GridBagLayout layExtents;
    private JPanel pnlFreeLists;
    private GridBagLayout layFreeLists;
    private JLabel lblInitExtents;
    private JLabel lblNextExtents;
    private JLabel lblMinExtents;
    private JLabel lblMaxExtents;
    private JLabel lblPctIncrease;
    private StorageNumberField fldInitExtents;
    private StorageNumberField fldNextExtents;
    private StorageNumberField fldMinExtents;
    private StorageNumberField fldMaxExtents;
    private StorageNumberField fldPctIncrease;
    private JComboBox cmbInitExtents;
    private JComboBox cmbNextExtents;
    private JCheckBox chkUnlimited;
    private JLabel lblFreeLists;
    private JLabel lblFreeListGroups;
    private StorageNumberField fldFreeLists;
    private StorageNumberField fldFreeListGroups;
    private JLabel lblBufferPool;
    private JLabel lblLogging;
    private JComboBox cmbBufferPool;
    private JComboBox cmbLogging;
    private NonNullableComboBoxModel mdlInitExtents;
    private NonNullableComboBoxModel mdlNextExtents;
    private NonNullableComboBoxModel mdlBufferPool;
    private NonNullableComboBoxModel mdlLogging;
    private NonNullableComboBoxModel mdlTablespace;
    private static final String[] EXTENTS_SIZES = new String[]{"", "K", "M"};
    private static final int K = 1024;
    private static final int M = 0x100000;

    void $init$() {
        this.layMain = new BorderLayout();
        this.lblTop = new JMultiLineLabel();
        this.pnlCenter = new JPanel();
        this.layCenter = new GridBagLayout();
        this.lblTablespace = new JLabel();
        this.cmbTablespace = new JComboBox();
        this.lblPctFree = new JLabel();
        this.lblPctUsed = new JLabel();
        this.lblIniTrans = new JLabel();
        this.lblMaxTrans = new JLabel();
        this.fldPctFree = new StorageNumberField();
        this.fldPctUsed = new StorageNumberField();
        this.fldIniTrans = new StorageNumberField();
        this.fldMaxTrans = new StorageNumberField();
        this.pnlExtents = new JPanel();
        this.layExtents = new GridBagLayout();
        this.pnlFreeLists = new JPanel();
        this.layFreeLists = new GridBagLayout();
        this.lblInitExtents = new JLabel();
        this.lblNextExtents = new JLabel();
        this.lblMinExtents = new JLabel();
        this.lblMaxExtents = new JLabel();
        this.lblPctIncrease = new JLabel();
        this.fldInitExtents = new StorageNumberField();
        this.fldNextExtents = new StorageNumberField();
        this.fldMinExtents = new StorageNumberField();
        this.fldMaxExtents = new StorageNumberField();
        this.fldPctIncrease = new StorageNumberField();
        this.cmbInitExtents = new JComboBox();
        this.cmbNextExtents = new JComboBox();
        this.chkUnlimited = new JCheckBox();
        this.lblFreeLists = new JLabel();
        this.lblFreeListGroups = new JLabel();
        this.fldFreeLists = new StorageNumberField();
        this.fldFreeListGroups = new StorageNumberField();
        this.lblBufferPool = new JLabel();
        this.lblLogging = new JLabel();
        this.cmbBufferPool = new JComboBox();
        this.cmbLogging = new JComboBox();
        this.mdlInitExtents = new NonNullableComboBoxModel((Object[])EXTENTS_SIZES);
        this.mdlNextExtents = new NonNullableComboBoxModel((Object[])EXTENTS_SIZES);
        this.mdlBufferPool = new NonNullableComboBoxModel((Object[])BUFFER_OPTIONS);
        this.mdlLogging = new NonNullableComboBoxModel((Object[])LOGGING_OPTIONS);
    }

    public StorageInfoPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.layMain);
        this.lblTop.setText(CmWizardsArb.getString(148));
        this.lblTop.setPreferredAspectRatio(0.0f);
        this.lblTop.setBorder(BorderFactory.createEmptyBorder(0, 0, 15, 0));
        this.pnlCenter.setLayout(this.layCenter);
        ResourceUtils.resLabel((JLabel)this.lblTablespace, (Component)this.cmbTablespace, (String)CmWizardsArb.getString(149));
        ResourceUtils.resLabel((JLabel)this.lblPctFree, (Component)((Object)this.fldPctFree), (String)CmWizardsArb.getString(150));
        this.fldPctFree.setMaximumValue(99);
        this.fldPctFree.setColumns(5);
        ResourceUtils.resLabel((JLabel)this.lblPctUsed, (Component)((Object)this.fldPctUsed), (String)CmWizardsArb.getString(151));
        this.fldPctUsed.setMaximumValue(99);
        this.fldPctUsed.setColumns(5);
        ResourceUtils.resLabel((JLabel)this.lblIniTrans, (Component)((Object)this.fldIniTrans), (String)CmWizardsArb.getString(152));
        this.fldIniTrans.setMaximumValue(255);
        this.fldIniTrans.setColumns(5);
        ResourceUtils.resLabel((JLabel)this.lblMaxTrans, (Component)((Object)this.fldMaxTrans), (String)CmWizardsArb.getString(153));
        this.fldMaxTrans.setMaximumValue(255);
        this.fldMaxTrans.setColumns(5);
        this.pnlExtents.setLayout(this.layExtents);
        this.pnlExtents.setBorder(BorderFactory.createTitledBorder(CmWizardsArb.getString(154)));
        this.pnlFreeLists.setLayout(this.layFreeLists);
        this.pnlFreeLists.setBorder(BorderFactory.createTitledBorder(CmWizardsArb.getString(155)));
        ResourceUtils.resLabel((JLabel)this.lblInitExtents, (Component)((Object)this.fldInitExtents), (String)CmWizardsArb.getString(156));
        ResourceUtils.resLabel((JLabel)this.lblNextExtents, (Component)((Object)this.fldNextExtents), (String)CmWizardsArb.getString(158));
        ResourceUtils.resLabel((JLabel)this.lblMinExtents, (Component)((Object)this.fldMinExtents), (String)CmWizardsArb.getString(160));
        ResourceUtils.resLabel((JLabel)this.lblMaxExtents, (Component)((Object)this.fldMaxExtents), (String)CmWizardsArb.getString(161));
        ResourceUtils.resLabel((JLabel)this.lblPctIncrease, (Component)((Object)this.fldPctIncrease), (String)CmWizardsArb.getString(163));
        AccessibleContext accessibleContext = this.cmbInitExtents.getAccessibleContext();
        if (accessibleContext != null) {
            accessibleContext.setAccessibleName(CmWizardsArb.getString(157));
        }
        this.cmbInitExtents.setModel(this.mdlInitExtents);
        accessibleContext = this.cmbNextExtents.getAccessibleContext();
        if (accessibleContext != null) {
            accessibleContext.setAccessibleName(CmWizardsArb.getString(159));
        }
        this.cmbNextExtents.setModel(this.mdlNextExtents);
        ResourceUtils.resButton((AbstractButton)this.chkUnlimited, (String)CmWizardsArb.getString(162));
        this.chkUnlimited.addItemListener(this);
        ResourceUtils.resLabel((JLabel)this.lblFreeLists, (Component)((Object)this.fldFreeLists), (String)CmWizardsArb.getString(164));
        ResourceUtils.resLabel((JLabel)this.lblFreeListGroups, (Component)((Object)this.fldFreeListGroups), (String)CmWizardsArb.getString(165));
        ResourceUtils.resLabel((JLabel)this.lblBufferPool, (Component)this.cmbBufferPool, (String)CmWizardsArb.getString(166));
        ResourceUtils.resLabel((JLabel)this.lblLogging, (Component)this.cmbLogging, (String)CmWizardsArb.getString(167));
        this.cmbBufferPool.setModel(this.mdlBufferPool);
        this.cmbLogging.setModel(this.mdlLogging);
        this.add((Component)this.lblTop, "North");
        this.pnlCenter.add((Component)this.lblTablespace, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 12), 0, 0));
        this.pnlCenter.add((Component)this.cmbTablespace, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlCenter.add((Component)this.lblPctFree, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.pnlCenter.add((Component)this.lblPctUsed, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.pnlCenter.add((Component)this.lblIniTrans, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 24, 0, 12), 0, 0));
        this.pnlCenter.add((Component)this.lblMaxTrans, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 24, 0, 12), 0, 0));
        this.pnlCenter.add((Component)((Object)this.fldPctFree), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.pnlCenter.add((Component)((Object)this.fldPctUsed), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.pnlCenter.add((Component)((Object)this.fldIniTrans), new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.pnlCenter.add((Component)((Object)this.fldMaxTrans), new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.pnlExtents.add((Component)this.lblInitExtents, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.pnlExtents.add((Component)this.lblNextExtents, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.pnlExtents.add((Component)this.lblMinExtents, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.pnlExtents.add((Component)this.lblMaxExtents, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.pnlExtents.add((Component)this.lblPctIncrease, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.pnlExtents.add((Component)((Object)this.fldInitExtents), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.pnlExtents.add((Component)((Object)this.fldNextExtents), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.pnlExtents.add((Component)((Object)this.fldMinExtents), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.pnlExtents.add((Component)((Object)this.fldMaxExtents), new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.pnlExtents.add((Component)((Object)this.fldPctIncrease), new GridBagConstraints(2, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 12, 5, 5), 0, 0));
        this.pnlExtents.add((Component)this.cmbInitExtents, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 12, 0, 5), 0, 0));
        this.pnlExtents.add((Component)this.cmbNextExtents, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 12, 0, 5), 0, 0));
        this.pnlExtents.add((Component)this.chkUnlimited, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 12, 0, 5), 0, 0));
        this.pnlCenter.add((Component)this.pnlExtents, new GridBagConstraints(0, 3, 2, 3, 1.0, 1.0, 11, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.pnlFreeLists.add((Component)this.lblFreeLists, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.pnlFreeLists.add((Component)this.lblFreeListGroups, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 12), 0, 0));
        this.pnlFreeLists.add((Component)((Object)this.fldFreeLists), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.pnlFreeLists.add((Component)((Object)this.fldFreeListGroups), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.pnlCenter.add((Component)this.pnlFreeLists, new GridBagConstraints(2, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(10, 24, 0, 5), 0, 0));
        this.pnlCenter.add((Component)this.lblBufferPool, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 24, 0, 12), 0, 0));
        this.pnlCenter.add((Component)this.lblLogging, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 24, 0, 12), 0, 0));
        this.pnlCenter.add((Component)this.cmbBufferPool, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 5), 0, 0));
        this.pnlCenter.add((Component)this.cmbLogging, new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 11, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.add(this.pnlCenter, "Center");
    }

    public void onEntry(TraversableContext traversableContext) {
        DBObjectProvider dBObjectProvider = (DBObjectProvider)traversableContext.find("DBObjectProvider");
        Table table = (Table)traversableContext.find("NewObject");
        OracleStorageProperties oracleStorageProperties = (OracleStorageProperties)table.getProperty("OracleStorageProperties");
        StorageInfoVerifier storageInfoVerifier = (StorageInfoVerifier)traversableContext.find("StorageInfoVerifier");
        String[] stringArray = (String[])traversableContext.find(TABLESPACES_KEY);
        this.init(dBObjectProvider, oracleStorageProperties, storageInfoVerifier, stringArray);
        WizardCallbacks wizardCallbacks = traversableContext.getWizardCallbacks();
        if (wizardCallbacks != null) {
            wizardCallbacks.wizardEnableButtons(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
            wizardCallbacks.wizardSetInitialFocus((Component)this.cmbTablespace);
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        Table table = (Table)traversableContext.find("NewObject");
        OracleStorageProperties oracleStorageProperties = (OracleStorageProperties)table.getProperty("OracleStorageProperties");
        if (oracleStorageProperties == null) {
            oracleStorageProperties = new OracleStorageProperties();
            table.setProperty("OracleStorageProperties", (Object)oracleStorageProperties);
        }
        this.commit(oracleStorageProperties, traversableContext.getDirection() != 2);
    }

    protected void init(DBObjectProvider dBObjectProvider, OracleStorageProperties oracleStorageProperties, StorageInfoVerifier storageInfoVerifier, String[] stringArray) {
        super.init(dBObjectProvider, storageInfoVerifier);
        if (storageInfoVerifier != null) {
            this.cmbTablespace.setEnabled(storageInfoVerifier.canChangeTablespace());
            this.fldPctFree.setEnabled(storageInfoVerifier.canChangePercentFree());
            this.fldPctUsed.setEnabled(storageInfoVerifier.canChangePercentUsed());
            this.fldIniTrans.setEnabled(storageInfoVerifier.canChangeInitrans());
            this.fldMaxTrans.setEnabled(storageInfoVerifier.canChangeMaxtrans());
            this.fldInitExtents.setEnabled(storageInfoVerifier.canChangeInitialExtent());
            this.cmbInitExtents.setEnabled(storageInfoVerifier.canChangeInitialExtent());
            this.fldNextExtents.setEnabled(storageInfoVerifier.canChangeNextExtent());
            this.cmbNextExtents.setEnabled(storageInfoVerifier.canChangeNextExtent());
            this.fldMinExtents.setEnabled(storageInfoVerifier.canChangeMinExtent());
            this.fldMaxExtents.setEnabled(storageInfoVerifier.canChangeMaxExtent());
            this.chkUnlimited.setEnabled(storageInfoVerifier.canChangeMaxExtent());
            this.fldPctIncrease.setEnabled(storageInfoVerifier.canChangePercentIncrease());
            this.cmbLogging.setEnabled(storageInfoVerifier.canChangeLogging());
            this.fldFreeLists.setEnabled(storageInfoVerifier.canChangeFreelists());
            this.fldFreeListGroups.setEnabled(storageInfoVerifier.canChangeFreelists());
            this.cmbBufferPool.setEnabled(storageInfoVerifier.canChangeBufferMode());
        } else {
            this.enableAllComponents(true, true);
        }
        if (this.mdlTablespace == null) {
            int n = stringArray != null ? stringArray.length : 0;
            Object[] objectArray = new String[n + 1];
            objectArray[0] = DEFAULT_OPTION;
            if (n > 0) {
                System.arraycopy(stringArray, 0, objectArray, 1, n);
            }
            this.mdlTablespace = new NonNullableComboBoxModel(objectArray);
            this.cmbTablespace.setModel(this.mdlTablespace);
        }
        if (oracleStorageProperties != null) {
            int n;
            int n2;
            int n3;
            int n4;
            String string = oracleStorageProperties.getTablespace();
            if (string == null) {
                string = DEFAULT_OPTION;
            }
            this.cmbTablespace.setSelectedItem(string);
            this.fldPctFree.setNumber(oracleStorageProperties.getPercentFree());
            this.fldPctUsed.setNumber(oracleStorageProperties.getPercentUsed());
            this.fldIniTrans.setNumber(oracleStorageProperties.getInitrans());
            this.fldMaxTrans.setNumber(oracleStorageProperties.getMaxtrans());
            Integer n5 = oracleStorageProperties.getInitialExtent();
            string = EXTENTS_SIZES[0];
            if (n5 != null && (n4 = n5.intValue()) >= 1024 && n4 == (n3 = n4 / 1024) * 1024) {
                n4 = n3;
                string = EXTENTS_SIZES[1];
                n3 = n4 / 1024;
                if (n4 == n3 * 1024) {
                    n4 = n3;
                    string = EXTENTS_SIZES[2];
                }
                n5 = new Integer(n4);
            }
            this.fldInitExtents.setNumber(n5);
            this.cmbInitExtents.setSelectedItem(string);
            n5 = oracleStorageProperties.getNextExtent();
            string = EXTENTS_SIZES[0];
            if (n5 != null && (n2 = n5.intValue()) >= 1024 && n2 == (n = n2 / 1024) * 1024) {
                n2 = n;
                string = EXTENTS_SIZES[1];
                n = n2 / 1024;
                if (n2 == n * 1024) {
                    n2 = n;
                    string = EXTENTS_SIZES[2];
                }
                n5 = new Integer(n2);
            }
            this.fldNextExtents.setNumber(n5);
            this.cmbNextExtents.setSelectedItem(string);
            this.fldMinExtents.setNumber(oracleStorageProperties.getMinExtent());
            n5 = oracleStorageProperties.getMaxExtent();
            if (n5 != null && n5 == Integer.MAX_VALUE) {
                this.fldMaxExtents.setNumber(null);
                this.chkUnlimited.setSelected(true);
                this.fldMaxExtents.setEnabled(false);
            } else {
                this.fldMaxExtents.setNumber(n5);
                this.chkUnlimited.setSelected(false);
            }
            this.fldPctIncrease.setNumber(oracleStorageProperties.getPercentIncrease());
            this.fldFreeLists.setNumber(oracleStorageProperties.getFreelists());
            this.fldFreeListGroups.setNumber(oracleStorageProperties.getFreelistGroups());
            string = StorageInfoPanel.getBufferOptionLabel(oracleStorageProperties.getBufferMode());
            this.cmbBufferPool.setSelectedItem(string);
            Boolean bl = oracleStorageProperties.getLogging();
            int n6 = bl == null ? 0 : (bl != false ? 1 : 2);
            this.cmbLogging.setSelectedIndex(n6);
        }
    }

    protected void commit(OracleStorageProperties oracleStorageProperties, boolean bl) throws TraversalException {
        Integer n;
        String string = (String)this.mdlTablespace.getSelectedItem();
        if (DEFAULT_OPTION.equals(string)) {
            string = null;
        }
        Integer n2 = (Integer)this.fldPctFree.getNumber();
        Integer n3 = (Integer)this.fldPctUsed.getNumber();
        Integer n4 = (Integer)this.fldIniTrans.getNumber();
        Integer n5 = (Integer)this.fldMaxTrans.getNumber();
        Integer n6 = (Integer)this.fldInitExtents.getNumber();
        if (n6 != null) {
            switch (this.cmbInitExtents.getSelectedIndex()) {
                case 1: {
                    n6 = new Integer(n6 * 1024);
                    break;
                }
                case 2: {
                    n6 = new Integer(n6 * 0x100000);
                }
            }
        }
        if ((n = (Integer)this.fldNextExtents.getNumber()) != null) {
            switch (this.cmbNextExtents.getSelectedIndex()) {
                case 1: {
                    n = new Integer(n * 1024);
                    break;
                }
                case 2: {
                    n = new Integer(n * 0x100000);
                }
            }
        }
        Integer n7 = (Integer)this.fldMinExtents.getNumber();
        Integer n8 = this.chkUnlimited.isSelected() ? new Integer(Integer.MAX_VALUE) : (Integer)this.fldMaxExtents.getNumber();
        Integer n9 = (Integer)this.fldPctIncrease.getNumber();
        Integer n10 = (Integer)this.fldFreeLists.getNumber();
        Integer n11 = (Integer)this.fldFreeListGroups.getNumber();
        int n12 = this.cmbBufferPool.getSelectedIndex();
        Boolean bl2 = null;
        switch (this.cmbLogging.getSelectedIndex()) {
            case 1: {
                bl2 = Boolean.TRUE;
                break;
            }
            case 2: {
                bl2 = Boolean.FALSE;
            }
        }
        oracleStorageProperties.setTablespace(string);
        oracleStorageProperties.setPercentFree(n2);
        oracleStorageProperties.setPercentUsed(n3);
        oracleStorageProperties.setInitrans(n4);
        oracleStorageProperties.setMaxtrans(n5);
        oracleStorageProperties.setInitialExtent(n6);
        oracleStorageProperties.setNextExtent(n);
        oracleStorageProperties.setMinExtent(n7);
        oracleStorageProperties.setMaxExtent(n8);
        oracleStorageProperties.setPercentIncrease(n9);
        oracleStorageProperties.setFreelists(n10);
        oracleStorageProperties.setFreelistGroups(n11);
        oracleStorageProperties.setBufferMode(n12);
        oracleStorageProperties.setLogging(bl2);
        StorageInfoVerifier storageInfoVerifier = (StorageInfoVerifier)this.getVerifier();
        if (bl && storageInfoVerifier != null) {
            storageInfoVerifier.verifyRelation();
        }
    }

    public static String getBufferOptionLabel(int n) {
        return BUFFER_OPTIONS[n];
    }

    public static int getBufferOption(String string) {
        if (BUFFER_OPTIONS[1].equalsIgnoreCase(string)) {
            return 1;
        }
        if (BUFFER_OPTIONS[2].equalsIgnoreCase(string)) {
            return 2;
        }
        return 0;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.fldMaxExtents.setEnabled(this.chkUnlimited.isSelected() ^ true);
    }

    protected void setTopLabelText(String string) {
        this.lblTop.setText(string);
        if (string == null) {
            this.remove((Component)this.lblTop);
        }
    }

    protected void enableAllComponents(boolean bl, boolean bl2) {
        this.chkUnlimited.setEnabled(bl);
        this.cmbBufferPool.setEnabled(bl);
        this.cmbInitExtents.setEnabled(bl);
        this.cmbLogging.setEnabled(bl);
        this.cmbNextExtents.setEnabled(bl);
        this.cmbTablespace.setEnabled(bl);
        this.fldFreeListGroups.setEnabled(bl);
        this.fldFreeLists.setEnabled(bl);
        this.fldIniTrans.setEnabled(bl);
        this.fldInitExtents.setEnabled(bl);
        this.fldMaxExtents.setEnabled(bl);
        this.fldMaxTrans.setEnabled(bl);
        this.fldMinExtents.setEnabled(bl);
        this.fldNextExtents.setEnabled(bl);
        this.fldPctFree.setEnabled(bl);
        this.fldPctIncrease.setEnabled(bl);
        this.fldPctUsed.setEnabled(bl);
        if (bl || bl2) {
            this.lblBufferPool.setEnabled(bl);
            this.lblFreeListGroups.setEnabled(bl);
            this.lblFreeLists.setEnabled(bl);
            this.lblIniTrans.setEnabled(bl);
            this.lblInitExtents.setEnabled(bl);
            this.lblLogging.setEnabled(bl);
            this.lblMaxExtents.setEnabled(bl);
            this.lblMaxTrans.setEnabled(bl);
            this.lblMinExtents.setEnabled(bl);
            this.lblNextExtents.setEnabled(bl);
            this.lblPctFree.setEnabled(bl);
            this.lblPctIncrease.setEnabled(bl);
            this.lblPctUsed.setEnabled(bl);
            this.lblTablespace.setEnabled(bl);
            this.pnlExtents.setEnabled(bl);
            this.pnlFreeLists.setEnabled(bl);
        }
    }

    private static class StorageNumberField
    extends NumberTextField {
        private int _maxValue;

        void $init$() {
            this._maxValue = Integer.MAX_VALUE;
        }

        public StorageNumberField() {
            this.$init$();
            this.setDataType(Integer.class);
            this.setSigned(false);
        }

        protected boolean validateNumber(Number number) {
            return number == null || number.intValue() >= 0 && number.intValue() <= this._maxValue;
        }

        public int getMaximumValue() {
            return this._maxValue;
        }

        public void setMaximumValue(int n) {
            this._maxValue = n;
        }
    }
}

