/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.ui.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.Step;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.jdeveloper.cm.dt.ui.BaseInfoPanel;
import oracle.jdeveloper.cm.dt.ui.relation.RelationInfoPanel;
import oracle.jdeveloper.cm.dt.ui.table.TableTypePanel;
import oracle.jdeveloper.cm.dt.verifier.table.TableInfoVerifier;
import oracle.jdevimpl.cm.dt.wizards.table.TablePanelLibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableInfoPanel
extends BaseInfoPanel
implements ActionListener {
    private RelationInfoPanel m_relPanel;
    private TableTypePanel m_tableTypePanel;
    private WizardCallbacks m_wizCallbacks;
    private TablePanelLibrary m_panels;
    private FSM m_fsm;
    private Table.TableType m_lastType;

    void $init$() {
        this.m_relPanel = new RelationInfoPanel();
        this.m_tableTypePanel = new TableTypePanel(true);
    }

    public TableInfoPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.m_tableTypePanel.addActionListener(this);
        this.setLayout(new BorderLayout(0, 5));
        this.add((Component)((Object)this.m_relPanel), "Center");
        this.add(this.m_tableTypePanel, "South");
    }

    public void onEntry(TraversableContext traversableContext) {
        DBObjectProvider dBObjectProvider = (DBObjectProvider)traversableContext.find("DBObjectProvider");
        Table table = (Table)traversableContext.find("NewObject");
        TableInfoVerifier tableInfoVerifier = (TableInfoVerifier)traversableContext.find("TableInfoVerifier");
        Schema[] schemaArray = (Schema[])traversableContext.find("SchemaList");
        this.m_panels = (TablePanelLibrary)traversableContext.find("PANEL_LIBRARY");
        this.init(dBObjectProvider, table, tableInfoVerifier, schemaArray);
        this.m_wizCallbacks = traversableContext.getWizardCallbacks();
        if (this.m_wizCallbacks != null) {
            this.m_wizCallbacks.wizardEnableButtons(Boolean.TRUE, Boolean.TRUE, Boolean.FALSE);
            this.m_relPanel.checkCallbacks(this.m_wizCallbacks);
            this.m_wizCallbacks.wizardUpdateExpectedTransition(this.getExitTransition());
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.commit((Table)traversableContext.find("OriginalObject"), (Table)traversableContext.find("NewObject"), (Schema[])traversableContext.find("SchemaList"), traversableContext.getDirection() != 2);
    }

    protected void init(DBObjectProvider dBObjectProvider, Table table, TableInfoVerifier tableInfoVerifier, Schema[] schemaArray) {
        super.init(dBObjectProvider, tableInfoVerifier);
        this.m_relPanel.init(dBObjectProvider, (Relation)table, tableInfoVerifier, schemaArray);
        Table.TableType tableType = (Table.TableType)table.getProperty("TableType", (Object)Table.TableType.NORMAL);
        this.m_tableTypePanel.setTableType(tableType);
        if (tableInfoVerifier != null && !tableInfoVerifier.canChangeTempState()) {
            this.m_tableTypePanel.enableAllComponents(false);
        }
    }

    protected void commit(Table table, Table table2, Schema[] schemaArray, boolean bl) throws TraversalException {
        this.m_relPanel.commit((Relation)table2, schemaArray, bl);
        TableInfoVerifier tableInfoVerifier = (TableInfoVerifier)this.getVerifier();
        DBObjectProvider dBObjectProvider = this.getProvider();
        if (tableInfoVerifier.canChangeTempState()) {
            Table.TableType tableType = this.m_tableTypePanel.getTableType();
            table2.setProperty("TableType", (Object)tableType);
        }
        if (bl && tableInfoVerifier != null) {
            tableInfoVerifier.verifyRelation();
        }
    }

    public void setOwnerLabel(String string) {
        this.m_relPanel.setOwnerLabel(string);
    }

    public void setTopLabel(String string) {
        this.m_relPanel.setTopLabel(string);
    }

    public Object getExitTransition() {
        Table.TableType tableType = this.m_tableTypePanel.getTableType();
        if (this.m_fsm != null && this.m_lastType == tableType) {
            return this.m_fsm;
        }
        this.m_lastType = tableType;
        this.m_fsm = FSMBuilder.newFSM((Step[])this.m_panels.getCreateSteps(tableType, this.getProvider()));
        return this.m_fsm;
    }

    protected Map<Class, String> getHelpMap() {
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.m_wizCallbacks != null) {
            this.m_wizCallbacks.wizardUpdateExpectedTransition(this.getExitTransition());
        }
    }
}

