/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.ui.view;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.View;
import oracle.jdeveloper.cm.dt.ui.BaseInfoPanel;
import oracle.jdeveloper.cm.dt.ui.relation.RelationInfoPanel;
import oracle.jdeveloper.cm.dt.verifier.view.ViewInfoVerifier;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class ViewInfoPanel
extends BaseInfoPanel
implements ActionListener {
    private RelationInfoPanel m_relPanel;
    private JRadioButton m_readOnly;
    private JRadioButton m_checkOption;
    private JCheckBox m_restrict;
    private JCheckBox m_force;

    void $init$() {
        this.m_relPanel = new RelationInfoPanel();
        this.m_readOnly = new JRadioButton();
        this.m_checkOption = new JRadioButton();
        this.m_restrict = new JCheckBox();
        this.m_force = new JCheckBox();
    }

    public ViewInfoPanel() {
        this.$init$();
        this.setLayout(new GridBagLayout());
        this.add((Component)((Object)this.m_relPanel), new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 15, 0), 0, 0));
        ResourceUtils.resButton((AbstractButton)this.m_restrict, (String)CmWizardsArb.getString(297));
        this.add(this.m_restrict, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        ResourceUtils.resButton((AbstractButton)this.m_readOnly, (String)CmWizardsArb.getString(298));
        this.add(this.m_readOnly, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 30, 5, 0), 0, 0));
        ResourceUtils.resButton((AbstractButton)this.m_checkOption, (String)CmWizardsArb.getString(299));
        this.add(this.m_checkOption, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 30, 5, 0), 0, 0));
        ResourceUtils.resButton((AbstractButton)this.m_force, (String)CmWizardsArb.getString(300));
        this.add(this.m_force, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_readOnly);
        buttonGroup.add(this.m_checkOption);
        this.m_readOnly.setSelected(true);
        this.m_restrict.setSelected(false);
        this.m_readOnly.setEnabled(false);
        this.m_checkOption.setEnabled(false);
        this.m_restrict.addActionListener(this);
    }

    public void onEntry(TraversableContext traversableContext) {
        DBObjectProvider dBObjectProvider = (DBObjectProvider)traversableContext.find("DBObjectProvider");
        View view = (View)traversableContext.find("NewObject");
        ViewInfoVerifier viewInfoVerifier = (ViewInfoVerifier)traversableContext.find("ViewInfoVerifier");
        Schema[] schemaArray = (Schema[])traversableContext.find("SchemaList");
        this.init(dBObjectProvider, view, viewInfoVerifier, schemaArray);
        WizardCallbacks wizardCallbacks = traversableContext.getWizardCallbacks();
        if (wizardCallbacks != null) {
            wizardCallbacks.wizardEnableButtons(Boolean.TRUE, Boolean.TRUE, Boolean.FALSE);
            this.m_relPanel.checkCallbacks(wizardCallbacks);
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.commit((View)traversableContext.find("NewObject"), (Schema[])traversableContext.find("SchemaList"), traversableContext.getDirection() != 2);
    }

    protected void init(DBObjectProvider dBObjectProvider, View view, ViewInfoVerifier viewInfoVerifier, Schema[] schemaArray) {
        super.init(dBObjectProvider, viewInfoVerifier);
        this.m_relPanel.init(dBObjectProvider, (Relation)view, viewInfoVerifier, schemaArray);
        String string = view.getQueryRestriction();
        if (string != null) {
            this.m_restrict.setSelected(true);
            this.m_readOnly.setEnabled(true);
            this.m_checkOption.setEnabled(true);
            if (string.equalsIgnoreCase("WITH READ ONLY")) {
                this.m_readOnly.setSelected(true);
            } else {
                this.m_checkOption.setSelected(true);
            }
        }
        this.m_force.setSelected(view.isForceOnCreate());
        if (viewInfoVerifier != null) {
            this.m_restrict.setEnabled(viewInfoVerifier.canChangeQueryRestriction());
            this.m_readOnly.setEnabled(this.m_restrict.isSelected() && viewInfoVerifier.canChangeQueryRestriction());
            this.m_checkOption.setEnabled(this.m_restrict.isSelected() && viewInfoVerifier.canChangeQueryRestriction());
            this.m_force.setEnabled(viewInfoVerifier.canChangeQueryRestriction());
        }
    }

    protected void commit(View view, Schema[] schemaArray, boolean bl) throws TraversalException {
        this.m_relPanel.commit((Relation)view, schemaArray, bl);
        if (this.m_restrict.isSelected()) {
            view.setQueryRestriction(this.m_readOnly.isSelected() ? "WITH READ ONLY" : "WITH CHECK OPTION");
        } else {
            view.setQueryRestriction(null);
        }
        view.setForceOnCreate(this.m_force.isSelected());
    }

    protected void setOwnerLabel(String string) {
        this.m_relPanel.setOwnerLabel(string);
    }

    protected void setTopLabel(String string) {
        this.m_relPanel.setTopLabel(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_restrict) {
            if (this.m_restrict.isSelected()) {
                this.m_readOnly.setEnabled(true);
                this.m_checkOption.setEnabled(true);
            } else {
                this.m_readOnly.setEnabled(false);
                this.m_checkOption.setEnabled(false);
            }
        }
    }
}

