/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.verifier.index;

import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Index;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.jdeveloper.cm.dt.verifier.AbstractSchemaObjectVerifier;
import oracle.jdeveloper.cm.dt.verifier.table.IndexInfoVerifier;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class AbstractTopLevelIndexVerifier
extends AbstractSchemaObjectVerifier
implements IndexInfoVerifier {
    protected String getErrorTitle() {
        return CmWizardsArb.format(411, this.getModifiedRelationName());
    }

    protected String getInvalidNameMessage(String string) {
        return CmWizardsArb.format(ModelUtil.hasLength((String)string) ? 412 : 413, string);
    }

    protected String getChildType() {
        return "INDEX";
    }

    public void verifyRelation() {
    }

    public void verifyIndex(Index index, Index index2) throws TraversalException {
        try {
            this.getProvider().validateObject((DBObject)index, (DBObject)index2);
        }
        catch (ValidationException validationException) {
            this.processValidationException(validationException);
        }
    }

    public boolean canRenameIndex(Index index) {
        return ((Index)this.getModifiedObject()).getTable() == null;
    }

    public boolean canRemoveIndexes() {
        return false;
    }

    public boolean canRemoveIndex(Index index) {
        return false;
    }

    public boolean canReorderIndexes() {
        return false;
    }

    public boolean canMoveIndexUp(Index index) {
        return false;
    }

    public boolean canMoveIndexDown(Index index) {
        return false;
    }

    public boolean canAddIndexes() {
        return this.getOriginalTable() == null;
    }

    public boolean canAddIndex(Index index) {
        return this.getOriginalTable() == null;
    }

    public boolean canEditIndex(Index index) {
        return this.getOriginalTable() == null;
    }

    protected String getModifiedRelationName() {
        String string = "";
        SchemaObject schemaObject = this.getModifiedObject();
        if (schemaObject != null) {
            schemaObject = ((Index)schemaObject).getTable();
        }
        if (schemaObject != null) {
            string = schemaObject.getName();
        }
        return string;
    }

    protected Table getOriginalTable() {
        Table table = null;
        Index index = (Index)this.getOriginalObject();
        if (index != null) {
            table = index.getTable();
        }
        return table;
    }

    protected Table getModifiedTable() {
        Index index = (Index)this.getModifiedObject();
        return index.getTable();
    }
}

