/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.wizard;

import java.awt.Component;
import java.net.URL;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.EditorUtil;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.wizard.GenericWizardLauncher;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.browser.CBBaseFolder;
import oracle.jdeveloper.cm.dt.browser.jdbc.JdbcNodeFactory;
import oracle.jdeveloper.cm.dt.dialog.SQLErrorDialog;
import oracle.jdeveloper.cm.dt.ui.UIConstants;
import oracle.jdeveloper.cm.dt.verifier.Verifier;
import oracle.jdevimpl.cm.dt.browser.jdbc.JdbcBrowser;

public abstract class DBWizardLauncher
extends GenericWizardLauncher
implements UIConstants {
    public static final String DDL_GENERATOR = "DDlGenerator";
    private Map _verifiers;

    void $init$() {
        this._verifiers = new HashMap();
    }

    public DBWizardLauncher(Context context, Database database, String string) {
        super(context, string);
        this.$init$();
        this.setWizardImage(ConnectionArb.getImage(91));
        this.put("DBObjectProvider", database);
        Locatable locatable = (Locatable)context.getElement();
        try {
            Schema schema = DBWizardLauncher.determineSchema(context, database);
            if (schema != null) {
                this.put("Schema", schema);
            }
            Schema[] schemaArray = database.listSchemas();
            this.put("SchemaList", schemaArray);
        }
        catch (DBException dBException) {
            Throwable throwable = dBException.getCause();
            if (throwable instanceof SQLException) {
                SQLErrorDialog.showErrorDialog(null, "Error Getting Schema List", (SQLException)throwable);
            }
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)(throwable != null ? throwable : dBException), (String)"Error Getting Schema List", (String)"An error was encountered trying to get the list of schemas.", null);
        }
    }

    public final void put(String string, Object object) {
        this.getNamespace().put(string, object);
    }

    public final Object get(String string) {
        return this.getNamespace().get(string);
    }

    public final Object find(String string) {
        return this.getNamespace().find(string);
    }

    public void registerVerifier(String string, Class clazz) {
        this._verifiers.put(string, clazz);
    }

    public void unregisterVerifier(String string) {
        this._verifiers.remove(string);
    }

    protected Node createNode(String string, String string2, String string3, boolean bl) {
        return DBWizardLauncher.createNode((Context)this.find("Context"), (Database)this.find("DBObjectProvider"), string, string2, string3, bl);
    }

    public final boolean runWizard() {
        DBObjectProvider dBObjectProvider = (DBObjectProvider)this.get("DBObjectProvider");
        SchemaObject schemaObject = (SchemaObject)this.get("OriginalObject");
        SchemaObject schemaObject2 = (SchemaObject)this.get("NewObject");
        for (String string : this._verifiers.keySet()) {
            Class clazz = (Class)this._verifiers.get(string);
            try {
                Verifier verifier = (Verifier)clazz.newInstance();
                verifier.initializeVerifier(dBObjectProvider, schemaObject, schemaObject2);
                this.put(string, verifier);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.runWizardImpl();
    }

    protected abstract boolean runWizardImpl();

    public static Schema determineSchema(Context context, Database database) throws DBException {
        URL uRL = DBWizardLauncher._getURL(context);
        String string = CmUtil.getSchema(uRL);
        if (string == null) {
            string = database.getUserName();
        }
        return database.getSchema(string);
    }

    public static Node createNode(Context context, Database database, String string, String string2, String string3, boolean bl) {
        Node node;
        URL uRL;
        CBBaseFolder cBBaseFolder;
        Node node2 = null;
        String string4 = CmUtil.getConnName(DBWizardLauncher._getURL(context));
        JdbcBrowser jdbcBrowser = JdbcBrowser.getBrowser(CmUtil.getConnectionNode(CmUtil.newCmURL(string4)));
        if (jdbcBrowser != null && (cBBaseFolder = jdbcBrowser.getNodeByType(string, string3)) != null && (uRL = CmUtil.getNodeURL(string4, null, string, string3, string2)) != null && (node = JdbcNodeFactory.getNode(database, uRL)) != null) {
            cBBaseFolder.add((Element)node);
            UpdateMessage.fireChildAdded((Subject)cBBaseFolder, (Element)node);
            if (bl) {
                SwingUtilities.invokeLater(new 1(node));
            }
            node2 = node;
        }
        return node2;
    }

    private static URL _getURL(Context context) {
        Locatable locatable = (Locatable)context.getElement();
        return locatable.getURL();
    }

    public static final class 1
    implements Runnable {
        private final /* synthetic */ Node v$node;

        public void run() {
            EditorUtil.openDefaultEditorInFrame((Node)this.v$node);
        }

        public 1(Node node) {
            this.v$node = node;
        }
    }
}

