/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.ds.db.insight;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import oracle.javatools.db.Database;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.ds.db.DatabaseFactory;
import oracle.jdeveloper.cm.ds.db.insight.BaseInsightableItem;
import oracle.jdeveloper.cm.ds.db.insight.InsightableDatabase;

public final class InsightableOracleDatabase
implements InsightableDatabase {
    private Connection _conn;
    private OracleDatabase _db;
    private BaseInsightableItem _tree;
    private volatile boolean _canceled;
    private static final String PUBLIC_SCHEMA = "PUBLIC";
    private static final String SQL_LIST_SCHEMAS = "SELECT username FROM all_users ORDER BY username";
    private static final String SQL_ALL_OBJECT_LIST = "SELECT owner, object_name, object_type FROM all_objects WHERE object_type IN ('PACKAGE', 'PROCEDURE', 'SEQUENCE', 'TABLE', 'TYPE', 'VIEW', 'FUNCTION' ) ORDER BY owner, object_name";
    private static final String SQL_ALL_SYNONYM_LIST = "SELECT s.owner, s.synonym_name, 'SYNONYM' as object_type FROM all_synonyms s, all_objects o WHERE s.table_name = o.object_name AND s.table_owner = o.owner AND object_type IN ('PACKAGE', 'PROCEDURE', 'SEQUENCE', 'TABLE', 'TYPE', 'VIEW', 'FUNCTION' ) ORDER BY s.owner, s.synonym_name";
    private static final String SQL_COLUMNS_FOR_TABLE = "SELECT column_name FROM all_tab_columns WHERE owner = ? and table_name = ?";
    private static final String SQL_RESOLVE_SYNONYM = "select o.owner, o.object_name, o.object_type from all_objects o, all_synonyms s where s.table_name = o.object_name and s.table_owner = o.owner and s.synonym_name = ?";
    private static final String SQL_LIST_PACKAGE_SUBPROGRAMS = "select object_name, decode( min( position ), 0, 'FUNCTION', 1, 'PROCEDURE', 'PROCEDURE' ) from all_arguments WHERE owner = ? AND package_name = ? group by object_name";
    private static final String SQL_LIST_OBJECT_METHODS = "select method_name, decode( results, 0, 'PROCEDURE', 1, 'FUNCTION', 'PROCEDURE' ) from all_type_methods where owner=? and type_name=? and method_type = 'PUBLIC'";
    private static final String SQL_LIST_OBJECT_ATTRIBUTES = "select attr_name from all_type_attrs where owner = ? and type_name = ?";
    private static final String[] EMPTY_ARGS = new String[0];

    public InsightableOracleDatabase(OracleDatabase oracleDatabase) {
        this._db = oracleDatabase;
        try {
            this._conn = DatabaseFactory.getConnection(this._db.getConnectionName());
        }
        catch (CMException cMException) {
            // empty catch block
        }
        if (this._conn == null) {
            this._conn = this._db.getConnection();
        }
    }

    public void close() {
        1 var1_1 = new 1();
        this._canceled = true;
        Thread thread = new Thread((Runnable)var1_1, "Insight Close Thread");
        thread.start();
    }

    public Database getDatabase() {
        return this._db;
    }

    public BaseInsightableItem buildInsightableObjectTree() {
        if (this._tree == null) {
            this._tree = this._buildTree();
        }
        return this._tree;
    }

    public boolean loadChildren(BaseInsightableItem baseInsightableItem) {
        block1: {
            String string;
            block4: {
                block3: {
                    block2: {
                        block0: {
                            string = baseInsightableItem.getType();
                            if (!"TABLE".equals(string) && !"VIEW".equals(string)) break block0;
                            this._loadColumns(baseInsightableItem);
                            break block1;
                        }
                        if (!"SYNONYM".equals(string)) break block2;
                        BaseInsightableItem baseInsightableItem2 = this._resolveSynonym(baseInsightableItem);
                        if (baseInsightableItem2 == null) break block1;
                        this.loadChildren(baseInsightableItem2);
                        baseInsightableItem2.copyChildrenTo(baseInsightableItem);
                        break block1;
                    }
                    if (!"SEQUENCE".equals(string)) break block3;
                    this._loadSequence(baseInsightableItem);
                    break block1;
                }
                if (!"PACKAGE".equals(string)) break block4;
                this._loadPackage(baseInsightableItem);
                break block1;
            }
            if (!"TYPE".equals(string)) break block1;
            this._loadObject(baseInsightableItem);
        }
        return true;
    }

    private BaseInsightableItem _buildTree() {
        BaseInsightableItem baseInsightableItem;
        try {
            BaseInsightableItem baseInsightableItem2 = new BaseInsightableItem(null, "", "");
            this._addSchemas(baseInsightableItem2);
            this._addAllObjects(baseInsightableItem2);
            InsightableOracleDatabase._addTopLevelPseudo(baseInsightableItem2);
            this._addNumericBuiltinFunctions(baseInsightableItem2);
            this._addStringBuiltinFunctions(baseInsightableItem2);
            baseInsightableItem = baseInsightableItem2;
        }
        catch (SQLException sQLException) {
            boolean bl = false;
            try {
                bl = this._conn.isClosed();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            if (!bl) {
                // empty if block
            }
            baseInsightableItem = new BaseInsightableItem(null, "", "");
        }
        return baseInsightableItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addSchemas(BaseInsightableItem baseInsightableItem) throws SQLException {
        baseInsightableItem.putChild(new BaseInsightableItem("SCHEMA", PUBLIC_SCHEMA, PUBLIC_SCHEMA));
        Connection connection = this._conn;
        synchronized (connection) {
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = this.prepareCall(SQL_LIST_SCHEMAS);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    if (this._canceled) {
                        break;
                    }
                    String string = resultSet.getString(1);
                    baseInsightableItem.putChild(new BaseInsightableItem("SCHEMA", string, string));
                }
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    private void _addAllObjects(BaseInsightableItem baseInsightableItem) throws SQLException {
        this._addAllNonSynonyms(baseInsightableItem);
        this._addAllSynonyms(baseInsightableItem);
    }

    private static void _addTopLevelPseudo(BaseInsightableItem baseInsightableItem) {
        BaseInsightableItem baseInsightableItem2 = baseInsightableItem.getChild(PUBLIC_SCHEMA);
        BaseInsightableItem baseInsightableItem3 = new BaseInsightableItem("FUNCTION", PUBLIC_SCHEMA, "SYSDATE");
        baseInsightableItem2.putChild(baseInsightableItem3);
        baseInsightableItem3 = new BaseInsightableItem("FUNCTION", PUBLIC_SCHEMA, "USER");
        baseInsightableItem2.putChild(baseInsightableItem3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addAllNonSynonyms(BaseInsightableItem baseInsightableItem) throws SQLException {
        Connection connection = this._conn;
        synchronized (connection) {
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                try {
                    preparedStatement = this.prepareCall(SQL_ALL_OBJECT_LIST);
                    resultSet = preparedStatement.executeQuery();
                    BaseInsightableItem baseInsightableItem2 = baseInsightableItem;
                    while (resultSet.next()) {
                        if (this._canceled) {
                            break;
                        }
                        String string = resultSet.getString(1);
                        String string2 = resultSet.getString(2);
                        String string3 = resultSet.getString(3);
                        BaseInsightableItem baseInsightableItem3 = new BaseInsightableItem(string3, string, string2);
                        if (string == null) continue;
                        if (baseInsightableItem2 == null || !string.equals(baseInsightableItem2.getSchema())) {
                            baseInsightableItem2 = baseInsightableItem.getChild(string);
                        }
                        if (baseInsightableItem2 == null) continue;
                        baseInsightableItem2.putChild(baseInsightableItem3);
                    }
                }
                catch (RuntimeException runtimeException) {
                    throw new SQLException(runtimeException.getLocalizedMessage());
                }
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addAllSynonyms(BaseInsightableItem baseInsightableItem) throws SQLException {
        Connection connection = this._conn;
        synchronized (connection) {
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                try {
                    preparedStatement = this.prepareCall(SQL_ALL_SYNONYM_LIST);
                    resultSet = preparedStatement.executeQuery();
                    BaseInsightableItem baseInsightableItem2 = baseInsightableItem;
                    while (resultSet.next()) {
                        if (this._canceled) {
                            break;
                        }
                        String string = resultSet.getString(1);
                        String string2 = resultSet.getString(2);
                        String string3 = resultSet.getString(3);
                        BaseInsightableItem baseInsightableItem3 = new BaseInsightableItem(string3, string, string2);
                        if (string == null) continue;
                        if (baseInsightableItem2 == null || !string.equals(baseInsightableItem2.getSchema())) {
                            baseInsightableItem2 = baseInsightableItem.getChild(string);
                        }
                        if (baseInsightableItem2 == null) continue;
                        baseInsightableItem2.putChild(baseInsightableItem3);
                    }
                }
                catch (RuntimeException runtimeException) {
                    throw new SQLException(runtimeException.getLocalizedMessage());
                }
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addNumericBuiltinFunctions(BaseInsightableItem baseInsightableItem) throws SQLException {
        Connection connection = this._conn;
        synchronized (connection) {
            try {
                DatabaseMetaData databaseMetaData = this._conn.getMetaData();
                BaseInsightableItem baseInsightableItem2 = baseInsightableItem.getChild(PUBLIC_SCHEMA);
                String string = databaseMetaData.getNumericFunctions();
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
                String string2 = "FUNCTION";
                while (stringTokenizer.hasMoreTokens()) {
                    if (!this._canceled) {
                        String string3 = stringTokenizer.nextToken();
                        BaseInsightableItem baseInsightableItem3 = new BaseInsightableItem("FUNCTION", PUBLIC_SCHEMA, string3);
                        baseInsightableItem2.putChild(baseInsightableItem3);
                        continue;
                    }
                    break;
                }
            }
            catch (RuntimeException runtimeException) {
                throw new SQLException(runtimeException.getLocalizedMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addStringBuiltinFunctions(BaseInsightableItem baseInsightableItem) throws SQLException {
        Connection connection = this._conn;
        synchronized (connection) {
            try {
                DatabaseMetaData databaseMetaData = this._conn.getMetaData();
                BaseInsightableItem baseInsightableItem2 = baseInsightableItem.getChild(PUBLIC_SCHEMA);
                String string = databaseMetaData.getStringFunctions();
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
                String string2 = "FUNCTION";
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    BaseInsightableItem baseInsightableItem3 = new BaseInsightableItem("FUNCTION", PUBLIC_SCHEMA, string3);
                    baseInsightableItem2.putChild(baseInsightableItem3);
                }
            }
            catch (RuntimeException runtimeException) {
                throw new SQLException(runtimeException.getLocalizedMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseInsightableItem _resolveSynonym(BaseInsightableItem baseInsightableItem) {
        BaseInsightableItem baseInsightableItem2 = null;
        Connection connection = this._conn;
        synchronized (connection) {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                try {
                    statement = this.prepareCall(SQL_RESOLVE_SYNONYM, new String[]{baseInsightableItem.getName()});
                    resultSet = statement.executeQuery();
                    if (resultSet.next()) {
                        String string = resultSet.getString(1);
                        String string2 = resultSet.getString(2);
                        String string3 = resultSet.getString(3);
                        baseInsightableItem2 = new BaseInsightableItem(string3, string, string2);
                    }
                }
                catch (SQLException sQLException) {
                }
                catch (Exception exception) {}
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return baseInsightableItem2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _loadColumns(BaseInsightableItem baseInsightableItem) {
        Connection connection = this._conn;
        synchronized (connection) {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                try {
                    statement = this.prepareCall(SQL_COLUMNS_FOR_TABLE, new String[]{baseInsightableItem.getSchema(), baseInsightableItem.getName()});
                    resultSet = statement.executeQuery();
                    String string = "COLUMN";
                    String string2 = baseInsightableItem.getSchema();
                    while (resultSet.next()) {
                        if (this._canceled) break;
                        String string3 = resultSet.getString(1);
                        BaseInsightableItem baseInsightableItem2 = new BaseInsightableItem("COLUMN", string2, string3);
                        baseInsightableItem.putChild(baseInsightableItem2);
                    }
                    BaseInsightableItem baseInsightableItem3 = new BaseInsightableItem("COLUMN", string2, "ROWID");
                    baseInsightableItem.putChild(baseInsightableItem3);
                }
                catch (SQLException sQLException) {
                    boolean bl = false;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return bl;
                }
                catch (Exception exception) {
                    boolean bl = false;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                    return bl;
                }
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    private boolean _loadSequence(BaseInsightableItem baseInsightableItem) {
        String string = "COLUMN";
        String string2 = baseInsightableItem.getSchema();
        String string3 = "CURVAL";
        BaseInsightableItem baseInsightableItem2 = new BaseInsightableItem("COLUMN", string2, string3);
        baseInsightableItem.putChild(baseInsightableItem2);
        string3 = "NEXTVAL";
        baseInsightableItem2 = new BaseInsightableItem("COLUMN", string2, string3);
        baseInsightableItem.putChild(baseInsightableItem2);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _loadPackage(BaseInsightableItem baseInsightableItem) {
        Connection connection = this._conn;
        synchronized (connection) {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                try {
                    statement = this.prepareCall(SQL_LIST_PACKAGE_SUBPROGRAMS, new String[]{baseInsightableItem.getSchema(), baseInsightableItem.getName()});
                    resultSet = statement.executeQuery();
                    String string = baseInsightableItem.getSchema();
                    while (resultSet.next()) {
                        if (this._canceled) {
                            break;
                        }
                        String string2 = resultSet.getString(1);
                        String string3 = resultSet.getString(2);
                        BaseInsightableItem baseInsightableItem2 = new BaseInsightableItem(string3, string, string2);
                        baseInsightableItem.putChild(baseInsightableItem2);
                    }
                }
                catch (SQLException sQLException) {
                    boolean bl = false;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return bl;
                }
                catch (Exception exception) {
                    boolean bl = false;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                    return bl;
                }
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    private boolean _loadObject(BaseInsightableItem baseInsightableItem) {
        boolean bl = this._loadObjectAttributes(baseInsightableItem);
        boolean bl2 = this._loadObjectMethods(baseInsightableItem);
        return bl && bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _loadObjectMethods(BaseInsightableItem baseInsightableItem) {
        Connection connection = this._conn;
        synchronized (connection) {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                try {
                    statement = this.prepareCall(SQL_LIST_OBJECT_METHODS, new String[]{baseInsightableItem.getSchema(), baseInsightableItem.getName()});
                    resultSet = statement.executeQuery();
                    String string = baseInsightableItem.getSchema();
                    while (resultSet.next()) {
                        if (this._canceled) {
                            break;
                        }
                        String string2 = resultSet.getString(1);
                        String string3 = resultSet.getString(2);
                        BaseInsightableItem baseInsightableItem2 = new BaseInsightableItem(string3, string, string2);
                        baseInsightableItem.putChild(baseInsightableItem2);
                    }
                }
                catch (SQLException sQLException) {
                    boolean bl = false;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return bl;
                }
                catch (Exception exception) {
                    boolean bl = false;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                    return bl;
                }
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _loadObjectAttributes(BaseInsightableItem baseInsightableItem) {
        Connection connection = this._conn;
        synchronized (connection) {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                try {
                    statement = this.prepareCall(SQL_LIST_OBJECT_ATTRIBUTES, new String[]{baseInsightableItem.getSchema(), baseInsightableItem.getName()});
                    resultSet = statement.executeQuery();
                    String string = "COLUMN";
                    String string2 = baseInsightableItem.getSchema();
                    while (resultSet.next()) {
                        if (this._canceled) break;
                        String string3 = resultSet.getString(1);
                        BaseInsightableItem baseInsightableItem2 = new BaseInsightableItem("COLUMN", string2, string3);
                        baseInsightableItem.putChild(baseInsightableItem2);
                    }
                    BaseInsightableItem baseInsightableItem3 = new BaseInsightableItem("COLUMN", string2, "ROWID");
                    baseInsightableItem.putChild(baseInsightableItem3);
                }
                catch (SQLException sQLException) {
                    boolean bl = false;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return bl;
                }
                catch (Exception exception) {
                    boolean bl = false;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                    return bl;
                }
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    private PreparedStatement prepareCall(String string, String[] stringArray) throws SQLException {
        PreparedStatement preparedStatement = this._conn.prepareStatement(string);
        preparedStatement.setFetchSize(100);
        int n = 0;
        while (n < stringArray.length) {
            preparedStatement.setString(n + 1, stringArray[n]);
            ++n;
        }
        return preparedStatement;
    }

    private PreparedStatement prepareCall(String string) throws SQLException {
        return this.prepareCall(string, EMPTY_ARGS);
    }

    static Connection ra$_conn(InsightableOracleDatabase insightableOracleDatabase) {
        return insightableOracleDatabase._conn;
    }

    public final class 1
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Connection connection = InsightableOracleDatabase.ra$_conn(InsightableOracleDatabase.this);
            synchronized (connection) {
                try {
                    InsightableOracleDatabase.ra$_conn(InsightableOracleDatabase.this).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

