/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.Iterator;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.compiler.BuildSystemListener;
import oracle.ide.compiler.BuildSystemVetoException;
import oracle.ide.compiler.Compiler;
import oracle.ide.config.ClientSetting;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Project;
import oracle.ide.model.Recognizer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.net.IdeURLStreamHandlerFactory;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLPath;
import oracle.ide.util.ModelUtil;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.ProfileIDs;
import oracle.jdeveloper.ant.AntManager;
import oracle.jdeveloper.ant.AntNode;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionEvent;
import oracle.jdeveloper.cm.ConnectionListener;
import oracle.jdeveloper.cm.ConnectionManager;
import oracle.jdeveloper.cm.ConnectionStore;
import oracle.jdeveloper.cm.DefaultConnectionStore;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.ConnectionEditor;
import oracle.jdeveloper.cm.dt.ConnectionNode;
import oracle.jdeveloper.cm.dt.ConnectionsProvider;
import oracle.jdeveloper.cm.dt.config.BaseConnectionOptions;
import oracle.jdeveloper.cm.dt.net.CmURLStreamHandlerFactory;
import oracle.jdeveloper.cm.dt.net.JDevCmURLFileSystemHelper;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.profiler.ProfilerAPI;
import oracle.jdevimpl.cm.dt.ConnectionCommands;
import oracle.jdevimpl.cm.dt.ConnectionController;
import oracle.jdevimpl.cm.dt.ConnectionRecognizer;
import oracle.jdevimpl.cm.dt.cnpanels.ConnectionEditorImpl;
import oracle.jdevimpl.cm.dt.explorer.ConnectionExplorer;

public class BaseConnectionAddin
implements ConnectionListener,
BuildSystemListener,
Addin {
    private Context _buildContext;
    public static final String CONNECTIONS_FILE = "IDEConnections.xml";
    private ConnectionManager cm;
    private File propertiesFile;
    private ConnectionController _controller;
    private static BaseConnectionAddin _instance;

    public static BaseConnectionAddin getInstance() {
        return _instance;
    }

    public Controller getController() {
        return this._controller;
    }

    public BaseConnectionAddin() {
        _instance = this;
    }

    public void initialize() {
        IdeURLStreamHandlerFactory.addFactory((URLStreamHandlerFactory)new CmURLStreamHandlerFactory());
        URLFileSystem.registerHelper((String)"jdev.cm", (URLFileSystemHelper)JDevCmURLFileSystemHelper.getInstance());
        this._initializeConnectionManager();
        this._initializeController();
        ConnectionEditor.setConnectionEditorDelegateClass(ConnectionEditorImpl.class);
        Compiler compiler = Compiler.getCompiler();
        if (compiler != null) {
            compiler.addBuildSystemListener((BuildSystemListener)this);
        }
        Recognizer.registerLowPriorityRecognizer((Recognizer)new ConnectionRecognizer());
        ExplorerManager explorerManager = ExplorerManager.getExplorerManager();
        if (explorerManager != null) {
            Class<ConnectionExplorer> clazz = ConnectionExplorer.class;
            explorerManager.register(ConnectionNode.class, clazz, null, ConnectionArb.getString(574), null);
        }
    }

    private void _initializeConnectionManager() {
        int n = -1;
        if (ProfileIDs.PROFILE_INITCONMGR) {
            n = ProfilerAPI.startEvent((int)3402);
        }
        this.cm = ConnectionManager.getInstance();
        this.cm.setDefaultPrompter(null);
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
        URL uRL = extensionRegistry.getSystemDirectory("oracle.onlinedb");
        this.propertiesFile = new File(uRL.getPath(), CONNECTIONS_FILE);
        DefaultConnectionStore defaultConnectionStore = new DefaultConnectionStore(this.propertiesFile.getAbsolutePath(), true);
        this.cm.setConnectionStore((ConnectionStore)defaultConnectionStore);
        this.cm.addConnectionListener((ConnectionListener)this);
        if (ProfileIDs.PROFILE_INITCONMGR) {
            ProfilerAPI.endEvent((int)n);
        }
    }

    private void _initializeController() {
        this._controller = new ConnectionController();
        NavigatorManager navigatorManager = NavigatorManager.getConnectionNavigatorManager();
        navigatorManager.addContextMenuListener((ContextMenuListener)this._controller, null);
        ConnectionCommands.setActionsController(this._controller);
        ConnectionCommands.grabIdeActions(this._controller);
    }

    public void connectionAdded(ConnectionEvent connectionEvent) {
        ConnectionsProvider connectionsProvider = ConnectionsProvider.getInstance();
        ConnectionDescriptor connectionDescriptor = (ConnectionDescriptor)connectionEvent.getSource();
        connectionsProvider.addConnection(connectionDescriptor);
        this._saveDefinitions(true);
    }

    public void connectionRemoved(ConnectionEvent connectionEvent) {
        ConnectionDescriptor connectionDescriptor = (ConnectionDescriptor)connectionEvent.getSource();
        String string = connectionDescriptor.getConnectionName();
        ConnectionsProvider connectionsProvider = ConnectionsProvider.getInstance();
        ConnectionNode connectionNode = connectionsProvider.getConnectionNode(string);
        if (connectionNode.isConnected()) {
            ConnectionController.doDisconnect(connectionNode, null);
        }
        connectionsProvider.removeConnection(string);
        this._saveDefinitions(true);
    }

    public void connectionModified(ConnectionEvent connectionEvent) {
        ConnectionDescriptor connectionDescriptor;
        String string;
        ConnectionsProvider connectionsProvider = ConnectionsProvider.getInstance();
        ConnectionNode connectionNode = connectionsProvider.getConnectionNode(string = (connectionDescriptor = (ConnectionDescriptor)connectionEvent.getSource()).getConnectionName());
        if (connectionNode.isOpen()) {
            ConnectionController.doDisconnect(connectionNode, null);
        }
        connectionDescriptor = (ConnectionDescriptor)connectionEvent.getData();
        String string2 = connectionDescriptor.getConnectionName();
        connectionNode.setConnectionDescriptor(connectionDescriptor);
        this._saveDefinitions(true);
        UpdateMessage.fireStructureChanged((Subject)connectionNode);
        if (ModelUtil.areDifferent((Object)string, (Object)string2)) {
            UpdateMessage.fireObjectRenamed((Subject)connectionNode);
        }
    }

    public void connectionOpened(ConnectionEvent connectionEvent) {
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
    }

    public void buildWillStart(Context context) throws BuildSystemVetoException {
        this._buildContext = context;
    }

    public void buildFinished(int n, int n2, int n3) throws BuildSystemVetoException {
        if (n == 0) {
            if (this._buildContext == null) {
                return;
            }
            Element element = this._buildContext.getElement();
            if (element instanceof AntNode) {
                return;
            }
            Project project = this._buildContext.getProject();
            if (project != null) {
                this._saveDefinitionsForProject(project);
            } else if (element instanceof Workspaces) {
                this._saveDefinitionsForWorkspaces((Folder)element);
            } else if (element instanceof Workspace) {
                this._saveDefinitionsForWorkspace((Workspace)element);
            }
        }
    }

    private void _saveDefinitionsForWorkspaces(Folder folder) {
        Iterator iterator = folder.getChildren();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Workspace)) continue;
            Workspace workspace = (Workspace)e;
            this._saveDefinitionsForWorkspace(workspace);
        }
    }

    private void _saveDefinitionsForWorkspace(Workspace workspace) {
        Iterator iterator = workspace.getChildren();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Project)) continue;
            Project project = (Project)e;
            this._saveDefinitionsForProject(project);
        }
    }

    private void _saveDefinitionsForProject(Project project) {
        URL uRL;
        if (AntManager.getAntManager().getProjectBuildfile(project) != null) {
            return;
        }
        URLPath uRLPath = PathsConfiguration.getInstance((Project)project).getClassPath();
        if (uRLPath.toBoundURL("oracle/jdeveloper/cm/ConnectionManager.class") != null && (uRL = JavaProject.getInstance((Project)project).getOutputDirectory()) != null) {
            URL uRL2 = URLFactory.newURL((URL)uRL, (String)"connections.xml");
            String string = URLFileSystem.getPath((URL)uRL2);
            this._saveDefinitions(string, true, false);
        }
    }

    private void _saveDefinitions(boolean bl) {
        this._saveDefinitions(this.propertiesFile.getAbsolutePath(), BaseConnectionAddin.getOptions().isPersistPassword() ^ true, bl);
    }

    private static BaseConnectionOptions getOptions() {
        ClientSetting clientSetting = ClientSetting.findOrCreate((String)"oracle.onlinedb");
        BaseConnectionOptions baseConnectionOptions = (BaseConnectionOptions)clientSetting.getData("DatabaseOptions");
        if (baseConnectionOptions == null) {
            baseConnectionOptions = new BaseConnectionOptions();
            clientSetting.putData("DatabaseOptions", (Copyable)baseConnectionOptions);
        }
        return baseConnectionOptions;
    }

    private void _saveDefinitions(String string, boolean bl, boolean bl2) {
        try {
            this.cm.deployToFile(string, bl);
        }
        catch (Exception exception) {
            if (bl2) {
                this._showExceptionDialog(exception);
            }
            String string2 = this._getExceptionMessage(exception);
        }
    }

    private String _getExceptionMessage(Exception exception) {
        String string = exception.getLocalizedMessage();
        if (string == null || string.equals("")) {
            string = exception.toString();
        }
        return string;
    }

    private void _showExceptionDialog(Exception exception) {
        try {
            SwingUtilities.invokeLater(new 1(this, exception));
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    static String mav$_getExceptionMessage(BaseConnectionAddin baseConnectionAddin, Exception exception) {
        return baseConnectionAddin._getExceptionMessage(exception);
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ Exception v$ex;
        final /* synthetic */ BaseConnectionAddin this$0;

        public void run() {
            String string = BaseConnectionAddin.mav$_getExceptionMessage(this.this$0, this.v$ex);
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), ConnectionArb.format(120, string), ConnectionArb.getString(121), 0);
        }

        public 1(BaseConnectionAddin baseConnectionAddin, Exception exception) {
            this.v$ex = exception;
            this.this$0 = baseConnectionAddin;
        }
    }
}

