/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt;

import java.awt.Component;
import java.awt.Frame;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.swing.JMenuItem;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controls.ToggleAction;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.view.View;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionEvent;
import oracle.jdeveloper.cm.ConnectionListener;
import oracle.jdeveloper.cm.ConnectionManager;
import oracle.jdeveloper.cm.ConnectionType;
import oracle.jdeveloper.cm.dt.BaseConnections;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.ConnectionEditor;
import oracle.jdeveloper.cm.dt.ConnectionNode;
import oracle.jdeveloper.cm.dt.ConnectionsProvider;
import oracle.jdeveloper.cm.dt.DatabaseMenuConstants;
import oracle.jdeveloper.cm.dt.browser.ConnectionBrowserFactory;
import oracle.jdeveloper.cm.dt.browser.Refreshable;
import oracle.jdevimpl.cm.dt.ConnectionCommands;
import oracle.jdevimpl.cm.dt.browser.jdbc.FilterCommand;
import oracle.jdevimpl.cm.dt.impexp.ImportExportWizard;

public final class ConnectionController
implements ContextMenuListener,
Controller {
    private static JMenuItem DELETE_CONNECTION;
    private static JMenuItem EDIT_CONNECTION;
    private static JMenuItem EXPORT_CONNECTIONS;
    private static JMenuItem IMPORT_CONNECTIONS;
    private static JMenuItem REFRESH_MENU;
    private static JMenuItem CBR_CONNECT;
    private static JMenuItem CBR_DISCONNECT;
    private static JMenuItem FILTER_MENU;
    private static boolean _menusBuilt;

    static {
        _menusBuilt = false;
    }

    ConnectionController() {
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        Element element = ConnectionController.getElement(context.getSelection());
        if (element == null) {
            return;
        }
        if (!_menusBuilt) {
            this._buildMenus((MenuManager)contextMenu);
        }
        if (element instanceof BaseConnections) {
            contextMenu.add((Component)EXPORT_CONNECTIONS, 1.0f);
            contextMenu.add((Component)IMPORT_CONNECTIONS, 1.0f);
            this.update(ConnectionCommands.actionImport, context);
            this.update(ConnectionCommands.actionExport, context);
            return;
        }
        if (element instanceof ConnectionNode) {
            ConnectionNode connectionNode = (ConnectionNode)element;
            ConnectionCommands.actionConnect.setEnabled(connectionNode.isConnected() ^ true);
            ConnectionCommands.actionDisconnect.setEnabled(connectionNode.isConnected());
            this.update(ConnectionCommands.actionIdeRefresh, context);
            this.update(ConnectionCommands.actionIdeProperties, context);
            this.update(ConnectionCommands.ACTION_FILTER, context);
            try {
                ConnectionNode connectionNode2 = (ConnectionNode)element;
                String string = connectionNode2.getConnectionName();
                ConnectionManager connectionManager = ConnectionManager.getInstance();
                ConnectionDescriptor connectionDescriptor = connectionManager.getConnectionDescriptor(string);
                String string2 = connectionDescriptor.getConnectionType();
                if (ConnectionBrowserFactory.getInstance().getConnectionBrowserClassName(string2) != null) {
                    contextMenu.add((Component)CBR_CONNECT, JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_CNXN_CTXT);
                    contextMenu.add((Component)CBR_DISCONNECT, JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_CNXN_CTXT);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            contextMenu.add((Component)DELETE_CONNECTION, JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_CNXN_CTXT);
            contextMenu.add((Component)REFRESH_MENU, JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT);
            if (Boolean.TRUE.equals(ConnectionCommands.ACTION_FILTER.getValue("Filterable"))) {
                contextMenu.add((Component)FILTER_MENU, JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT);
            }
            contextMenu.add((Component)EDIT_CONNECTION, JDeveloperMenuConstants.SECTION_EDIT_PROPERTIES_CTXT_MENU);
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        if (context == null) {
            return false;
        }
        Element element = ConnectionController.getElement(context.getSelection());
        if (element != null) {
            if (element instanceof BaseConnections) {
                return this.handleEvent(ConnectionCommands.actionNew, context);
            }
            if (element instanceof ConnectionNode) {
                return this.handleEvent(ConnectionCommands.actionIdeProperties, context);
            }
        }
        return false;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        boolean bl = ConnectionController.isCMContext(context);
        if (context != null && ideAction != null) {
            Element element = ConnectionController.getElement(context.getSelection());
            ConnectionNode connectionNode = element instanceof ConnectionNode ? (ConnectionNode)element : null;
            int n = ideAction.getCommandId();
            if (n == 56) {
                if (connectionNode != null) {
                    ConnectionController.runNewConnectionDialog(connectionNode.getConnectionName(), 2, ConnectionController._getConnGroupForElement((Element)connectionNode));
                    return true;
                }
            } else {
                if (n == ConnectionCommands.NEW_COMMAND_NAME) {
                    ConnectionController.runNewConnectionDialog(ConnectionController._getConnGroupForElement(element));
                    return true;
                }
                if (n == ConnectionCommands.NEW_DBCONN_COMMAND_NAME) {
                    ConnectionController.runNewConnectionDialog("CLASS_DATABASE");
                    return true;
                }
                if (n == ConnectionCommands.NEW_IASCONN_COMMAND_NAME) {
                    ConnectionController.runNewConnectionDialog("CLASS_APPSERVER");
                    return true;
                }
                if (n == 20) {
                    return bl && this._doDeleteConnection(context);
                }
                if (n == ConnectionCommands.IMPORT_COMMAND_NAME) {
                    return this._doImportExport("IMPORT", context);
                }
                if (n == ConnectionCommands.EXPORT_COMMAND_NAME) {
                    return this._doImportExport("EXPORT", context);
                }
                if (n == ConnectionCommands.CBR_CONNECT_COMMAND_NAME) {
                    ConnectionController._doConnect(connectionNode, context);
                    return true;
                }
                if (n == ConnectionCommands.CBR_DISCONNECT_COMMAND_NAME) {
                    ConnectionController.doDisconnect(connectionNode, context);
                    return true;
                }
                if (n == 51) {
                    return bl && this.refreshNode(context);
                }
            }
        }
        return false;
    }

    private boolean refreshNode(Context context) {
        Element element;
        ConnectionNode connectionNode;
        View view;
        List list = null;
        TreeExplorer treeExplorer = null;
        TNode tNode = ExplorerContext.getSingleTNode((Context)context);
        if (tNode != null && (view = context.getView()) instanceof NavigatorWindow) {
            treeExplorer = ((NavigatorWindow)view).getTreeExplorer();
            list = ExplorerContext.storeExpansionState((TNode)tNode, (TreeExplorer)treeExplorer);
        }
        ConnectionNode connectionNode2 = connectionNode = (element = ConnectionController.getElement(context.getSelection())) instanceof ConnectionNode ? (ConnectionNode)element : null;
        if (connectionNode != null) {
            if (ConnectionController.doDisconnect(connectionNode, context)) {
                ConnectionController._doConnect(connectionNode, context);
            }
        } else {
            this._refreshFolderCmd(element);
        }
        if (list != null) {
            ExplorerContext.restoreExpansionState((TNode)tNode, (TreeExplorer)treeExplorer, (List)list);
        }
        return true;
    }

    public boolean update(IdeAction ideAction, Context context) {
        if (ideAction == null || context == null) {
            return true;
        }
        boolean bl = false;
        int n = ideAction.getCommandId();
        boolean bl2 = ConnectionController.isCMContext(context);
        Element element = ConnectionController.getElement(context.getSelection());
        if (n == 56 || n == 20) {
            if (bl2 && element instanceof ConnectionNode) {
                ideAction.setEnabled(true);
                bl = true;
            }
        } else if (n == 51) {
            if (bl2 && element instanceof Refreshable) {
                ideAction.setEnabled(true);
                bl = true;
            }
        } else if (n == ConnectionCommands.NEW_COMMAND_NAME) {
            if (bl2) {
                ideAction.setEnabled(true);
                bl = true;
            }
        } else if (n == ConnectionCommands.FILTER_CMD_ID) {
            FilterCommand.updateFilterAction(context, ideAction);
            bl = true;
        } else if (n == ConnectionCommands.IMPORT_COMMAND_NAME) {
            ideAction.setEnabled(element instanceof BaseConnections);
            bl = true;
        } else if (n == ConnectionCommands.EXPORT_COMMAND_NAME) {
            boolean bl3 = false;
            if (element instanceof BaseConnections) {
                String string = ((BaseConnections)element).getConnectionClassName();
                ConnectionManager connectionManager = ConnectionManager.getInstance();
                try {
                    String[] stringArray = connectionManager.getConnectionNamesForClass(string);
                    bl3 = stringArray != null && stringArray.length > 0;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ideAction.setEnabled(bl3);
            bl = true;
        }
        return bl;
    }

    static final String _getConnectionType(ConnectionNode connectionNode) {
        try {
            String string = CmUtil.getConnectionTypeForConnName(connectionNode.getConnectionName());
            return string;
        }
        catch (Exception exception) {
            return "";
        }
    }

    static final boolean _isOracleConnection(String string) {
        if (string == null) {
            return false;
        }
        return string.equals("ORACLE_JSERVER") || string.equals("JDBC");
    }

    static final boolean _isJNDIConnection(String string) {
        if (string == null) {
            return false;
        }
        return string.equals("OC4J") || string.equals("JNDI");
    }

    static final boolean _isDatabaseConnection(String string) {
        if (string == null) {
            return false;
        }
        if (ConnectionController._isOracleConnection(string)) {
            return true;
        }
        return string.equals("ORACLE_LITE") || string.equals("OTHER_JDBC") || string.equals("JDBC_ODBC");
    }

    private static String _getConnGroupForElement(Element element) {
        String string;
        ConnectionNode connectionNode;
        ConnectionDescriptor connectionDescriptor;
        if (element instanceof BaseConnections) {
            BaseConnections baseConnections = (BaseConnections)element;
            return baseConnections.getConnectionClassName();
        }
        if (element instanceof ConnectionNode && (connectionDescriptor = (connectionNode = (ConnectionNode)element).getConnectionDescriptor()) != null && (string = connectionDescriptor.getConnectionType()) != null) {
            ConnectionManager connectionManager = ConnectionManager.getInstance();
            ConnectionType connectionType = connectionManager.getConnectionType(string);
            return connectionType.getConnectionClassName();
        }
        return null;
    }

    static void runNewConnectionDialog(String string) {
        ConnectionController.runNewConnectionDialog("", 1, string);
    }

    static void runNewConnectionDialog(String string, int n, String string2) {
        ConnectionManager connectionManager = ConnectionManager.getInstance();
        String[] stringArray = null;
        try {
            stringArray = connectionManager.getConnectionTypeNamesForClass(string2);
        }
        catch (IOException iOException) {
            stringArray = null;
        }
        ConnectionExpander connectionExpander = new ConnectionExpander(null);
        connectionManager.addConnectionListener((ConnectionListener)connectionExpander);
        ConnectionEditor connectionEditor = new ConnectionEditor((Frame)Ide.getMainWindow());
        if (connectionEditor.runConnectionEditor(string, n, stringArray)) {
            ConnectionExpander.mav$selectConnection(connectionExpander);
        }
        connectionManager.removeConnectionListener((ConnectionListener)connectionExpander);
        connectionEditor = null;
    }

    private boolean _doDeleteConnection(Context context) {
        ConnectionNode connectionNode;
        boolean bl = false;
        Element element = ConnectionController.getElement(context.getSelection());
        ConnectionNode connectionNode2 = connectionNode = element instanceof ConnectionNode ? (ConnectionNode)element : null;
        if (connectionNode != null) {
            bl = true;
            try {
                String string = connectionNode.getConnectionName();
                String string2 = ConnectionArb.format(124, string);
                if (MessageDialog.confirm(null, (Object)string2, (String)ConnectionArb.getString(125), null, (boolean)true) && ConnectionController.doDisconnect(connectionNode, context)) {
                    ConnectionManager.getInstance().removeConnectionDescriptor(string);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bl;
    }

    private boolean _doImportExport(String string, Context context) {
        String string2 = ((BaseConnections)ConnectionController.getElement(context.getSelection())).getConnectionClassName();
        ImportExportWizard.invoke(string2, string);
        return true;
    }

    private static void _doConnect(ConnectionNode connectionNode, Context context) {
        connectionNode.ensureOpen();
        if (connectionNode.isConnected()) {
            try {
                TNode[] tNodeArray = ExplorerContext.getTNodes((Context)context);
                if (tNodeArray.length == 1) {
                    TNode tNode = tNodeArray[0];
                    TreeExplorer treeExplorer = tNode.getOwner();
                    treeExplorer.expand(tNode, false);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static boolean doDisconnect(ConnectionNode connectionNode, Context context) {
        boolean bl = true;
        if (connectionNode != null) {
            if (context == null) {
                context = Context.newIdeContext((Node)connectionNode);
            }
            Command command = CommandProcessor.createCommand((String)"oracle.ide.cmd.CloseNodeCommand", (Context)context);
            try {
                bl = CommandProcessor.getInstance().invoke(command) == 0;
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    private synchronized void _buildMenus(MenuManager menuManager) {
        if (!_menusBuilt) {
            DELETE_CONNECTION = menuManager.createMenuItem((ToggleAction)ConnectionCommands.actionIdeDelete, JDeveloperMenuConstants.WEIGHT_EDIT_DELETE);
            EDIT_CONNECTION = menuManager.createMenuItem((ToggleAction)ConnectionCommands.actionIdeProperties, JDeveloperMenuConstants.WEIGHT_EDIT_PROPERTIES);
            EXPORT_CONNECTIONS = menuManager.createMenuItem((ToggleAction)ConnectionCommands.actionExport, JDeveloperMenuConstants.WEIGHT_FILE_IMPORT);
            IMPORT_CONNECTIONS = menuManager.createMenuItem((ToggleAction)ConnectionCommands.actionImport, JDeveloperMenuConstants.WEIGHT_FILE_IMPORT);
            CBR_CONNECT = menuManager.createMenuItem((ToggleAction)ConnectionCommands.actionConnect, JDeveloperMenuConstants.WEIGHT_EDIT_DELETE - 0.01f);
            CBR_DISCONNECT = menuManager.createMenuItem((ToggleAction)ConnectionCommands.actionDisconnect, JDeveloperMenuConstants.WEIGHT_EDIT_DELETE - 0.01f);
            REFRESH_MENU = menuManager.createMenuItem((ToggleAction)ConnectionCommands.actionIdeRefresh, DatabaseMenuConstants.WEIGHT_DB_CTX_REFRESH);
            FILTER_MENU = menuManager.createMenuItem((ToggleAction)ConnectionCommands.ACTION_FILTER, 1.0f);
            _menusBuilt = true;
        }
    }

    private boolean _refreshFolderCmd(Element element) {
        if (element instanceof Refreshable) {
            ((Refreshable)element).refresh();
            if (element instanceof Subject) {
                UpdateMessage.fireStructureChanged((Subject)((Subject)element));
            }
            return true;
        }
        return false;
    }

    private static Element getElement(Element[] elementArray) {
        return elementArray != null && elementArray.length == 1 ? elementArray[0] : null;
    }

    private static boolean isCMContext(Context context) {
        Element[] elementArray;
        boolean bl = false;
        if (context != null && context.getView() instanceof NavigatorWindow && (elementArray = context.getSelection()) != null && elementArray.length > 0 && elementArray[0] instanceof Locatable) {
            URL uRL = ((Locatable)elementArray[0]).getURL();
            bl = CmUtil.isCMUrl(uRL);
        }
        return bl;
    }

    private static class ConnectionExpander
    implements ConnectionListener {
        private String _cName;

        public void connectionAdded(ConnectionEvent connectionEvent) {
            ConnectionDescriptor connectionDescriptor = (ConnectionDescriptor)connectionEvent.getSource();
            if (connectionDescriptor != null) {
                this._cName = connectionDescriptor.getConnectionName();
            }
        }

        public void connectionClosed(ConnectionEvent connectionEvent) {
        }

        public void connectionModified(ConnectionEvent connectionEvent) {
        }

        public void connectionOpened(ConnectionEvent connectionEvent) {
        }

        public void connectionRemoved(ConnectionEvent connectionEvent) {
        }

        private void selectConnection() {
            TNode tNode;
            TreeExplorer treeExplorer;
            TNode tNode2;
            ConnectionNode connectionNode;
            NavigatorWindow navigatorWindow;
            NavigatorManager navigatorManager;
            if (this._cName != null && (navigatorManager = NavigatorManager.getConnectionNavigatorManager()) != null && (navigatorWindow = navigatorManager.getNavigatorWindow()) != null && (connectionNode = ConnectionsProvider.getInstance().getConnectionNode(this._cName)) != null && (tNode2 = (treeExplorer = navigatorWindow.getTreeExplorer()).searchTNode((Element)connectionNode, treeExplorer.getRoot())) != null && (tNode = tNode2.getAncestorTNode(BaseConnections.class, true)) != null) {
                treeExplorer.expand(tNode, false);
                treeExplorer.setSelected(tNode2);
            }
        }

        private ConnectionExpander() {
        }

        ConnectionExpander(1 var1_1) {
            this();
        }

        static void mav$selectConnection(ConnectionExpander connectionExpander) {
            connectionExpander.selectConnection();
        }

        public final class 1 {
        }
    }
}

