/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt;

import java.awt.Component;
import java.util.Iterator;
import javax.swing.JMenuItem;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorAddin;
import oracle.ide.ceditor.EditorPluginsFactory;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.config.ClientSetting;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controls.ToggleAction;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Connections;
import oracle.ide.model.DocumentInfo;
import oracle.ide.model.Element;
import oracle.ide.model.Recognizer;
import oracle.ide.navigator.Extension;
import oracle.ide.navigator.NavigatorConstants;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFilter;
import oracle.ide.panels.Navigable;
import oracle.ide.runner.Debugger;
import oracle.ide.runner.Runner;
import oracle.ide.runner.SmartDataProvider;
import oracle.ide.runner.StarterFactory;
import oracle.ide.runner.ToolTipExpressionProvider;
import oracle.ideri.util.Product;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.GlobalSettings;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.ProfileIDs;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionEvent;
import oracle.jdeveloper.cm.ConnectionListener;
import oracle.jdeveloper.cm.ConnectionManager;
import oracle.jdeveloper.cm.ds.db.DatabaseFactory;
import oracle.jdeveloper.cm.dt.BaseConnections;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.ConnectionsProvider;
import oracle.jdeveloper.cm.dt.DatabaseConnectionNode;
import oracle.jdeveloper.cm.dt.browser.ConnectionBrowserFactory;
import oracle.jdeveloper.cm.dt.browser.jdbc.DatabaseLinkNode;
import oracle.jdeveloper.cm.dt.browser.jdbc.DirectoryNode;
import oracle.jdeveloper.cm.dt.browser.jdbc.IndexNode;
import oracle.jdeveloper.cm.dt.browser.jdbc.MViewLogNode;
import oracle.jdeveloper.cm.dt.browser.jdbc.MViewNode;
import oracle.jdeveloper.cm.dt.browser.jdbc.ObjectFolder;
import oracle.jdeveloper.cm.dt.browser.jdbc.PackageFolder;
import oracle.jdeveloper.cm.dt.browser.jdbc.PlSqlBaseNode;
import oracle.jdeveloper.cm.dt.browser.jdbc.PublicSynonymFolder;
import oracle.jdeveloper.cm.dt.browser.jdbc.RecycledObjectNode;
import oracle.jdeveloper.cm.dt.browser.jdbc.SchemaFolder;
import oracle.jdeveloper.cm.dt.browser.jdbc.SequenceNode;
import oracle.jdeveloper.cm.dt.browser.jdbc.SynonymNode;
import oracle.jdeveloper.cm.dt.browser.jdbc.TableNode;
import oracle.jdeveloper.cm.dt.browser.jdbc.ViewNode;
import oracle.jdeveloper.cm.dt.compiler.CompilerOptions;
import oracle.jdeveloper.cm.dt.compiler.CompilerOptionsPanel;
import oracle.jdeveloper.cm.dt.compiler.PlSqlTranslator;
import oracle.jdeveloper.cm.dt.ui.OracleDBWizardFactory;
import oracle.jdeveloper.cm.dt.wizard.DBWizardFactoryRegistry;
import oracle.jdeveloper.profiler.ProfilerAPI;
import oracle.jdeveloper.runner.Source;
import oracle.jdeveloper.runner.SourceFinder;
import oracle.jdeveloper.runner.SourceFinderManager;
import oracle.jdevimpl.cm.dt.CmSourceFinder;
import oracle.jdevimpl.cm.dt.CmSourceFinderManager;
import oracle.jdevimpl.cm.dt.ConnectionCommands;
import oracle.jdevimpl.cm.dt.DatabaseConnections;
import oracle.jdevimpl.cm.dt.browser.jdbc.ConnectionNodeFilter;
import oracle.jdevimpl.cm.dt.browser.jdbc.JdbcBrowserController;
import oracle.jdevimpl.cm.dt.browser.jdbc.ObjectFilter;
import oracle.jdevimpl.cm.dt.browser.jdbc.OtherSchemas;
import oracle.jdevimpl.cm.dt.browser.jdbc.OtherSchemasFilter;
import oracle.jdevimpl.cm.dt.browser.jdbc.SchemaFilter;
import oracle.jdevimpl.cm.dt.config.ConnectionOptions;
import oracle.jdevimpl.cm.dt.explorer.ConnectionExplorer;
import oracle.jdevimpl.cm.dt.explorer.DatabaseLinkExplorer;
import oracle.jdevimpl.cm.dt.explorer.DirectoryExplorer;
import oracle.jdevimpl.cm.dt.explorer.RecycledObjectExplorer;
import oracle.jdevimpl.cm.dt.explorer.mview.MViewExplorer;
import oracle.jdevimpl.cm.dt.explorer.mview.MViewLogExplorer;
import oracle.jdevimpl.cm.dt.explorer.sequence.SequenceExplorer;
import oracle.jdevimpl.cm.dt.explorer.synonym.SynonymExplorer;
import oracle.jdevimpl.cm.dt.explorer.table.IndexExplorer;
import oracle.jdevimpl.cm.dt.explorer.table.TableExplorer;
import oracle.jdevimpl.cm.dt.ext.DBFactoryHook;
import oracle.jdevimpl.cm.dt.folding.PlSqlFoldingPluginFactory;
import oracle.jdevimpl.cm.dt.insight.DatabaseInsightAddin;
import oracle.jdevimpl.cm.dt.runner.PlSqlStarterFactory;
import oracle.jdevimpl.cm.dt.sqlplus.SqlNode;
import oracle.jdevimpl.cm.dt.sqlplus.SqlPlusOptions;
import oracle.jdevimpl.debugger.jdi.DebugJDIFileSystemHelperFactory;
import oracle.jdevimpl.debugger.probe.DebugProbeConnector;
import oracle.jdevimpl.debugger.support.DebugFactory;
import oracle.jdevimpl.runner.debug.DatabaseDebuggingHelperImpl;
import oracle.jdevimpl.runner.debug.SmartPlsql;
import oracle.jdevimpl.runner.debug.ToolTipPlsql;

public final class DatabaseAddin
implements ConnectionListener,
ShutdownHook,
Addin {
    private SourceFinder _sourceFinder;
    private SourceFinderManager _sourceFinderManager;
    private static final String CONN_MGR_ADDIN_PREFIX = "ConnMgr";
    private static boolean _addinsInit = false;
    static final String JDBC_BROWSER_CLASS = "oracle.jdevimpl.cm.dt.browser.jdbc.JdbcBrowser";
    static final String ORACLE_JDBC_BROWSER_CLASS = "oracle.jdevimpl.cm.dt.browser.jdbc.OracleJdbcBrowser";
    private PlSqlTranslator _plsqlTrans;
    private int _eventHandle;

    public void initialize() {
        ConnectionManager.getInstance().addConnectionListener((ConnectionListener)this);
        this._startEvent("Registering connections");
        DatabaseAddin._registerConnections();
        this._endEvent();
        this._startEvent("Registering Browsers");
        DatabaseAddin._registerBrowsers();
        this._endEvent();
        this._startEvent("Registering IDE Objects");
        this._registerIDEObjects();
        this._endEvent();
        this._startEvent("Initializing db insight");
        DatabaseAddin._initializeDatabaseInsight();
        this._endEvent();
        this._startEvent("Initializing PL/SQL Translator");
        this._plsqlTrans = new PlSqlTranslator();
        this._plsqlTrans.initialize();
        this._endEvent();
        ClientSetting clientSetting = ClientSetting.findOrCreate((String)"oracle.onlinedb");
        CompilerOptions compilerOptions = (CompilerOptions)clientSetting.getData("PlSqlCompilerSettings");
        if (compilerOptions == null) {
            compilerOptions = new CompilerOptions();
            clientSetting.putData("PlSqlCompilerSettings", (Copyable)compilerOptions);
        }
        ClientSetting.registerUI((Navigable)new Navigable(ConnectionArb.getString(704), CompilerOptionsPanel.class));
        this._startEvent("Registering factories");
        DBFactoryHook dBFactoryHook = (DBFactoryHook)ExtensionRegistry.getExtensionRegistry().getHook(DBFactoryHook.ELEMENT_NAME);
        Iterator iterator = dBFactoryHook.getFactories();
        while (iterator.hasNext()) {
            try {
                DatabaseFactory databaseFactory = (DatabaseFactory)((Object)Class.forName((String)iterator.next()).newInstance());
                DatabaseFactory.registerFactory((DBObjectProviderFactory)databaseFactory);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        DBWizardFactoryRegistry.registerDBWizardFactory(OracleDatabase.class, new OracleDBWizardFactory());
        this._endEvent();
        PlSqlStarterFactory plSqlStarterFactory = new PlSqlStarterFactory();
        Runner.getRunner().registerStarterFactory(PlSqlBaseNode.class, (StarterFactory)plSqlStarterFactory);
        DebugFactory.registerDebugConnector((int)3, DebugProbeConnector.class, (String)DebugProbeConnector.getVersion());
        DebugJDIFileSystemHelperFactory.initialize();
        DatabaseDebuggingHelperImpl.initialize();
        Debugger debugger = Debugger.getDebugger();
        if (debugger != null) {
            debugger.addSmartDataProvider((SmartDataProvider)new SmartPlsql());
            debugger.addToolTipExpressionProvider((ToolTipExpressionProvider)new ToolTipPlsql());
        }
        ExitCommand.addShutdownHook((ShutdownHook)this);
    }

    public void shutdown() {
        ConnectionManager.getInstance().removeConnectionListener((ConnectionListener)this);
        if (this._plsqlTrans != null) {
            this._plsqlTrans.shutdown();
            this._plsqlTrans = null;
        }
        Source.removeSourceFinder((SourceFinder)this._sourceFinder);
        this._sourceFinder = null;
        Source.removeSourceFinderManager((SourceFinderManager)this._sourceFinderManager);
        this._sourceFinderManager = null;
    }

    public boolean canShutdown() {
        return true;
    }

    public void connectionAdded(ConnectionEvent connectionEvent) {
    }

    public void connectionRemoved(ConnectionEvent connectionEvent) {
        ConnectionDescriptor connectionDescriptor = (ConnectionDescriptor)connectionEvent.getSource();
        String string = connectionDescriptor.getConnectionName();
        ConnectionOptions connectionOptions = (ConnectionOptions)ClientSetting.findOrCreate((String)"oracle.onlinedb").getData("ConnectionOptions");
        if (connectionOptions != null) {
            connectionOptions.removeConnection(string);
        }
    }

    public void connectionModified(ConnectionEvent connectionEvent) {
    }

    public void connectionOpened(ConnectionEvent connectionEvent) {
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
    }

    private static void _registerConnections() {
        block0: {
            Element element = Ide.getSystem().getChild(Connections.class);
            if (!(element instanceof Connections)) break block0;
            Connections connections = (Connections)element;
            ConnectionsProvider connectionsProvider = ConnectionsProvider.getInstance();
            DatabaseConnections databaseConnections = new DatabaseConnections();
            connections.add((Element)databaseConnections);
            connectionsProvider.registerConnectionClass(((BaseConnections)databaseConnections).getConnectionClassName(), databaseConnections);
        }
    }

    private static void _registerBrowsers() {
        ConnectionBrowserFactory connectionBrowserFactory = ConnectionBrowserFactory.getInstance();
        connectionBrowserFactory.registerConnectionBrowser("JDBC", ORACLE_JDBC_BROWSER_CLASS);
        connectionBrowserFactory.registerConnectionBrowser("ORACLE_JSERVER", ORACLE_JDBC_BROWSER_CLASS);
        connectionBrowserFactory.registerConnectionBrowser("ORACLE_LITE", ORACLE_JDBC_BROWSER_CLASS);
        connectionBrowserFactory.registerConnectionBrowser("OTHER_JDBC", JDBC_BROWSER_CLASS);
        connectionBrowserFactory.registerConnectionBrowser("JDBC_ODBC", JDBC_BROWSER_CLASS);
        JdbcBrowserController.getInstance();
    }

    private void _registerIDEObjects() {
        int n = -1;
        if (ProfileIDs.PROFILE_REGISTERCMOBJECTS) {
            n = ProfilerAPI.startEvent((int)3403);
        }
        AddinManager addinManager = AddinManager.getAddinManager();
        EditorAddin editorAddin = (EditorAddin)addinManager.getAddin(CodeEditorAddin.class);
        Class<PlSqlBaseNode> clazz = PlSqlBaseNode.class;
        Class<SqlNode> clazz2 = SqlNode.class;
        EditorManager.getEditorManager().extend(editorAddin, new Class[]{clazz});
        CodeEditor.registerNodeType(clazz, (String)CodeEditor.TYPE_PLSQL);
        ClientSetting clientSetting = ClientSetting.findOrCreate((String)"oracle.onlinedb");
        if (!clientSetting.hasData("SqlPlusOptions")) {
            clientSetting.putData("SqlPlusOptions", (Copyable)new SqlPlusOptions());
        }
        if (!clientSetting.hasData("ConnectionOptions")) {
            clientSetting.putData("ConnectionOptions", (Copyable)new ConnectionOptions());
        }
        ConnectionOptions connectionOptions = (ConnectionOptions)clientSetting.getData("ConnectionOptions");
        GlobalSettings.getInstance().setValidateDataTime(connectionOptions.isValidateDateTime());
        Recognizer.mapExtensionToClass((String)".sql", clazz2);
        Recognizer.mapExtensionToClass((String)".pls", clazz2);
        Recognizer.mapExtensionToClass((String)".pks", clazz2);
        Recognizer.mapExtensionToClass((String)".pkb", clazz2);
        Recognizer.registerDocumentInfo(clazz2, (DocumentInfo)new DocumentInfo(ConnectionArb.getString(596)));
        Recognizer.registerConversion(clazz, clazz2);
        DialogUtil.addURLFilter((URLFilter)SqlNode.SQL_FILTER);
        String string = ConnectionArb.getString(123);
        DialogUtil.addURLFilter((URLFilter)new DefaultURLFilter(string, new String[]{".pls", ".pks", ".pkb"}));
        this._sourceFinder = new CmSourceFinder();
        Source.addSourceFinder((SourceFinder)this._sourceFinder);
        this._sourceFinderManager = new CmSourceFinderManager();
        Source.addSourceFinderManager((SourceFinderManager)this._sourceFinderManager);
        NavigatorManager navigatorManager = NavigatorManager.getConnectionNavigatorManager();
        navigatorManager.registerExtension((Extension)new ConnectionNavigatorExtension(null), clazz);
        navigatorManager.registerFilter(DatabaseConnectionNode.class, ConnectionNodeFilter.class, null);
        navigatorManager.registerFilter(OtherSchemas.class, OtherSchemasFilter.class, null);
        navigatorManager.registerFilter(SchemaFolder.class, SchemaFilter.class, null);
        navigatorManager.registerFilter(ObjectFolder.class, ObjectFilter.class, null);
        navigatorManager.registerFilter(PublicSynonymFolder.class, ObjectFilter.class, null);
        navigatorManager.registerFilter(PackageFolder.class, ObjectFilter.class, null);
        L l = new L(null);
        navigatorManager.addContextMenuListener((ContextMenuListener)l, DatabaseConnections.class);
        navigatorManager.addContextMenuListener((ContextMenuListener)l, Connections.class);
        ExplorerManager explorerManager = ExplorerManager.getExplorerManager();
        if (explorerManager != null) {
            Class<ConnectionExplorer> clazz3 = ConnectionExplorer.class;
            explorerManager.register(DatabaseConnectionNode.class, clazz3, null, ConnectionArb.getString(574), null);
            Class<SequenceExplorer> clazz4 = SequenceExplorer.class;
            explorerManager.register(SequenceNode.class, clazz4, null, ConnectionArb.getString(576), null);
            Class<SynonymExplorer> clazz5 = SynonymExplorer.class;
            explorerManager.register(SynonymNode.class, clazz5, null, ConnectionArb.getString(577), null);
            Class<TableExplorer> clazz6 = TableExplorer.class;
            explorerManager.register(TableNode.class, clazz6, null, ConnectionArb.getString(573), null);
            explorerManager.register(ViewNode.class, clazz6, null, ConnectionArb.getString(573), null);
            Class<IndexExplorer> clazz7 = IndexExplorer.class;
            explorerManager.register(IndexNode.class, clazz7, null, ConnectionArb.getString(573), null);
            explorerManager.register(MViewNode.class, MViewExplorer.class, null, ConnectionArb.getString(571), null);
            explorerManager.register(MViewLogNode.class, MViewLogExplorer.class, null, ConnectionArb.getString(572), null);
            Class<RecycledObjectExplorer> clazz8 = RecycledObjectExplorer.class;
            explorerManager.register(RecycledObjectNode.class, clazz8, null, ConnectionArb.getString(632), null);
            Class<DatabaseLinkExplorer> clazz9 = DatabaseLinkExplorer.class;
            explorerManager.register(DatabaseLinkNode.class, clazz9, null, ConnectionArb.getString(640), null);
            Class<DirectoryExplorer> clazz10 = DirectoryExplorer.class;
            explorerManager.register(DirectoryNode.class, clazz10, null, ConnectionArb.getString(647), null);
        }
        if (ProfileIDs.PROFILE_REGISTERCMOBJECTS) {
            ProfilerAPI.endEvent((int)n);
        }
    }

    private static void _initializeDatabaseInsight() {
        if (DatabaseAddin.useDatabaseInsight()) {
            CodeEditor.registerFactory((EditorPluginsFactory)new DatabaseInsightAddin());
            CodeEditor.registerFactory((EditorPluginsFactory)new PlSqlFoldingPluginFactory());
        }
    }

    public static boolean useDatabaseInsight() {
        String string = Ide.getProperty((String)"cm.insight", (String)"true");
        return string != null && string.equalsIgnoreCase("true");
    }

    private void _startEvent(String string) {
        this._eventHandle = ProfileIDs.PROFILE_MISCMEVENT ? ProfilerAPI.startEvent((int)3404, (String)string) : -1;
    }

    private void _endEvent() {
        if (this._eventHandle != -1) {
            ProfilerAPI.endEvent((int)this._eventHandle);
        }
    }

    public static synchronized void initializeDBAddins() {
        if (!_addinsInit) {
            AddinManager.getAddinManager().initAddinLoadset(CONN_MGR_ADDIN_PREFIX);
            _addinsInit = true;
        }
    }

    private static final class ConnectionNavigatorExtension
    implements Extension {
        public Context updateContext(Context context, TNode[] tNodeArray) {
            context.setProject(Ide.getActiveProject());
            context.setWorkspace(Ide.getActiveWorkspace());
            return context;
        }

        private ConnectionNavigatorExtension() {
        }

        ConnectionNavigatorExtension(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class L
    implements ContextMenuListener {
        private static JMenuItem NEWDB_CONNECTION;

        public boolean handleDefaultAction(Context context) {
            return false;
        }

        public void menuWillHide(ContextMenu contextMenu) {
        }

        public void menuWillShow(ContextMenu contextMenu) {
            if (NEWDB_CONNECTION == null) {
                NEWDB_CONNECTION = contextMenu.createMenuItem((ToggleAction)ConnectionCommands.actionNewDbConn, 1.0f);
            }
            contextMenu.add((Component)NEWDB_CONNECTION, 1.0f);
            if (Product.isRaptor()) {
                contextMenu.remove((Component)NavigatorConstants.New);
            }
        }

        private L() {
        }

        L(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

