/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt;

import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import oracle.ide.Ide;
import oracle.ide.util.ModelUtil;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionManager;
import oracle.jdeveloper.cm.ds.db.DBUtil;
import oracle.jdeveloper.cm.dt.BaseConnections;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.ConnectionNode;
import oracle.jdeveloper.cm.dt.DatabaseConnectionNode;
import oracle.jdevimpl.cm.dt.config.ConnectionOptions;
import oracle.jdevimpl.cm.dt.config.OtherJdbcDriverEntry;

final class DatabaseConnections
extends BaseConnections {
    public ConnectionNode create(URL uRL) {
        DatabaseConnections.checkURL(uRL);
        return new DatabaseConnectionNode(uRL);
    }

    public String getShortLabel() {
        return DBUtil.getDisplayName("Connections");
    }

    public Icon getIcon() {
        return DBUtil.getFolderIcon("Connections");
    }

    public String getConnectionClassName() {
        return "CLASS_DATABASE";
    }

    private static void checkURL(URL uRL) {
        OtherJdbcDriverEntry otherJdbcDriverEntry;
        ConnectionOptions connectionOptions;
        String string;
        ConnectionDescriptor connectionDescriptor = null;
        try {
            String string2 = CmUtil.getConnName(uRL);
            if (string2 != null) {
                connectionDescriptor = ConnectionManager.getInstance().getConnectionDescriptor(string2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (connectionDescriptor != null && "OTHER_JDBC".equals(connectionDescriptor.getConnectionType()) && ModelUtil.hasLength((String)(string = connectionDescriptor.getJdbcDriver())) && (connectionOptions = (ConnectionOptions)((Object)Ide.getSettings().getData("ConnectionOptions"))) != null && (otherJdbcDriverEntry = connectionOptions.findDriverEntry(string)) == null) {
            otherJdbcDriverEntry = new OtherJdbcDriverEntry();
            otherJdbcDriverEntry.setDriverClass(string);
            connectionOptions.addDriverEntry(otherJdbcDriverEntry);
            connectionOptions.fireChangeEvent();
        }
    }

    DatabaseConnections() {
    }
}

