/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.ModelUtil;
import oracle.jdeveloper.library.Library;
import oracle.jdevimpl.cm.dt.config.OtherJdbcDriverEntry;

public class JdbcClassLoader
extends URLClassLoader {
    private URLPath _path;
    private URLPath _nativePath;
    private boolean _libraryLoaded;

    void $init$() {
        this._path = new URLPath();
        this._nativePath = new URLPath();
    }

    public JdbcClassLoader(URLPath uRLPath) {
        super(JdbcClassLoader.convertPath(uRLPath.getEntries()));
        this.$init$();
        uRLPath.copyTo((Object)this._path);
    }

    public JdbcClassLoader(URLPath uRLPath, URLPath uRLPath2) {
        this(uRLPath);
        if (uRLPath2 != null) {
            uRLPath2.copyTo((Object)this._nativePath);
        }
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        return super.findClass(string);
    }

    public URL findResource(String string) {
        return super.findResource(string);
    }

    protected String findLibrary(String string) {
        this._libraryLoaded = true;
        String string2 = System.mapLibraryName(string);
        URL uRL = this._nativePath.toBoundURL(string2);
        if (uRL != null) {
            String string3 = URLFileSystem.getPlatformPathName((URL)uRL);
            File file = new File(string3);
            return file.getAbsolutePath();
        }
        return null;
    }

    URLPath getURLPath() {
        return this._path;
    }

    static URLPath getDriverPath(OtherJdbcDriverEntry otherJdbcDriverEntry) {
        Library library = otherJdbcDriverEntry.getDriverLibraryInstance();
        return library != null ? library.getClassPath() : new URLPath();
    }

    static URL[] convertPath(URL[] uRLArray) {
        int n = uRLArray.length;
        URL[] uRLArray2 = new URL[n];
        int n2 = 0;
        while (n2 < n) {
            URL uRL = uRLArray[n2];
            if (JarUtil.isJarURL((URL)uRL) && !ModelUtil.hasLength((String)JarUtil.getJarEntry((URL)uRL))) {
                uRL = JarUtil.getJarFileURL((URL)uRL);
            }
            uRLArray2[n2] = uRL;
            ++n2;
        }
        return uRLArray2;
    }
}

