/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.browser.jdbc;

import java.awt.Component;
import oracle.ide.Context;
import oracle.ide.controller.Command;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.explorer.ChildFilter;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.util.ModelUtil;
import oracle.ide.view.View;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.ConnectionFilter;
import oracle.jdeveloper.cm.dt.ConnectionNode;
import oracle.jdeveloper.cm.dt.browser.CBBaseFolder;
import oracle.jdeveloper.cm.dt.browser.DatabaseBrowser;
import oracle.jdeveloper.cm.dt.browser.Filterable;
import oracle.jdeveloper.cm.dt.browser.SchemaFolderFilter;
import oracle.jdeveloper.cm.dt.browser.jdbc.ObjectFolder;
import oracle.jdeveloper.cm.dt.browser.jdbc.SchemaFolder;
import oracle.jdevimpl.cm.dt.ConnectionCommands;
import oracle.jdevimpl.cm.dt.browser.jdbc.FilterPanel;
import oracle.jdevimpl.cm.dt.browser.jdbc.ObjectTypeFilterPanel;
import oracle.jdevimpl.cm.dt.browser.jdbc.OtherSchemas;
import oracle.jdevimpl.cm.dt.browser.jdbc.OtherSchemasFilter;
import oracle.jdevimpl.cm.dt.browser.jdbc.SchemasFilterPanel;

public class FilterCommand
extends Command {
    public static final String FILTERABLE_PROPERTY_KEY = "Filterable";

    public FilterCommand() {
        super(ConnectionCommands.FILTER_CMD_ID, 1);
    }

    public int doit() throws Exception {
        int n = 1;
        Context context = this.getContext();
        if (context != null) {
            Element element = FilterCommand.getElement(context);
            if (element instanceof OtherSchemas) {
                this._filterSchemas(context);
                n = 0;
            } else if (element instanceof CBBaseFolder && (n = this._filterObjects((CBBaseFolder)element)) == 0) {
                IdeAction ideAction = IdeAction.find((int)51);
                if (ideAction != null) {
                    ideAction.performAction(context);
                }
                try {
                    TNode tNode = FilterCommand.getTreeNode(context);
                    if (tNode != null) {
                        TreeExplorer treeExplorer = tNode.getOwner();
                        treeExplorer.expand(tNode, false);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return n;
    }

    private static Element getElement(Context context) {
        Element element = null;
        Element[] elementArray = context.getSelection();
        if (elementArray != null && elementArray.length == 1) {
            element = elementArray[0];
        }
        return element;
    }

    private void _filterSchemas(Context context) {
        ChildFilter childFilter;
        OtherSchemas otherSchemas = (OtherSchemas)FilterCommand.getElement(context);
        TNode tNode = FilterCommand.getTreeNode(context);
        if (tNode != null && (childFilter = tNode.getChildFilter()) instanceof OtherSchemasFilter) {
            SchemaFolderFilter schemaFolderFilter = ((OtherSchemasFilter)childFilter).getFilter();
            ConnectionNode connectionNode = CmUtil.getConnectionNode(context);
            DatabaseBrowser databaseBrowser = (DatabaseBrowser)connectionNode.getConnectionBrowser();
            Database database = databaseBrowser.getDatabase();
            try {
                SchemasFilterPanel schemasFilterPanel = new SchemasFilterPanel(database);
                schemasFilterPanel.setFilter(schemaFolderFilter);
                if (OnePageWizardDialogFactory.runDialog((Component)schemasFilterPanel, (Component)schemasFilterPanel.getDefaultFocus(), (String)ConnectionArb.getString(346))) {
                    ((OtherSchemasFilter)childFilter).setFilter(schemasFilterPanel.getFilter());
                    TreeExplorer treeExplorer = ((NavigatorWindow)context.getView()).getTreeExplorer();
                    treeExplorer.refresh(tNode);
                }
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
    }

    private int _filterObjects(CBBaseFolder cBBaseFolder) {
        int n = 1;
        if (cBBaseFolder instanceof SchemaFolder) {
            SchemaFolder schemaFolder = (SchemaFolder)cBBaseFolder;
            ObjectTypeFilterPanel objectTypeFilterPanel = new ObjectTypeFilterPanel(schemaFolder.getSupportedTypes());
            objectTypeFilterPanel.setFilter(schemaFolder.getFilter());
            if (OnePageWizardDialogFactory.runDialog((Component)objectTypeFilterPanel, (Component)objectTypeFilterPanel.getDefaultFocus(), (String)ConnectionArb.getString(339))) {
                schemaFolder.setFilter(objectTypeFilterPanel.getFilter());
                n = 0;
            }
        } else if (cBBaseFolder instanceof ObjectFolder) {
            ConnectionFilter connectionFilter;
            ObjectFolder objectFolder = (ObjectFolder)cBBaseFolder;
            ConnectionFilter connectionFilter2 = objectFolder.getFilter();
            FilterPanel filterPanel = new FilterPanel();
            filterPanel.setDatabase(objectFolder.getDatabase());
            filterPanel.setFilter(connectionFilter2);
            if (OnePageWizardDialogFactory.runDialog((Component)filterPanel, (Component)filterPanel.getDefaultFocus(), (String)ConnectionArb.getString(337)) && ModelUtil.areDifferent((Object)(connectionFilter = filterPanel.getFilter()), (Object)connectionFilter2)) {
                objectFolder.setFilter(connectionFilter);
                n = 0;
            }
        }
        return n;
    }

    public static void updateFilterAction(Context context, IdeAction ideAction) {
        ChildFilter childFilter;
        TNode tNode;
        boolean bl = false;
        boolean bl2 = false;
        Element element = FilterCommand.getElement(context);
        if (element instanceof OtherSchemas && ((OtherSchemas)element).isOpen() && (tNode = FilterCommand.getTreeNode(context)) != null && (childFilter = tNode.getChildFilter()) instanceof OtherSchemasFilter) {
            bl = true;
            bl2 = ((OtherSchemasFilter)childFilter).isFiltered();
        }
        if (element instanceof Filterable) {
            bl = ((Filterable)element).canBeFiltered();
            if (element instanceof OtherSchemas) {
                ChildFilter childFilter2;
                TNode tNode2;
                if (((OtherSchemas)element).isOpen() && (tNode2 = FilterCommand.getTreeNode(context)) != null && (childFilter2 = tNode2.getChildFilter()) instanceof OtherSchemasFilter) {
                    bl2 = ((OtherSchemasFilter)childFilter2).isFiltered();
                }
            } else {
                bl2 = ((Filterable)element).isFiltered();
            }
        }
        ideAction.setState(bl2);
        ideAction.setEnabled(bl);
    }

    static TNode getTreeNode(Context context) {
        TNode tNode = ExplorerContext.getSingleTNode((Context)context);
        if (tNode == null) {
            TreeExplorer treeExplorer;
            View view = context.getView();
            Element element = FilterCommand.getElement(context);
            if (view instanceof NavigatorWindow && (treeExplorer = ((NavigatorWindow)view).getTreeExplorer()) != null) {
                TNode tNode2 = treeExplorer.getRoot();
                tNode = treeExplorer.searchTNodeBreadthFirst(element, tNode2);
            }
        }
        return tNode;
    }
}

