/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.browser.jdbc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseFactory;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.ConnectionFilter;
import oracle.jdeveloper.cm.dt.browser.jdbc.ObjectFilter;
import oracle.jdeveloper.cm.dt.browser.jdbc.SynonymFilter;

public class FilterPanel
extends JPanel {
    private BorderLayout _layMain;
    private JPanel _pnlCenter;
    private GridBagLayout _layCenter;
    private JLabel _lblFilter;
    private JComboBox _cmbFilter;
    private NonNullableComboBoxModel _mdl;
    private JCheckBox _chkPublic;
    private ObjectFilter _filter;
    private Database _db;

    void $init$() {
        this._layMain = new BorderLayout();
        this._pnlCenter = new JPanel();
        this._layCenter = new GridBagLayout();
        this._lblFilter = new JLabel();
        this._cmbFilter = new JComboBox();
        this._mdl = new NonNullableComboBoxModel();
        this._chkPublic = new JCheckBox();
    }

    public FilterPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_bdbfilterobjects_html");
    }

    private void jbInit() throws Exception {
        this.setLayout(this._layMain);
        this._pnlCenter.setLayout(this._layCenter);
        ResourceUtils.resLabel((JLabel)this._lblFilter, (Component)this._cmbFilter, (String)ConnectionArb.getString(336));
        ResourceUtils.resButton((AbstractButton)this._chkPublic, (String)ConnectionArb.getString(338));
        this._cmbFilter.setModel(this._mdl);
        this._cmbFilter.setEditable(true);
        this._pnlCenter.add((Component)this._lblFilter, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this._pnlCenter.add((Component)this._cmbFilter, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this._pnlCenter.add((Component)this._chkPublic, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this._pnlCenter, "Center");
    }

    public ConnectionFilter getFilter() {
        String string;
        if (this._filter == null) {
            this._filter = new ObjectFilter();
        }
        if ((string = (String)this._cmbFilter.getSelectedItem()) != null) {
            string = string.trim();
        }
        if (!ModelUtil.hasLength((String)string)) {
            string = "%";
        }
        this._filter.setFilter(this.internalize(string));
        if (this._filter instanceof SynonymFilter) {
            ((SynonymFilter)this._filter).setPublicShown(this._chkPublic.isSelected());
        }
        return this._filter;
    }

    public void setFilter(ConnectionFilter connectionFilter) {
        String string;
        boolean bl = false;
        if (connectionFilter instanceof ObjectFilter) {
            this._filter = (ObjectFilter)((ObjectFilter)connectionFilter).copyTo(null);
            string = this.externalize(this._filter.getFilter());
            if (!ModelUtil.hasLength((String)string)) {
                string = "%";
            }
            List list = this._filter.getFilterHistory();
            this._mdl.removeAllElements();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2 = this.externalize((String)iterator.next());
                this._mdl.addElement((Object)string2);
            }
            if (list.indexOf(string) == -1) {
                this._mdl.insertElementAt((Object)string, 0);
            }
            if (connectionFilter instanceof SynonymFilter) {
                bl = true;
                this._chkPublic.setSelected(((SynonymFilter)connectionFilter).isPublicShown());
            }
        } else {
            string = this.externalize("%");
            this._mdl.addElement((Object)string);
        }
        this._chkPublic.setVisible(bl);
        this._mdl.setSelectedItem((Object)string);
    }

    public Component getDefaultFocus() {
        return this._cmbFilter;
    }

    public void setDatabase(Database database) {
        this._db = database;
    }

    private String externalize(String string) {
        int n;
        DatabaseDescriptor databaseDescriptor;
        String string2 = string;
        if (this._db != null && (databaseDescriptor = DatabaseFactory.getDatabaseDescriptor(this._db.getClass())) != null && ((n = databaseDescriptor.getCasePolicy()) == 2 && ModelUtil.areDifferent((Object)string, (Object)string.toUpperCase()) || n == 1 && ModelUtil.areDifferent((Object)string, (Object)string.toLowerCase()))) {
            try {
                string2 = this._db.quoteIdentifier(string, true);
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return string2;
    }

    private String internalize(String string) {
        String string2 = string;
        if (this._db != null) {
            string2 = this._db.getInternalName(string);
        }
        return string2;
    }
}

