/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.browser.jdbc;

import java.net.URL;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controls.ToggleAction;
import oracle.ide.explorer.ChildFilter;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.util.ModelUtil;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.ConnectionNode;
import oracle.jdeveloper.cm.dt.DatabaseMenuConstants;
import oracle.jdeveloper.cm.dt.browser.jdbc.PlSqlBaseNode;
import oracle.jdevimpl.cm.dt.ConnectionCommands;
import oracle.jdevimpl.cm.dt.browser.jdbc.DummyEntry;
import oracle.jdevimpl.cm.dt.browser.jdbc.FilterCommand;
import oracle.jdevimpl.cm.dt.browser.jdbc.JdbcBrowser;
import oracle.jdevimpl.cm.dt.browser.jdbc.LargeFetchPanel;
import oracle.jdevimpl.cm.dt.browser.jdbc.LargeFetchSupport;
import oracle.jdevimpl.cm.dt.explorer.PlSqlExplorer;

public final class JdbcBrowserController
implements ContextMenuListener,
Controller {
    private static JdbcBrowserController _instance;
    public static final int PURGE_COMMAND_NAME;
    public static final int UNDROP_COMMAND_NAME;
    public static final int DROP_COMMAND_NAME;
    public static final int NEW_BODY_COMMAND_NAME;
    public static final int NEWOBJECT_COMMAND;
    public static final int EDITOBJECT_COMMAND;
    private static final IdeAction actionPurge;
    private static final IdeAction actionUndrop;
    private static final IdeAction actionDrop;
    private static IdeAction actionRefresh;
    private static IdeAction actionDelete;
    private static final IdeAction actionNewBody;
    static final IdeAction actionNewObject;
    static final IdeAction actionEditObject;
    static JMenuItem MENU_PURGE;
    static JMenuItem MENU_UNDROP;
    static JMenuItem MENU_DROP;
    static JMenuItem MENU_REFRESH;
    public static JMenuItem MENU_NEWBODY;
    static JMenuItem MENU_NEWOBJECT;
    static JMenuItem MENU_EDITOBJECT;
    static JMenuItem MENU_FILTER;
    private static boolean menusBuilt;

    public static synchronized JdbcBrowserController getInstance() {
        if (_instance == null) {
            _instance = new JdbcBrowserController();
        }
        return _instance;
    }

    static {
        PURGE_COMMAND_NAME = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.cm.dt.browser.jdbc.JdbcBrowser.PURGE");
        UNDROP_COMMAND_NAME = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.cm.dt.browser.jdbc.JdbcBrowser.UNDROP");
        DROP_COMMAND_NAME = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.cm.dt.browser.jdbc.JdbcBrowser.DROP");
        NEW_BODY_COMMAND_NAME = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.cm.dt.browser.jdbc.JdbcBrowser.NEW_BODY");
        NEWOBJECT_COMMAND = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.cm.dt.browser.jdbc.JdbcBrowser.NEWOBJECT");
        EDITOBJECT_COMMAND = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.cm.dt.browser.jdbc.JdbcBrowser.EDITOBJECT");
        actionPurge = IdeAction.get((int)PURGE_COMMAND_NAME, (String)StringUtils.stripMnemonic((String)ConnectionArb.getString(305)), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)ConnectionArb.getString(305))));
        actionUndrop = IdeAction.get((int)UNDROP_COMMAND_NAME, (String)StringUtils.stripMnemonic((String)ConnectionArb.getString(306)), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)ConnectionArb.getString(306))));
        actionDrop = IdeAction.get((int)DROP_COMMAND_NAME, (String)StringUtils.stripMnemonic((String)ConnectionArb.getString(307)), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)ConnectionArb.getString(307))));
        actionNewBody = IdeAction.get((int)NEW_BODY_COMMAND_NAME, (String)StringUtils.stripMnemonic((String)ConnectionArb.getString(326)), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)ConnectionArb.getString(326))));
        actionNewObject = IdeAction.get((int)NEWOBJECT_COMMAND, (String)StringUtils.stripMnemonic((String)ConnectionArb.getString(500)), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)ConnectionArb.getString(500))));
        actionEditObject = IdeAction.get((int)EDITOBJECT_COMMAND, (String)StringUtils.stripMnemonic((String)"&Edit..."), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)"&Edit...")));
        menusBuilt = false;
    }

    static String getCreateLabel(String string) {
        String string2 = null;
        if ("SEQUENCE".equals(string)) {
            string2 = ConnectionArb.getString(497);
        } else if ("SYNONYM".equals(string)) {
            string2 = ConnectionArb.getString(498);
        } else if ("INDEX".equals(string)) {
            string2 = ConnectionArb.getString(499);
        } else if ("TABLE".equals(string)) {
            string2 = ConnectionArb.getString(500);
        } else if ("VIEW".equals(string)) {
            string2 = ConnectionArb.getString(501);
        } else if ("TRIGGER".equals(string)) {
            string2 = ConnectionArb.getString(503);
        }
        return string2;
    }

    private JdbcBrowserController() {
        NavigatorManager navigatorManager = NavigatorManager.getConnectionNavigatorManager();
        navigatorManager.addContextMenuListener((ContextMenuListener)this, null);
        actionDrop.addController((Controller)this);
        actionPurge.addController((Controller)this);
        actionUndrop.addController((Controller)this);
        actionRefresh = IdeAction.find((int)51);
        actionDelete = IdeAction.find((int)20);
        if (actionDelete != null) {
            actionDelete.addController((Controller)this);
        }
        actionNewObject.addController((Controller)this);
        actionEditObject.addController((Controller)this);
        actionNewBody.addController((Controller)this);
        ExplorerManager explorerManager = ExplorerManager.getExplorerManager();
        if (explorerManager != null) {
            explorerManager.register(PlSqlBaseNode.class, PlSqlExplorer.class, null, ConnectionArb.getString(575), null);
        }
    }

    private static JdbcBrowser _getBrowserForDispatch(URL uRL) {
        ConnectionNode connectionNode = CmUtil.getConnectionNode(uRL);
        return connectionNode != null && ModelUtil.areDifferent((Object)uRL, (Object)connectionNode.getURL()) ? JdbcBrowser.getBrowser(connectionNode) : null;
    }

    private JdbcBrowser _getBrowserForDispatch(Context context) {
        Element element = context != null ? context.getElement() : null;
        return element instanceof Locatable ? JdbcBrowserController._getBrowserForDispatch(((Locatable)element).getURL()) : null;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        boolean bl = false;
        JdbcBrowser jdbcBrowser = this._getBrowserForDispatch(context);
        if (jdbcBrowser != null) {
            bl = jdbcBrowser.handleEvent(ideAction, context);
        }
        return bl;
    }

    public boolean update(IdeAction ideAction, Context context) {
        JdbcBrowser jdbcBrowser = this._getBrowserForDispatch(context);
        if (jdbcBrowser != null) {
            return jdbcBrowser.update(ideAction, context);
        }
        return false;
    }

    private synchronized void buildMenus(MenuManager menuManager) {
        if (!menusBuilt) {
            MENU_PURGE = menuManager.createMenuItem((ToggleAction)actionPurge);
            MENU_UNDROP = menuManager.createMenuItem((ToggleAction)actionUndrop);
            MENU_DROP = menuManager.createMenuItem((ToggleAction)actionDrop);
            MENU_REFRESH = menuManager.createMenuItem((ToggleAction)actionRefresh, DatabaseMenuConstants.WEIGHT_DB_CTX_REFRESH);
            MENU_NEWBODY = menuManager.createMenuItem((ToggleAction)actionNewBody);
            MENU_NEWOBJECT = menuManager.createMenuItem((ToggleAction)actionNewObject);
            MENU_EDITOBJECT = menuManager.createMenuItem((ToggleAction)actionEditObject);
            MENU_FILTER = menuManager.createMenuItem((ToggleAction)ConnectionCommands.ACTION_FILTER, 1.0f);
            menusBuilt = true;
        }
    }

    public void menuWillShow(ContextMenu contextMenu) {
        JdbcBrowser jdbcBrowser;
        Element[] elementArray;
        Context context = contextMenu.getContext();
        Element[] elementArray2 = elementArray = context != null ? context.getSelection() : null;
        if (JdbcBrowser.arrayInstanceOf(elementArray, Locatable.class) && (jdbcBrowser = JdbcBrowserController._getBrowserForDispatch(((Locatable)elementArray[0]).getURL())) != null) {
            if (!menusBuilt) {
                this.buildMenus((MenuManager)contextMenu);
            }
            jdbcBrowser.menuWillShow(elementArray, contextMenu);
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        Element[] elementArray = context.getSelection();
        if (elementArray != null && elementArray.length == 1 && elementArray[0] instanceof DummyEntry) {
            ChildFilter childFilter;
            TNode tNode;
            int n = LargeFetchPanel.promptUser();
            if (n == 1) {
                TNode tNode2 = JdbcBrowserController.getFolderTNode(context);
                Context context2 = new Context(tNode2.getData());
                context2.setView(context.getView());
                Command command = CommandProcessor.createCommand((String)FilterCommand.class.getName(), (Context)context2);
                try {
                    CommandProcessor.getInstance().invoke(command);
                }
                catch (Exception exception) {}
            } else if (n == 2 && (tNode = JdbcBrowserController.getFolderTNode(context)) != null && (childFilter = tNode.getChildFilter()) instanceof LargeFetchSupport) {
                ((LargeFetchSupport)childFilter).setShowAll(true);
                TreeExplorer treeExplorer = ((NavigatorWindow)context.getView()).getTreeExplorer();
                treeExplorer.refresh(tNode);
            }
            return true;
        }
        return false;
    }

    private static TNode getFolderTNode(Context context) {
        TNode tNode = null;
        TNode tNode2 = FilterCommand.getTreeNode(context);
        if (tNode2 != null) {
            tNode = (TNode)tNode2.getParent();
        }
        return tNode;
    }
}

