/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.cnpanels;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.ide.controls.WholeNumberField;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdevimpl.cm.dt.cnpanels.ConnectionPanel;

abstract class JSR88Panel
extends ConnectionPanel {
    private JTextField fldHost;
    private WholeNumberField fldPort;
    private JTextField fldPath;
    private boolean _groupDeployment;
    private JRadioButton _btnGroup;
    private JRadioButton _btnSingleInstance;

    void $init$() {
        this.fldHost = new JTextField();
        this.fldPort = new WholeNumberField(4);
        this.fldPath = new JTextField();
        this._btnGroup = new JRadioButton();
        this._btnSingleInstance = new JRadioButton();
    }

    JSR88Panel() {
        this.$init$();
        MultiLineLabel multiLineLabel = new MultiLineLabel();
        multiLineLabel.setTextWrapper(WordWrapper.getTextWrapper());
        multiLineLabel.setText(this.getHintLabel());
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.fldHost, (String)ConnectionArb.getString(601));
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.fldPort, (String)this.getPortLabel());
        JLabel jLabel3 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this.fldPath, (String)this.getPathLabel());
        if (this.isGroupDeploymentAvailable()) {
            ResourceUtils.resButton((AbstractButton)this._btnSingleInstance, (String)ConnectionArb.getString(604));
            ResourceUtils.resButton((AbstractButton)this._btnGroup, (String)ConnectionArb.getString(605));
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this._btnSingleInstance);
            buttonGroup.add(this._btnGroup);
        }
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(5, 5, 5, 5);
        Insets insets2 = new Insets(0, 5, 5, 5);
        this.add((Component)multiLineLabel, this.gbc(0, 0, 4, 1, 0.0, 0.0, 17, 2, insets));
        this.add(jLabel, this.gbc(0, 1, 1, 1, 0.0, 0.0, 17, 2, insets));
        this.add(this.fldHost, this.gbc(1, 1, 1, 1, 1.0, 0.0, 17, 2, insets));
        this.add(jLabel2, this.gbc(2, 1, 1, 1, 0.0, 0.0, 17, 2, insets));
        this.add((Component)this.fldPort, this.gbc(3, 1, 1, 1, 0.0, 0.0, 17, 2, insets));
        this.add(jLabel3, this.gbc(0, 2, 1, 1, 0.0, 0.0, 17, 2, insets2));
        this.add(this.fldPath, this.gbc(1, 2, 1, 1, 1.0, 0.0, 17, 2, insets2));
        if (this.isGroupDeploymentAvailable()) {
            this.add(this._btnSingleInstance, this.gbc(1, 4, 1, 1, 0.0, 0.0, 17, 2, insets));
            this.add(this._btnGroup, this.gbc(1, 5, 1, 1, 0.0, 0.0, 17, 2, insets));
        }
        this.add(Box.createVerticalGlue(), this.gbc(0, 3, 1, 4, 0.0, 1.0, 18, 1, new Insets(0, 0, 0, 0)));
    }

    public final void onEntry(TraversableContext traversableContext) {
        this.entryInit(traversableContext, Boolean.TRUE, this.fldHost);
        ConnectionDescriptor connectionDescriptor = JSR88Panel.getConnectionDescriptor((Namespace)traversableContext);
        String string = connectionDescriptor.getProperty("JMX_CONNECTOR_HOST");
        if (!ModelUtil.hasLength((String)string)) {
            string = this.getDefaultHost();
        }
        this.fldHost.setText(string);
        string = connectionDescriptor.getProperty("JMX_CONNECTOR_PORT");
        int n = this.getDefaultPort();
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.fldPort.setNumber((Number)new Integer(n));
        string = connectionDescriptor.getProperty("JMX_CONNECTOR_PATH");
        this.fldPath.setText(string != null ? string : this.getDefaultPath());
        string = connectionDescriptor.getProperty("JSR88_DEPLOYMENT_URL");
        boolean bl = this._groupDeployment = string != null && string.startsWith("deployer:cluster:");
        if (this._groupDeployment) {
            this._btnGroup.setSelected(true);
        } else {
            this._btnSingleInstance.setSelected(true);
        }
    }

    public final void onExit(TraversableContext traversableContext) throws TraversalException {
        ConnectionDescriptor connectionDescriptor = JSR88Panel.getConnectionDescriptor((Namespace)traversableContext);
        boolean bl = traversableContext.getDirection() != 2;
        String string = this.fldHost.getText();
        if (bl && !ModelUtil.hasLength((String)string)) {
            throw new TraversalException(ConnectionArb.getString(606));
        }
        connectionDescriptor.put((Object)"JMX_CONNECTOR_HOST", (Object)string);
        Number number = this.fldPort.getNumber();
        if (bl && number == null) {
            throw new TraversalException(ConnectionArb.getString(607));
        }
        if (number != null) {
            connectionDescriptor.put((Object)"JMX_CONNECTOR_PORT", (Object)number.toString());
        } else {
            connectionDescriptor.put((Object)"JMX_CONNECTOR_PORT", (Object)"");
        }
        String string2 = this.fldPath.getText();
        if (bl) {
            this.validatePath(string2);
        }
        connectionDescriptor.put((Object)"JMX_CONNECTOR_PATH", (Object)string2);
        this._groupDeployment = this._btnGroup.isSelected();
        if (bl) {
            connectionDescriptor.put((Object)"URL", (Object)this.getURLforRMI(string, number.intValue(), string2));
            connectionDescriptor.put((Object)"JNDI_INITIAL_CONTEXT_FACTORY", (Object)"com.evermind.server.rmi.RMIInitialContextFactory");
            connectionDescriptor.put((Object)"JSR88_DEPLOYMENT_URL", (Object)this.getDeployerURL(string, number.intValue(), string2));
        }
    }

    protected void validatePath(String string) throws TraversalException {
    }

    protected boolean isGroupDeploymentConnection() {
        return this._groupDeployment;
    }

    protected abstract String getDefaultHost();

    protected abstract int getDefaultPort();

    protected abstract String getDefaultPath();

    protected abstract String getHintLabel();

    protected abstract String getPortLabel();

    protected abstract String getPathLabel();

    protected abstract boolean isGroupDeploymentAvailable();

    protected abstract String getURLforRMI(String var1, int var2, String var3);

    protected abstract String getDeployerURL(String var1, int var2, String var3);
}

