/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.cnpanels;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.ewt.text.WordWrapper;
import oracle.ide.controls.WholeNumberField;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.WizardCallbacks;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdevimpl.cm.dt.cnpanels.ConnectionPanel;
import oracle.jdevimpl.cm.dt.cnpanels.ConnectionPanelException;

final class OraclePanel
extends ConnectionPanel
implements ActionListener {
    private final JComboBox cmbDriver;
    private final JTextField fldHost;
    private final WholeNumberField fldPort;
    private final JTextField fldSid;
    private final NumberTextField fldIiopPort;
    private final JLabel lblIIOPport;
    private final JTextField fldServiceName;
    private final JRadioButton rdbSidSelector;
    private final JRadioButton rdbServiceNameSelector;
    private final ButtonGroup rbgSelectorGroup;
    private final String[] ORA_DRIVER_TYPES;
    private static final String ORACLE_URL_PREFIX = "jdbc:oracle:";
    private final JCheckBox chkAdv;
    private final JTextArea taURL;
    private final JScrollPane spURL;
    private static final int POS_LABEL = 0;
    private static final int POS_FIELD = 1;
    private boolean _isJServer;
    private WizardCallbacks _callbacks;
    private DocumentListener DL;

    void $init$() {
        this.cmbDriver = new JComboBox();
        this.fldHost = new JTextField();
        this.fldPort = new WholeNumberField(4);
        this.fldSid = new JTextField();
        this.fldIiopPort = new NumberTextField();
        this.lblIIOPport = new JLabel();
        this.fldServiceName = new JTextField();
        this.rdbSidSelector = new JRadioButton();
        this.rdbServiceNameSelector = new JRadioButton();
        this.rbgSelectorGroup = new ButtonGroup();
        this.ORA_DRIVER_TYPES = new String[]{"thin", "oci8"};
        this.chkAdv = new JCheckBox();
        this.taURL = new JTextArea();
        this.spURL = new JScrollPane();
        this._isJServer = false;
        this.DL = new 1();
    }

    OraclePanel() {
        this.$init$();
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.cmbDriver, (String)ConnectionArb.getString(39));
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.fldHost, (String)ConnectionArb.getString(40));
        JLabel jLabel3 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this.fldPort, (String)ConnectionArb.getString(41));
        ResourceUtils.resLabel((JLabel)this.lblIIOPport, (Component)this.fldIiopPort, (String)ConnectionArb.getString(44));
        ResourceUtils.resButton((AbstractButton)this.chkAdv, (String)ConnectionArb.getString(48));
        this.fldHost.getDocument().addDocumentListener(this.DL);
        this.fldPort.getDocument().addDocumentListener(this.DL);
        this.fldSid.getDocument().addDocumentListener(this.DL);
        this.fldServiceName.getDocument().addDocumentListener(this.DL);
        this.fldHost.setText("localhost");
        this.fldPort.setNumber((Number)new Integer(1521));
        this.fldSid.setText("ORCL");
        this.fldServiceName.setText("ORCL");
        this.rdbSidSelector.addActionListener(this);
        this.rdbSidSelector.setText(ConnectionArb.getString(42));
        this.rdbSidSelector.setMnemonic('S');
        this.rdbSidSelector.setSelected(true);
        this.rdbServiceNameSelector.setText(ConnectionArb.getString(43));
        this.rdbServiceNameSelector.setMnemonic('v');
        this.rdbServiceNameSelector.addActionListener(this);
        this.rbgSelectorGroup.add(this.rdbSidSelector);
        this.rbgSelectorGroup.add(this.rdbServiceNameSelector);
        this.fldIiopPort.setDataType(Integer.class);
        this.fldIiopPort.setDecimal(false, 5);
        this.fldIiopPort.setNumber((Number)new Integer(2481));
        MultiLineLabel multiLineLabel = new MultiLineLabel();
        multiLineLabel.setTextWrapper(WordWrapper.getTextWrapper());
        multiLineLabel.setText(ConnectionArb.getString(49));
        multiLineLabel.setPreferredAspectRatio(0.0f);
        this.chkAdv.addActionListener(this);
        this.taURL.setLineWrap(true);
        this.taURL.setText("");
        this.taURL.setRows(3);
        this.spURL.setHorizontalScrollBarPolicy(31);
        this.spURL.setVerticalScrollBarPolicy(22);
        this.spURL.getViewport().add(this.taURL);
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement(this.ORA_DRIVER_TYPES[0]);
        defaultComboBoxModel.addElement(this.ORA_DRIVER_TYPES[1]);
        this.cmbDriver.setModel(defaultComboBoxModel);
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(5, 5, 5, 5);
        this.add((Component)multiLineLabel, this.gbc(0, 0, 3, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 15, 5)));
        this.add(jLabel, this.gbc(0, 1, 2, 1, 0.0, 0.0, 17, 0, insets));
        this.add(this.cmbDriver, this.gbc(2, 1, 1, 1, 1.0, 0.0, 10, 2, insets));
        this.add(jLabel2, this.gbc(0, 2, 2, 1, 0.0, 0.0, 17, 0, insets));
        this.add(this.fldHost, this.gbc(2, 2, 1, 1, 1.0, 0.0, 10, 2, insets));
        this.add(jLabel3, this.gbc(0, 3, 2, 1, 0.0, 0.0, 17, 0, insets));
        this.add((Component)this.fldPort, this.gbc(2, 3, 1, 1, 1.0, 0.0, 10, 2, insets));
        this.add(this.rdbSidSelector, this.gbc(0, 4, 1, 1, 0.0, 0.0, 17, 0, insets));
        this.add(this.fldSid, this.gbc(2, 4, 1, 1, 1.0, 0.0, 10, 2, insets));
        this.add(this.rdbServiceNameSelector, this.gbc(0, 5, 1, 1, 0.0, 0.0, 17, 0, insets));
        this.add(this.fldServiceName, this.gbc(2, 5, 1, 1, 1.0, 0.0, 10, 2, insets));
        this.add(this.lblIIOPport, this.gbc(0, 6, 1, 1, 0.0, 0.0, 17, 0, insets));
        this.add((Component)this.fldIiopPort, this.gbc(1, 6, 1, 1, 1.0, 0.0, 10, 2, insets));
        this.add(this.chkAdv, this.gbc(0, 7, 3, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5)));
        this.add(this.spURL, this.gbc(0, 8, 3, 1, 1.0, 1.0, 10, 1, insets));
        this.setHelpID("f1_idewcxnconnection_html");
    }

    public void onEntry(TraversableContext traversableContext) {
        this.entryInit(traversableContext, Boolean.TRUE, this.fldHost);
        this._callbacks = traversableContext.getWizardCallbacks();
        ConnectionDescriptor connectionDescriptor = OraclePanel.getConnectionDescriptor((Namespace)traversableContext);
        String string = connectionDescriptor.getProperty("URL");
        if (connectionDescriptor.getConnectionType().equals("ORACLE_JSERVER")) {
            this._isJServer = true;
            this.fldIiopPort.setVisible(true);
            this.lblIIOPport.setVisible(true);
            this.chkAdv.setVisible(false);
            this.spURL.setVisible(false);
        } else {
            this.fldIiopPort.setVisible(false);
            this.lblIIOPport.setVisible(false);
            this.chkAdv.setVisible(true);
            this.spURL.setVisible(true);
            if (string != null && string.length() > 0) {
                this.chkAdv.setSelected(true);
                this.taURL.setText(string);
            }
        }
        String string2 = connectionDescriptor.getHostname();
        if (string2 == null) {
            string2 = "localhost";
        }
        String string3 = connectionDescriptor.getJdbcPort();
        String string4 = connectionDescriptor.getIiopPort();
        String string5 = connectionDescriptor.getSid();
        String string6 = connectionDescriptor.getOracleJdbcType();
        String string7 = connectionDescriptor.getProperty("ServiceName");
        this.fldHost.setText(string2);
        if (string3 != null) {
            this.fldPort.setNumber((Number)new Integer(string3));
        } else {
            this.fldPort.setNumber((Number)new Integer(1521));
        }
        if (string4 != null) {
            this.fldIiopPort.setNumber((Number)new Integer(string4));
        } else {
            this.fldIiopPort.setNumber((Number)new Integer(2481));
        }
        if (string7 != null && string5 == null) {
            this.rdbServiceNameSelector.setSelected(true);
        } else {
            this.rdbSidSelector.setSelected(true);
        }
        if (string5 == null && string7 == null) {
            string5 = "ORCL";
            string7 = "ORCL";
        }
        this.fldSid.setText(string5);
        this.fldServiceName.setText(string7);
        if (string6 == null) {
            string6 = this.ORA_DRIVER_TYPES[0];
        }
        this.cmbDriver.setSelectedItem(string6);
        this.enableControls();
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.exitInit(traversableContext);
        ConnectionDescriptor connectionDescriptor = OraclePanel.getConnectionDescriptor((Namespace)traversableContext);
        String string = this.findDriver();
        connectionDescriptor.put((Object)"JdbcDriver", (Object)string);
        int n = this.cmbDriver.getSelectedIndex();
        if (n < 0) {
            n = 0;
        }
        String string2 = this.ORA_DRIVER_TYPES[n];
        String string3 = this.fldHost.getText();
        Number number = this.fldPort.getNumber();
        String string4 = number != null ? number.toString() : null;
        String string5 = this.fldSid.getText();
        String string6 = this.fldServiceName.getText();
        connectionDescriptor.put((Object)"HOSTNAME", (Object)string3);
        if (connectionDescriptor.getConnectionType().equals("ORACLE_JSERVER")) {
            String string7 = this.fldIiopPort.getNumber().toString();
            connectionDescriptor.put((Object)"IIOP_PORT", (Object)string7);
        }
        connectionDescriptor.put((Object)"JDBC_PORT", (Object)string4);
        connectionDescriptor.put((Object)"ORACLE_JDBC_TYPE", (Object)string2);
        if (this.rdbSidSelector.isSelected()) {
            connectionDescriptor.put((Object)"SID", (Object)string5);
            connectionDescriptor.remove((Object)"ServiceName");
        } else {
            connectionDescriptor.put((Object)"ServiceName", (Object)string6);
            connectionDescriptor.remove((Object)"SID");
        }
        if (this.chkAdv.isVisible() && this.chkAdv.isSelected()) {
            connectionDescriptor.put((Object)"URL", (Object)this.taURL.getText());
        } else {
            connectionDescriptor.remove((Object)"URL");
        }
    }

    protected void validatePanel(TraversableContext traversableContext) throws ConnectionPanelException {
        int n = this.cmbDriver.getSelectedIndex();
        if (n < 0) {
            n = 0;
        }
        String string = this.ORA_DRIVER_TYPES[n];
        String string2 = this.fldHost.getText();
        Number number = this.fldPort.getNumber();
        String string3 = number != null ? number.toString() : null;
        String string4 = this.fldSid.getText();
        String string5 = this.fldServiceName.getText();
        if (!ModelUtil.hasLength((String)string2)) {
            throw new ConnectionPanelException(ConnectionArb.getString(50));
        }
        if (!ModelUtil.hasLength((String)string3) || string3.equals("0")) {
            throw new ConnectionPanelException(ConnectionArb.getString(51));
        }
        if (this.rdbSidSelector.isSelected() && !ModelUtil.hasLength((String)string4.trim())) {
            throw new ConnectionPanelException(ConnectionArb.getString(52));
        }
        if (this.rdbServiceNameSelector.isSelected() && !ModelUtil.hasLength((String)string5.trim())) {
            throw new ConnectionPanelException(ConnectionArb.getString(53));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.enableControls();
        if (actionEvent.getActionCommand().equals(ConnectionArb.getString(43))) {
            this.fldServiceName.requestFocus();
        } else if (actionEvent.getActionCommand().equals(ConnectionArb.getString(42))) {
            this.fldSid.requestFocus();
        }
    }

    private void enableControls() {
        if (this._isJServer) {
            return;
        }
        if (this.chkAdv.isSelected()) {
            this.fldHost.setEnabled(false);
            this.fldPort.setEnabled(false);
            this.fldSid.setEnabled(false);
            this.fldServiceName.setEnabled(false);
            this.rdbSidSelector.setEnabled(false);
            this.rdbServiceNameSelector.setEnabled(false);
            this.taURL.setEnabled(true);
            this.taURL.setBackground(SystemColor.window);
        } else {
            this.fldHost.setEnabled(true);
            this.fldPort.setEnabled(true);
            this.rdbSidSelector.setEnabled(true);
            this.rdbServiceNameSelector.setEnabled(true);
            this.taURL.setEnabled(false);
            this.taURL.setBackground(SystemColor.control);
            if (this.rdbSidSelector.isSelected()) {
                this.fldSid.setEnabled(true);
                this.fldServiceName.setEnabled(false);
            } else {
                this.fldSid.setEnabled(false);
                this.fldServiceName.setEnabled(true);
            }
        }
        this._updateButtons();
    }

    private void _updateButtons() {
        if (this._callbacks != null) {
            String string = this.fldHost.getText();
            String string2 = this.fldSid.getText();
            Number number = this.fldPort.getNumber();
            String string3 = this.fldServiceName.getText();
            Boolean bl = ModelUtil.hasLength((String)string) && (this.rdbSidSelector.isSelected() && ModelUtil.hasLength((String)string2) || this.rdbServiceNameSelector.isSelected() && ModelUtil.hasLength((String)string3)) && number != null && number.intValue() > 0;
            this._callbacks.wizardEnableButtons(null, bl, bl);
        }
    }

    private String findDriver() {
        String string;
        try {
            string = "oracle.jdbc.OracleDriver";
            Class.forName(string);
        }
        catch (Exception exception) {
            string = "oracle.jdbc.driver.OracleDriver";
        }
        return string;
    }

    static void mav$_updateButtons(OraclePanel oraclePanel) {
        oraclePanel._updateButtons();
    }

    final class 1
    implements DocumentListener {
        public void insertUpdate(DocumentEvent documentEvent) {
            OraclePanel.mav$_updateButtons(OraclePanel.this);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            OraclePanel.mav$_updateButtons(OraclePanel.this);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            OraclePanel.mav$_updateButtons(OraclePanel.this);
        }
    }
}

