/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.cnpanels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdevimpl.cm.dt.cnpanels.ConnectionPanel;

class Weblogic6Panel
extends ConnectionPanel
implements ActionListener {
    private static final String WEBLOGIC_INITIAL_FACTORY = "weblogic.jndi.WLInitialContextFactory";
    private final JTextField fldHostname;
    private final JTextField fldPort;
    private final JTextField fldTargetNode;
    private final JTextField fldHome;
    private final JButton btnBrowse;

    void $init$() {
        this.fldHostname = new JTextField();
        this.fldPort = new JTextField();
        this.fldTargetNode = new JTextField();
        this.fldHome = new JTextField();
        this.btnBrowse = new JButton();
    }

    Weblogic6Panel() {
        this.$init$();
        MultiLineLabel multiLineLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), ConnectionArb.getString(399));
        multiLineLabel.setPreferredAspectRatio(0.0f);
        multiLineLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 15, 5));
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.fldHostname, (String)ConnectionArb.getString(401));
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.fldPort, (String)ConnectionArb.getString(402));
        JLabel jLabel3 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this.fldTargetNode, (String)ConnectionArb.getString(403));
        JLabel jLabel4 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel4, (Component)this.fldHome, (String)ConnectionArb.getString(400));
        ResourceUtils.resButton((AbstractButton)this.btnBrowse, (String)ConnectionArb.getString(404));
        this.btnBrowse.addActionListener(this);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(0, 5, 2, 5);
        Insets insets2 = new Insets(0, 5, 5, 5);
        this.add((Component)multiLineLabel, "North");
        jPanel.add((Component)jLabel, this.gbc(0, 0, 2, 1, 0.0, 0.0, 18, 0, insets));
        jPanel.add((Component)this.fldHostname, this.gbc(0, 1, 2, 1, 0.0, 0.0, 18, 2, insets2));
        jPanel.add((Component)jLabel2, this.gbc(0, 2, 2, 1, 0.0, 0.0, 18, 0, insets));
        jPanel.add((Component)this.fldPort, this.gbc(0, 3, 2, 1, 0.0, 0.0, 18, 2, insets2));
        jPanel.add((Component)jLabel3, this.gbc(0, 4, 2, 1, 0.0, 0.0, 18, 0, insets));
        jPanel.add((Component)this.fldTargetNode, this.gbc(0, 5, 2, 1, 0.0, 0.0, 18, 2, insets2));
        jPanel.add((Component)jLabel4, this.gbc(0, 6, 2, 1, 0.0, 0.0, 18, 0, insets));
        jPanel.add((Component)this.fldHome, this.gbc(0, 7, 1, 1, 1.0, 0.0, 10, 2, insets2));
        jPanel.add((Component)this.btnBrowse, this.gbc(1, 7, 1, 1, 0.0, 0.0, 17, 0, insets2));
        jPanel.add(Box.createHorizontalGlue(), this.gbc(0, 8, 2, 1, 1.0, 1.0, 18, 0, insets2));
        this.add(jPanel, "Center");
        this.setHelpID("f1_idewcxnweblogic_html");
    }

    public void onEntry(TraversableContext traversableContext) {
        this.entryInit(traversableContext, Boolean.TRUE, this.fldHostname);
        ConnectionDescriptor connectionDescriptor = Weblogic6Panel.getConnectionDescriptor((Namespace)traversableContext);
        String string = connectionDescriptor.getHostname();
        if (string == null) {
            try {
                string = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                string = "localhost";
            }
        }
        this.fldHostname.setText(string);
        String string2 = connectionDescriptor.getPort();
        if (string2 == null) {
            string2 = "7001";
        }
        this.fldPort.setText(string2);
        String string3 = connectionDescriptor.getProperty("TARGET_NODE");
        if (string3 == null) {
            string3 = "myserver";
        }
        this.fldTargetNode.setText(string3);
        String string4 = connectionDescriptor.getProperty("OC4J_HOME");
        if (string4 == null) {
            string4 = Weblogic6Panel.getAbsolutePath(this.getDefaultWeblogicJarPath());
        }
        this.fldHome.setText(string4);
    }

    public void onExit(TraversableContext traversableContext) {
        String string;
        ConnectionDescriptor connectionDescriptor = Weblogic6Panel.getConnectionDescriptor((Namespace)traversableContext);
        connectionDescriptor.put((Object)"JNDI_INITIAL_CONTEXT_FACTORY", (Object)WEBLOGIC_INITIAL_FACTORY);
        StringBuffer stringBuffer = new StringBuffer("t3://");
        String string2 = this.fldHostname.getText();
        if (string2 != null) {
            connectionDescriptor.put((Object)"HOSTNAME", (Object)string2);
            stringBuffer.append(string2);
        } else {
            stringBuffer.append("localhost");
        }
        String string3 = this.fldPort.getText();
        if (string3 != null) {
            connectionDescriptor.put((Object)"IIOP_PORT", (Object)string3);
            stringBuffer.append(':').append(string3);
        }
        connectionDescriptor.put((Object)"URL", (Object)stringBuffer.toString());
        String string4 = this.fldTargetNode.getText();
        if (string4 != null) {
            connectionDescriptor.put((Object)"TARGET_NODE", (Object)string4);
        }
        if (ModelUtil.hasLength((String)(string = this.fldHome.getText()))) {
            string = Weblogic6Panel.getAbsolutePath(string);
            connectionDescriptor.put((Object)"OC4J_HOME", (Object)string);
        } else {
            connectionDescriptor.remove((Object)"OC4J_HOME");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btnBrowse) {
            URLChooser uRLChooser = DialogUtil.newURLChooser();
            uRLChooser.setSelectionScope(1);
            int n = uRLChooser.showOpenDialog((Component)((Object)this));
            if (n == 0) {
                String string = URLFileSystem.getPlatformPathName((URL)uRLChooser.getSelectedURL());
                File file = new File(string);
                if (file != null) {
                    string = file.getPath();
                }
                this.fldHome.setText(string);
            }
        }
    }

    protected String getDefaultWeblogicJarPath() {
        return "/BEA/wlserver6.1/lib/weblogic.jar";
    }
}

