/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.config;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.ide.config.ChangeEventSource;
import oracle.ide.util.ModelUtil;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.ConnectionFilter;
import oracle.jdevimpl.cm.dt.config.OtherJdbcDriverEntry;

public final class ConnectionOptions
extends ChangeEventSource
implements Copyable {
    public static final String KEY_SETTINGS = "ConnectionOptions";
    private boolean _validateDateTime;
    private boolean _generatePlSqlDebugInfo;
    private List _driverList;
    private Map _filterMap;
    public static final String OLD_ORACLE_JDBC_DRIVER = "oracle.jdbc.driver.OracleDriver";
    public static final String NEW_ORACLE_JDBC_DRIVER = "oracle.jdbc.OracleDriver";

    void $init$() {
        this._validateDateTime = true;
        this._generatePlSqlDebugInfo = true;
        this._driverList = new ArrayList();
        this._filterMap = new HashMap();
    }

    public ConnectionOptions() {
        this.$init$();
    }

    public Object copyTo(Object object) {
        ConnectionOptions connectionOptions = object != null ? (ConnectionOptions)((Object)object) : new ConnectionOptions();
        this.copyToImpl(connectionOptions);
        return connectionOptions;
    }

    protected final void copyToImpl(ConnectionOptions connectionOptions) {
        if (!this.equalsImpl(connectionOptions)) {
            connectionOptions._validateDateTime = this._validateDateTime;
            connectionOptions._generatePlSqlDebugInfo = this._generatePlSqlDebugInfo;
            connectionOptions._driverList.clear();
            for (OtherJdbcDriverEntry otherJdbcDriverEntry : this._driverList) {
                connectionOptions.addDriverEntry((OtherJdbcDriverEntry)((Object)otherJdbcDriverEntry.copyTo(null)));
            }
            connectionOptions.fireChangeEvent();
            connectionOptions._filterMap.clear();
            for (Object k : this._filterMap.keySet()) {
                connectionOptions._filterMap.put(k, ((ConnectionFilter)this._filterMap.get(k)).copyTo(null));
            }
        }
    }

    public boolean equals(Object object) {
        return object instanceof ConnectionOptions ? this.equalsImpl((ConnectionOptions)((Object)object)) : false;
    }

    protected boolean equalsImpl(ConnectionOptions connectionOptions) {
        return this._validateDateTime == connectionOptions._validateDateTime && this._generatePlSqlDebugInfo == connectionOptions._generatePlSqlDebugInfo && ModelUtil.areEqual((Object)this._driverList, (Object)connectionOptions._driverList) && ModelUtil.areEqual((Object)this._filterMap, (Object)connectionOptions._filterMap);
    }

    public boolean isValidateDateTime() {
        return this._validateDateTime;
    }

    public void setValidateDateTime(boolean bl) {
        this._validateDateTime = bl;
    }

    public boolean isGeneratePlSqlDebugInfo() {
        return this._generatePlSqlDebugInfo;
    }

    public void setGeneratePlSqlDebugInfo(boolean bl) {
        this._generatePlSqlDebugInfo = bl;
    }

    public List getDriverRegistry() {
        return new ArrayList(this._driverList);
    }

    public void setDriverRegistry(List list) {
        if (ModelUtil.areDifferent((Object)list, (Object)this._driverList)) {
            this._driverList.clear();
            this._driverList.addAll(list);
        }
    }

    public OtherJdbcDriverEntry findDriverEntry(String string) {
        for (OtherJdbcDriverEntry otherJdbcDriverEntry : this._driverList) {
            if (!ModelUtil.areEqual((Object)string, (Object)otherJdbcDriverEntry.getDriverClass())) continue;
            return otherJdbcDriverEntry;
        }
        return null;
    }

    public boolean addDriverEntry(OtherJdbcDriverEntry otherJdbcDriverEntry) {
        return ConnectionOptions._isValidEntry(otherJdbcDriverEntry) && !this._driverList.contains((Object)otherJdbcDriverEntry) && this._driverList.add(otherJdbcDriverEntry);
    }

    public boolean removeDriverEntry(OtherJdbcDriverEntry otherJdbcDriverEntry) {
        return this._driverList.remove((Object)otherJdbcDriverEntry);
    }

    private static boolean _isValidEntry(OtherJdbcDriverEntry otherJdbcDriverEntry) {
        return otherJdbcDriverEntry != null && ModelUtil.areDifferent((Object)OLD_ORACLE_JDBC_DRIVER, (Object)otherJdbcDriverEntry.getDriverClass()) && ModelUtil.areDifferent((Object)NEW_ORACLE_JDBC_DRIVER, (Object)otherJdbcDriverEntry.getDriverClass());
    }

    public Map getFilterMap() {
        return new HashMap(this._filterMap);
    }

    public void setFilterMap(Map map) {
        if (ModelUtil.areDifferent((Object)map, (Object)this._filterMap)) {
            this._filterMap.clear();
            this._filterMap.putAll(map);
        }
    }

    public void cacheFilter(URL uRL, ConnectionFilter connectionFilter) {
        this._filterMap.put(ConnectionOptions.convertURL(uRL), connectionFilter);
    }

    public void uncacheFilter(URL uRL) {
        this._filterMap.remove(ConnectionOptions.convertURL(uRL));
    }

    public ConnectionFilter getFilter(URL uRL) {
        return (ConnectionFilter)this._filterMap.get(ConnectionOptions.convertURL(uRL));
    }

    public void renameConnection(String string, String string2) {
        Set set = this._filterMap.keySet();
        Object[] objectArray = set.toArray();
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            if (object instanceof String) {
                Object v;
                URL uRL;
                String string3 = (String)object;
                URL uRL2 = CmUtil.newCmURL(string3);
                String string4 = CmUtil.getConnName(uRL2);
                if (ModelUtil.areEqual((Object)string, (Object)string4) && (uRL = CmUtil.renameConnection(uRL2, string2)) != null && (v = this._filterMap.remove(object)) != null) {
                    this._filterMap.put(ConnectionOptions.convertURL(uRL), v);
                }
            } else {
                this._filterMap.remove(object);
            }
            ++n;
        }
    }

    public void removeConnection(String string) {
        Iterator iterator = this._filterMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (k instanceof String) {
                String string2 = (String)k;
                String string3 = CmUtil.getConnName(CmUtil.newCmURL(string2));
                if (!ModelUtil.areEqual((Object)string, (Object)string3)) continue;
                iterator.remove();
                continue;
            }
            iterator.remove();
        }
    }

    private static String convertURL(URL uRL) {
        return CmUtil.isCMUrl(uRL) ? uRL.getFile() : null;
    }
}

