/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.controls;

import java.awt.Component;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Context;
import oracle.jdevimpl.cm.dt.controls.SubEditor;

public final class SubEditorTabbedPane
extends JTabbedPane {
    private Context _context;
    private Set _set;
    private ChangeListener _changeListener;
    private SubEditor _lastEditor;

    void $init$() {
        this._context = null;
        this._set = new HashSet();
        this._changeListener = null;
        this._lastEditor = null;
    }

    public SubEditorTabbedPane() {
        this.$init$();
        this.setTabPlacement(3);
    }

    public void open() {
        this._changeListener = new SubEditorTabbedPaneChangeListener(this);
        this.addChangeListener(this._changeListener);
        this._updateSelectedPanel();
    }

    public void activate() {
        Component component = this.getSelectedComponent();
        if (component instanceof SubEditor) {
            SubEditor subEditor = (SubEditor)((Object)component);
            subEditor.activate();
        }
    }

    public void deactivate() {
        Component component = this.getSelectedComponent();
        if (component instanceof SubEditor) {
            SubEditor subEditor = (SubEditor)((Object)component);
            subEditor.deactivate();
        }
    }

    public void close() {
        this.removeChangeListener(this._changeListener);
        this._changeListener = null;
        try {
            for (SubEditor subEditor : this._set) {
                subEditor.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setContext(Context context) {
        this._context = context;
        try {
            int n = this.getTabCount();
            int n2 = 0;
            while (n2 < n) {
                Component component = this.getComponentAt(n2);
                if (component instanceof SubEditor) {
                    SubEditor subEditor = (SubEditor)((Object)component);
                    subEditor.setContext(this._context);
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addSubEditor(SubEditor subEditor) {
        this.addTab(subEditor.getTabLabel(), subEditor.getTabIcon(), subEditor.getGUI(), subEditor.getTabDescription());
    }

    private void _updateSelectedPanel() {
        Component component = this.getSelectedComponent();
        if (component instanceof SubEditor) {
            SubEditor subEditor = (SubEditor)((Object)component);
            if (!this._set.contains(subEditor)) {
                try {
                    subEditor.setContext(this._context);
                    subEditor.open();
                    this._set.add(subEditor);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            subEditor.activate();
            if (this._lastEditor != null) {
                this._lastEditor.deactivate();
                this._lastEditor = subEditor;
            }
        }
    }

    static void mav$_updateSelectedPanel(SubEditorTabbedPane subEditorTabbedPane) {
        subEditorTabbedPane._updateSelectedPanel();
    }

    private static final class SubEditorTabbedPaneChangeListener
    implements ChangeListener {
        private SubEditorTabbedPane _parent;

        void $init$() {
            this._parent = null;
        }

        SubEditorTabbedPaneChangeListener(SubEditorTabbedPane subEditorTabbedPane) {
            this.$init$();
            this._parent = subEditorTabbedPane;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            SubEditorTabbedPane.mav$_updateSelectedPanel(this._parent);
        }
    }
}

