/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.explorer;

import java.awt.Component;
import java.util.EventObject;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import oracle.ide.Context;
import oracle.ide.explorer.Explorer;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.AccessibleUtils;
import oracle.ide.view.View;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public abstract class BaseCMExplorer
extends Explorer
implements Runnable,
Observer {
    private static final String TIMING_KEY = "BaseCMExplorer.TIMING_KEY";
    private JTree _tree;
    private JScrollPane _scrollPane;
    private boolean _observing;
    private Node _node;
    private static ThreadPoolExecutor s_pool;

    protected BaseCMExplorer() {
    }

    public Component getGUI() {
        if (this._tree == null) {
            this.createTree();
            this._scrollPane = new JScrollPane(this._tree);
            this._scrollPane.setBorder(BorderFactory.createEmptyBorder());
        }
        return this._scrollPane;
    }

    public void updateTree() {
        if (this._tree != null) {
            BaseCMExplorer.queue(this);
        }
    }

    public void run() {
        String string = this.getTitle();
        String string2 = string = string == null ? "BaseCMExplorer.run()" : string;
        if (this._tree != null) {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this._tree.getModel();
            try {
                DefaultMutableTreeNode defaultMutableTreeNode = this.buildTree();
                SwingUtilities.invokeLater(new 1(this, defaultTreeModel, defaultMutableTreeNode));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Context getContext(EventObject eventObject) {
        Context context = null;
        context = this._node != null ? Context.newIdeContext((Node)this._node) : Context.newIdeContext();
        context.setView((View)this);
        return context;
    }

    public void setContext(Context context) {
        Node node = context.getNode();
        if (node != null && this.isValidNode(node)) {
            this._node = node;
            this._tree = null;
        }
    }

    public void stateChanged(int n) {
        switch (n) {
            case 0: {
                if (this._node == null) break;
                this.updateTree();
                this.startObserving();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.stopObserving();
            }
        }
    }

    private boolean isObserving() {
        return this._observing;
    }

    private void startObserving() {
        if (!this._observing && this._node != null) {
            this._node.attach((Observer)this);
            this._observing = true;
        }
    }

    private void stopObserving() {
        if (this._observing && this._node != null) {
            this._node.detach((Observer)this);
            this._observing = false;
        }
    }

    public void update(Object object, UpdateMessage updateMessage) {
        int n;
        if (this.isObserving() && this._node != null && object == this._node && (n = updateMessage.getMessageID()) != UpdateMessage.CHILD_REMOVED && n != UpdateMessage.CHILD_ADDED && n != UpdateMessage.PROPERTY_SET && n != UpdateMessage.OBJECT_RENAMED && n != UpdateMessage.CHILD_RENAMED && n != UpdateMessage.OBJECT_OPENED && n != UpdateMessage.OBJECT_CLOSED && n != UpdateMessage.ATTRIBUTE_CHANGED && n != UpdateMessage.OBJECT_CLOSING) {
            this.updateTree();
        }
    }

    protected final Node getNode() {
        return this._node;
    }

    protected abstract boolean isValidNode(Node var1);

    protected abstract DefaultMutableTreeNode buildTree();

    protected String getAccessibleName() {
        return null;
    }

    protected TreeCellRenderer getCellRenderer() {
        return null;
    }

    private void createTree() {
        String string;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(CmWizardsArb.getString(485));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        this._tree = new JTree(defaultMutableTreeNode);
        ToolTipManager.sharedInstance().registerComponent(this._tree);
        this._tree.setRootVisible(false);
        this._tree.setShowsRootHandles(true);
        TreeCellRenderer treeCellRenderer = this.getCellRenderer();
        if (treeCellRenderer != null) {
            this._tree.setCellRenderer(treeCellRenderer);
        }
        if ((string = this.getAccessibleName()) != null) {
            AccessibleUtils.updateAccessibleName((Accessible)this._tree, (String)string, (boolean)true);
        }
    }

    private static final void queue(Runnable runnable) {
        if (s_pool == null) {
            s_pool = new ThreadPoolExecutor(2, 2, 10, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        }
        if (!s_pool.getQueue().contains(runnable)) {
            s_pool.execute(runnable);
        }
    }

    static JTree ra$_tree(BaseCMExplorer baseCMExplorer) {
        return baseCMExplorer._tree;
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ DefaultTreeModel v$treeModel;
        private final /* synthetic */ DefaultMutableTreeNode v$newRoot;
        final /* synthetic */ BaseCMExplorer this$0;

        public void run() {
            if (BaseCMExplorer.ra$_tree(this.this$0) != null) {
                this.v$treeModel.setRoot(this.v$newRoot);
                this.v$treeModel.reload();
                int n = BaseCMExplorer.ra$_tree(this.this$0).getRowCount();
                int n2 = n - 1;
                while (n2 >= 0) {
                    BaseCMExplorer.ra$_tree(this.this$0).expandRow(n2);
                    --n2;
                }
            }
        }

        public 1(BaseCMExplorer baseCMExplorer, DefaultTreeModel defaultTreeModel, DefaultMutableTreeNode defaultMutableTreeNode) {
            this.v$newRoot = defaultMutableTreeNode;
            this.v$treeModel = defaultTreeModel;
            this.this$0 = baseCMExplorer;
        }
    }
}

