/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.explorer;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.model.Attributes;
import oracle.ide.model.DefaultAttributes;
import oracle.ide.model.Element;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.jdevimpl.cm.dt.explorer.MarkAndSweeper;
import oracle.jdevimpl.cm.dt.explorer.Markable;

public class BaseElement
implements Markable,
Subject,
Element {
    private MarkAndSweeper markOwner;
    private int mark;
    private ArrayList observers;
    protected String label;
    protected String tooltip;
    protected Context context;
    protected Icon icon;
    protected int startOffset;
    protected int endOffset;

    public final boolean handleDoubleClick() {
        NavigationManager navigationManager = NavigationManager.getNavigationManager();
        OffsetNavigationPoint offsetNavigationPoint = new OffsetNavigationPoint(this.context, this.startOffset, this.startOffset != -1 ? this.endOffset - this.startOffset : 0);
        offsetNavigationPoint.setPreferredEditorType(null);
        try {
            if (navigationManager != null) {
                navigationManager.navigateTo((NavigationPoint)offsetNavigationPoint);
            } else {
                offsetNavigationPoint.navigate();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    public final Context getContext() {
        return this.context;
    }

    public final int getStartOffset() {
        return this.startOffset;
    }

    public final void setStartOffset(int n) {
        this.startOffset = n;
    }

    public final int getEndOffset() {
        return this.endOffset;
    }

    public final void setEndOffset(int n) {
        this.endOffset = n;
    }

    public final void setLabel(String string) {
        this.label = string;
        this.fireChangeUpdate(this);
    }

    public final void setTooltip(String string) {
        this.tooltip = string;
    }

    public final void fireChangeUpdate(Object object) {
        UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.PROPERTY_SET, object);
        this.notifyObservers(this, updateMessage);
    }

    void $init$() {
        this.markOwner = null;
        this.mark = -1;
        this.observers = new ArrayList();
        this.label = "N/A";
        this.tooltip = "N/A";
        this.context = null;
        this.icon = null;
        this.startOffset = -1;
        this.endOffset = -1;
    }

    public BaseElement(String string, String string2, Icon icon, Context context, int n, int n2) {
        this.$init$();
        this.setLabel(string);
        this.tooltip = string2 + string;
        this.icon = icon;
        this.context = context;
        this.startOffset = n;
        this.endOffset = n2;
    }

    public BaseElement(String string, Icon icon, Context context, int n, int n2) {
        this(string, "", icon, context, n, n2);
    }

    public final int compareTo(Object object) {
        if (object instanceof BaseElement) {
            return this.mark - ((BaseElement)object).mark;
        }
        return -1;
    }

    public final void setOwner(MarkAndSweeper markAndSweeper) {
        this.markOwner = markAndSweeper;
    }

    public final void unsetOwner() {
        this.markOwner = null;
    }

    public final void clearMark() {
        this.mark(-1);
    }

    public final void mark(int n) {
        this.mark = n;
        if (this.markOwner != null) {
            this.markOwner.markChanged();
        }
    }

    public final int getMark() {
        return this.mark;
    }

    public final Object getKey() {
        return this.label;
    }

    public Object getData() {
        return this;
    }

    public final String getShortLabel() {
        return this.label;
    }

    public final String getLongLabel() {
        return this.label;
    }

    public final Icon getIcon() {
        return this.icon;
    }

    public final String getToolTipText() {
        return this.tooltip;
    }

    public boolean mayHaveChildren() {
        return false;
    }

    public Iterator getChildren() {
        return null;
    }

    public final Attributes getAttributes() {
        return DefaultAttributes.EMPTY_ATTRIBUTES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void attach(Observer observer) {
        ArrayList arrayList = this.observers;
        synchronized (arrayList) {
            this.observers.add(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void detach(Observer observer) {
        ArrayList arrayList = this.observers;
        synchronized (arrayList) {
            int n = this.observers.indexOf(observer);
            if (n != -1) {
                this.observers.remove(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notifyObservers(Object object, UpdateMessage updateMessage) {
        ArrayList arrayList = this.observers;
        synchronized (arrayList) {
            Object object2 = updateMessage != null ? updateMessage.getOrigin() : null;
            ArrayList arrayList2 = (ArrayList)this.observers.clone();
            for (Observer observer : arrayList2) {
                if (observer == object2) continue;
                try {
                    observer.update(object, updateMessage);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public String toString() {
        return this.getShortLabel();
    }
}

