/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.explorer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import oracle.jdevimpl.cm.dt.explorer.Markable;

public final class MarkAndSweeper {
    private ArrayList sortedList;
    private HashMap hashMap;

    void $init$() {
        this.sortedList = null;
        this.hashMap = new HashMap();
    }

    public MarkAndSweeper() {
        this.$init$();
    }

    public void markChanged() {
        this.sortedList = null;
    }

    public void add(Markable markable) {
        markable.setOwner(this);
        this.hashMap.put(markable.getKey(), markable);
        this.sortedList = null;
    }

    public Markable get(Object object) {
        return (Markable)this.hashMap.get(object);
    }

    public Markable remove(Object object) {
        Markable markable = (Markable)this.hashMap.remove(object);
        if (markable != null) {
            markable.unsetOwner();
            this.sortedList = null;
        }
        return markable;
    }

    public void removeAll() {
        for (Markable markable : this.hashMap.values()) {
            markable.unsetOwner();
        }
        this.hashMap.clear();
        this.sortedList = null;
    }

    public int size() {
        return this.hashMap.size();
    }

    public void clearMarks() {
        for (Markable markable : this.hashMap.values()) {
            markable.clearMark();
        }
    }

    public ArrayList sweep() {
        ArrayList<Markable> arrayList = new ArrayList<Markable>();
        Iterator iterator = this.hashMap.values().iterator();
        while (iterator.hasNext()) {
            Markable markable = (Markable)iterator.next();
            if (markable.getMark() != -1) continue;
            markable.unsetOwner();
            arrayList.add(markable);
            iterator.remove();
        }
        if (arrayList.size() > 0) {
            this.sortedList = null;
            return arrayList;
        }
        return null;
    }

    public Iterator iterator() {
        if (this.sortedList == null) {
            this.generateSortedList();
        }
        return this.sortedList.iterator();
    }

    private void generateSortedList() {
        this.sortedList = new ArrayList();
        Iterator iterator = this.hashMap.values().iterator();
        while (iterator.hasNext()) {
            this.sortedList.add(iterator.next());
        }
        Collections.sort(this.sortedList);
    }
}

